import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.device_configuration_document import DeviceConfigurationDocument
    from ..models.device_configuration_template_tags import DeviceConfigurationTemplateTags


T = TypeVar("T", bound="DeviceConfigurationTemplate")


@attr.s(auto_attribs=True)
class DeviceConfigurationTemplate:
    """
    Attributes:
        name (str):
        document (DeviceConfigurationDocument):
        tags (DeviceConfigurationTemplateTags):
        organization_id (Union[Unset, str]):
        enabled (Union[Unset, bool]):
        id (Union[Unset, str]):
        created_at (Union[Unset, datetime.datetime]):
        updated_at (Union[Unset, datetime.datetime]):
    """

    name: str
    document: "DeviceConfigurationDocument"
    tags: "DeviceConfigurationTemplateTags"
    organization_id: Union[Unset, str] = UNSET
    enabled: Union[Unset, bool] = UNSET
    id: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    updated_at: Union[Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        name = self.name
        document = self.document.to_dict()

        tags = self.tags.to_dict()

        organization_id = self.organization_id
        enabled = self.enabled
        id = self.id
        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        updated_at: Union[Unset, str] = UNSET
        if not isinstance(self.updated_at, Unset):
            updated_at = self.updated_at.isoformat()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "document": document,
                "tags": tags,
            }
        )
        if organization_id is not UNSET:
            field_dict["organizationId"] = organization_id
        if enabled is not UNSET:
            field_dict["enabled"] = enabled
        if id is not UNSET:
            field_dict["id"] = id
        if created_at is not UNSET:
            field_dict["createdAt"] = created_at
        if updated_at is not UNSET:
            field_dict["updatedAt"] = updated_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.device_configuration_document import DeviceConfigurationDocument
        from ..models.device_configuration_template_tags import DeviceConfigurationTemplateTags

        d = src_dict.copy()
        name = d.pop("name")

        document = DeviceConfigurationDocument.from_dict(d.pop("document"))

        tags = DeviceConfigurationTemplateTags.from_dict(d.pop("tags"))

        organization_id = d.pop("organizationId", UNSET)

        enabled = d.pop("enabled", UNSET)

        id = d.pop("id", UNSET)

        _created_at = d.pop("createdAt", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        _updated_at = d.pop("updatedAt", UNSET)
        updated_at: Union[Unset, datetime.datetime]
        if isinstance(_updated_at, Unset):
            updated_at = UNSET
        else:
            updated_at = isoparse(_updated_at)

        device_configuration_template = cls(
            name=name,
            document=document,
            tags=tags,
            organization_id=organization_id,
            enabled=enabled,
            id=id,
            created_at=created_at,
            updated_at=updated_at,
        )

        device_configuration_template.additional_properties = d
        return device_configuration_template

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
