import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.command_template_parameter_meta import CommandTemplateParameterMeta
    from ..models.command_template_tags import CommandTemplateTags


T = TypeVar("T", bound="CommandTemplate")


@attr.s(auto_attribs=True)
class CommandTemplate:
    """
    Attributes:
        name (str):
        command (str):
        tags (CommandTemplateTags):
        parameter_enabled (bool):
        organization_id (Union[Unset, str]):
        description (Union[Unset, str]):
        parameter_value (Union[Unset, str]):
        parameter_meta (Union[Unset, CommandTemplateParameterMeta]):
        enabled (Union[Unset, bool]):
        id (Union[Unset, str]):
        created_at (Union[Unset, datetime.datetime]):
        updated_at (Union[Unset, datetime.datetime]):
    """

    name: str
    command: str
    tags: "CommandTemplateTags"
    parameter_enabled: bool
    organization_id: Union[Unset, str] = UNSET
    description: Union[Unset, str] = UNSET
    parameter_value: Union[Unset, str] = UNSET
    parameter_meta: Union[Unset, "CommandTemplateParameterMeta"] = UNSET
    enabled: Union[Unset, bool] = UNSET
    id: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    updated_at: Union[Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        name = self.name
        command = self.command
        tags = self.tags.to_dict()

        parameter_enabled = self.parameter_enabled
        organization_id = self.organization_id
        description = self.description
        parameter_value = self.parameter_value
        parameter_meta: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.parameter_meta, Unset):
            parameter_meta = self.parameter_meta.to_dict()

        enabled = self.enabled
        id = self.id
        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        updated_at: Union[Unset, str] = UNSET
        if not isinstance(self.updated_at, Unset):
            updated_at = self.updated_at.isoformat()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "command": command,
                "tags": tags,
                "parameterEnabled": parameter_enabled,
            }
        )
        if organization_id is not UNSET:
            field_dict["organizationId"] = organization_id
        if description is not UNSET:
            field_dict["description"] = description
        if parameter_value is not UNSET:
            field_dict["parameterValue"] = parameter_value
        if parameter_meta is not UNSET:
            field_dict["parameterMeta"] = parameter_meta
        if enabled is not UNSET:
            field_dict["enabled"] = enabled
        if id is not UNSET:
            field_dict["id"] = id
        if created_at is not UNSET:
            field_dict["createdAt"] = created_at
        if updated_at is not UNSET:
            field_dict["updatedAt"] = updated_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.command_template_parameter_meta import CommandTemplateParameterMeta
        from ..models.command_template_tags import CommandTemplateTags

        d = src_dict.copy()
        name = d.pop("name")

        command = d.pop("command")

        tags = CommandTemplateTags.from_dict(d.pop("tags"))

        parameter_enabled = d.pop("parameterEnabled")

        organization_id = d.pop("organizationId", UNSET)

        description = d.pop("description", UNSET)

        parameter_value = d.pop("parameterValue", UNSET)

        _parameter_meta = d.pop("parameterMeta", UNSET)
        parameter_meta: Union[Unset, CommandTemplateParameterMeta]
        if isinstance(_parameter_meta, Unset):
            parameter_meta = UNSET
        else:
            parameter_meta = CommandTemplateParameterMeta.from_dict(_parameter_meta)

        enabled = d.pop("enabled", UNSET)

        id = d.pop("id", UNSET)

        _created_at = d.pop("createdAt", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        _updated_at = d.pop("updatedAt", UNSET)
        updated_at: Union[Unset, datetime.datetime]
        if isinstance(_updated_at, Unset):
            updated_at = UNSET
        else:
            updated_at = isoparse(_updated_at)

        command_template = cls(
            name=name,
            command=command,
            tags=tags,
            parameter_enabled=parameter_enabled,
            organization_id=organization_id,
            description=description,
            parameter_value=parameter_value,
            parameter_meta=parameter_meta,
            enabled=enabled,
            id=id,
            created_at=created_at,
            updated_at=updated_at,
        )

        command_template.additional_properties = d
        return command_template

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
