from http import HTTPStatus
from typing import Any, Dict

import httpx

from ...client import AuthenticatedClient
from ...types import Response


def _get_kwargs(
    code: str,
    *,
    client: AuthenticatedClient,
) -> Dict[str, Any]:
    url = "{}/shares/{code}".format(client.base_url, code=code)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    return {
        "method": "delete",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
    }


def _build_response(*, response: httpx.Response) -> Response[Any]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=None,
    )


def sync_detailed(
    code: str,
    *,
    client: AuthenticatedClient,
) -> Response[Any]:
    """Delete

     Revoke a share
    Resource: share
    Authorized roles: operator

    Args:
        code (str):

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        code=code,
        client=client,
    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)


async def asyncio_detailed(
    code: str,
    *,
    client: AuthenticatedClient,
) -> Response[Any]:
    """Delete

     Revoke a share
    Resource: share
    Authorized roles: operator

    Args:
        code (str):

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        code=code,
        client=client,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(**kwargs)

    return _build_response(response=response)
