"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_rds_1 = require("monocdk/aws-rds");
/**
 *  RDS instances and Aurora clusters have Deletion Protection enabled - (Control ID: SC-5)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.deletionProtection == undefined) {
            return false;
        }
        const deletionProtection = monocdk_1.Stack.of(node).resolve(node.deletionProtection);
        if (deletionProtection === false) {
            return false;
        }
        return true;
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        const deletionProtection = monocdk_1.Stack.of(node).resolve(node.deletionProtection);
        if ((deletionProtection == false || deletionProtection == undefined) &&
            (node.engine == undefined ||
                !node.engine.toLowerCase().includes('aurora'))) {
            return false;
        }
        return true;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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