"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_iam_1 = require("monocdk/aws-iam");
/**
 * IAM policies are not attached at the user level - (Control IDs: AC-2(j), AC-3, AC-5c, AC-6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnPolicy || node instanceof aws_iam_1.CfnManagedPolicy) {
        const policyUsers = monocdk_1.Stack.of(node).resolve(node.users);
        if (policyUsers != undefined) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzSUFNVXNlck5vUG9saWNpZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvTklTVC04MDAtNTMvcnVsZXMvaWFtL25pc3Q4MDA1M0lBTVVzZXJOb1BvbGljaWVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTRDO0FBQzVDLDZDQUE4RDtBQUU5RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBZ0I7SUFDdkMsSUFBSSxJQUFJLFlBQVksbUJBQVMsSUFBSSxJQUFJLFlBQVksMEJBQWdCLEVBQUU7UUFDakUsTUFBTSxXQUFXLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRXZELElBQUksV0FBVyxJQUFJLFNBQVMsRUFBRTtZQUM1QixPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFFRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFWRCw0QkFVQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgSUNvbnN0cnVjdCwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmblBvbGljeSwgQ2ZuTWFuYWdlZFBvbGljeSB9IGZyb20gJ21vbm9jZGsvYXdzLWlhbSc7XG5cbi8qKlxuICogSUFNIHBvbGljaWVzIGFyZSBub3QgYXR0YWNoZWQgYXQgdGhlIHVzZXIgbGV2ZWwgLSAoQ29udHJvbCBJRHM6IEFDLTIoaiksIEFDLTMsIEFDLTVjLCBBQy02KVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBJQ29uc3RydWN0KTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUG9saWN5IHx8IG5vZGUgaW5zdGFuY2VvZiBDZm5NYW5hZ2VkUG9saWN5KSB7XG4gICAgY29uc3QgcG9saWN5VXNlcnMgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUudXNlcnMpO1xuXG4gICAgaWYgKHBvbGljeVVzZXJzICE9IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiB0cnVlO1xufVxuIl19