"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_cloudwatch_1 = require("monocdk/aws-cloudwatch");
/**
 * CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled - (Control IDs: AC-2(4), AU-6(1)(3), AU-7(1), CA-7(a)(b), IR-4(1), SI-4(2), SI-4(4), SI-4(5), SI-4(a)(b)(c))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudwatch_1.CfnAlarm) {
        const actionsEnabled = monocdk_1.Stack.of(node).resolve(node.actionsEnabled);
        if (actionsEnabled === false) {
            return false;
        }
        // Actions can be an array with a token that then resolves to an empty array or undefined
        const alarmActions = monocdk_1.Stack.of(node).resolve(node.alarmActions);
        const insufficientDataActions = monocdk_1.Stack.of(node).resolve(node.insufficientDataActions);
        const okActions = monocdk_1.Stack.of(node).resolve(node.okActions);
        const totalAlarmActions = alarmActions ? alarmActions.length : 0;
        const totalInsufficientDataActions = insufficientDataActions
            ? insufficientDataActions.length
            : 0;
        const totalOkActions = okActions ? okActions.length : 0;
        const totalActions = totalAlarmActions + totalInsufficientDataActions + totalOkActions;
        if (totalActions == 0) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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