"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancing_1 = require("monocdk/aws-elasticloadbalancing");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
/**
 * ELBs have access logs enabled - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancing_1.CfnLoadBalancer) {
        if (node.accessLoggingPolicy == undefined) {
            return false;
        }
        const accessLoggingPolicy = monocdk_1.Stack.of(node).resolve(node.accessLoggingPolicy);
        const enabled = monocdk_1.Stack.of(node).resolve(accessLoggingPolicy.enabled);
        if (enabled == false) {
            return false;
        }
    }
    else if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
        const reg = /"access_logs\.s3\.enabled","value":"true"/gm;
        if (JSON.stringify(attributes).search(reg) == -1) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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