"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
/**
 * Auto Scaling groups which are associated with load balancers utilize ELB health checks - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        //get all associated CLBs
        const classicLBs = monocdk_1.Stack.of(node).resolve(node.loadBalancerNames);
        //get all associated Application LBs, Gateway LBs, and Network LBs
        const otherLBs = monocdk_1.Stack.of(node).resolve(node.targetGroupArns);
        if ((otherLBs != undefined && otherLBs.length > 0) ||
            (classicLBs != undefined && classicLBs.length > 0)) {
            const healthCheckType = monocdk_1.Stack.of(node).resolve(node.healthCheckType);
            //Do we use ELB health checks?
            if (healthCheckType != undefined) {
                if (healthCheckType != 'ELB') {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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