"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_apigateway_1 = require("monocdk/aws-apigateway");
/**
 * All methods in API Gateway stages have caching enabled and encrypted - (Control IDs: 164.312(a)(2)(iv), 164.312(e)(2)(ii))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_apigateway_1.CfnStage) {
        if (node.methodSettings == undefined) {
            return false;
        }
        const methodSettings = monocdk_1.Stack.of(node).resolve(node.methodSettings);
        let found = false;
        for (const setting of methodSettings) {
            const resolvedSetting = monocdk_1.Stack.of(node).resolve(setting);
            if ((resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.httpMethod) == '*' &&
                (resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.resourcePath) == '/*' && (resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.cacheDataEncrypted) && (resolvedSetting === null || resolvedSetting === void 0 ? void 0 : resolvedSetting.cachingEnabled)) {
                found = true;
                break;
            }
        }
        if (!found) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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