"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
/**
 * Auto Scaling Groups have notifications for all scaling events configured
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        if (node.notificationConfigurations == undefined) {
            return false;
        }
        const notificationConfigurations = monocdk_1.Stack.of(node).resolve(node.notificationConfigurations);
        const requiredEvents = [
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH,
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH_ERROR,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE_ERROR,
        ];
        return requiredEvents.every((req) => {
            return notificationConfigurations.some((config) => {
                var _a;
                return (_a = config.notificationTypes) === null || _a === void 0 ? void 0 : _a.includes(req);
            });
        });
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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