"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cloud9_1 = require("monocdk/aws-cloud9");
/**
 * Cloud9 instances use no-ingress EC2 instances with AWS Systems Manager
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloud9_1.CfnEnvironmentEC2) {
        const connectionType = monocdk_1.Stack.of(node).resolve(node.connectionType);
        if (connectionType == undefined || connectionType != 'CONNECT_SSM') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQzkxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9kZXZlbG9wZXJfdG9vbHMvQzkxLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTRDO0FBQzVDLG1EQUF1RDtBQUV2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBZ0I7SUFDdkMsSUFBSSxJQUFJLFlBQVksOEJBQWlCLEVBQUU7UUFDckMsTUFBTSxjQUFjLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ25FLElBQUksY0FBYyxJQUFJLFNBQVMsSUFBSSxjQUFjLElBQUksYUFBYSxFQUFFO1lBQ2xFLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVJELDRCQVFDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBJQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuRW52aXJvbm1lbnRFQzIgfSBmcm9tICdtb25vY2RrL2F3cy1jbG91ZDknO1xuXG4vKipcbiAqIENsb3VkOSBpbnN0YW5jZXMgdXNlIG5vLWluZ3Jlc3MgRUMyIGluc3RhbmNlcyB3aXRoIEFXUyBTeXN0ZW1zIE1hbmFnZXJcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogSUNvbnN0cnVjdCk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkVudmlyb25tZW50RUMyKSB7XG4gICAgY29uc3QgY29ubmVjdGlvblR5cGUgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUuY29ubmVjdGlvblR5cGUpO1xuICAgIGlmIChjb25uZWN0aW9uVHlwZSA9PSB1bmRlZmluZWQgfHwgY29ubmVjdGlvblR5cGUgIT0gJ0NPTk5FQ1RfU1NNJykge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==