"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
/**
 * OpenSearch Service domains minimally publish SEARCH_SLOW_LOGS and INDEX_SLOW_LOGS to CloudWatch Logs
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const logPublishingOptions = monocdk_1.Stack.of(node).resolve(node.logPublishingOptions);
        if (logPublishingOptions == undefined) {
            return false;
        }
        const requiredSlowLogs = [
            logPublishingOptions === null || logPublishingOptions === void 0 ? void 0 : logPublishingOptions.SEARCH_SLOW_LOGS,
            logPublishingOptions === null || logPublishingOptions === void 0 ? void 0 : logPublishingOptions.INDEX_SLOW_LOGS,
        ];
        for (const log of requiredSlowLogs) {
            const resolvedLog = monocdk_1.Stack.of(node).resolve(log);
            if (resolvedLog == undefined) {
                return false;
            }
            const enabled = monocdk_1.Stack.of(node).resolve(resolvedLog.enabled);
            if (!enabled) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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