"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InputValidator = void 0;
/**
 * Class to validate that inputs match requirements.
 */
class InputValidator {
    /**
     * Validates length is between allowed min and max lengths.
     */
    static validateLength(resourceName, inputName, minLength, maxLength, inputString) {
        if (inputString !== undefined && (inputString.length < minLength || inputString.length > maxLength)) {
            throw new Error(`Invalid ${inputName} for resource ${resourceName}, must have length between ${minLength} and ${maxLength}, got: '${this.truncateString(inputString, 100)}'`);
        }
    }
    static truncateString(string, maxLength) {
        if (string.length > maxLength) {
            return string.substring(0, maxLength) + '[truncated]';
        }
        return string;
    }
}
exports.InputValidator = InputValidator;
//# sourceMappingURL=data:application/json;base64,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