import * as iam from '@aws-cdk/aws-iam';
import { IResource, Resource } from '@aws-cdk/core';
import { AcceptLanguage } from './common';
import { Construct } from 'constructs';
/**
 * (experimental) Options for portfolio share.
 *
 * @experimental
 */
export interface PortfolioShareOptions {
    /**
     * (experimental) Whether to share tagOptions as a part of the portfolio share.
     *
     * @default - share not specified
     * @experimental
     */
    readonly shareTagOptions?: boolean;
    /**
     * (experimental) The accept language of the share.
     *
     * @default - accept language not specified
     * @experimental
     */
    readonly acceptLanguage?: AcceptLanguage;
}
/**
 * (experimental) A Service Catalog portfolio.
 *
 * @experimental
 */
export interface IPortfolio extends IResource {
    /**
     * (experimental) The ARN of the portfolio.
     *
     * @experimental
     * @attribute true
     */
    readonly portfolioArn: string;
    /**
     * (experimental) The ID of the portfolio.
     *
     * @experimental
     * @attribute true
     */
    readonly portfolioId: string;
    /**
     * (experimental) Associate portfolio with an IAM Role.
     *
     * @param role an IAM role.
     * @experimental
     */
    giveAccessToRole(role: iam.IRole): void;
    /**
     * (experimental) Associate portfolio with an IAM User.
     *
     * @param user an IAM user.
     * @experimental
     */
    giveAccessToUser(user: iam.IUser): void;
    /**
     * (experimental) Associate portfolio with an IAM Group.
     *
     * @param group an IAM Group.
     * @experimental
     */
    giveAccessToGroup(group: iam.IGroup): void;
    /**
     * (experimental) Initiate a portfolio share with another account.
     *
     * @param accountId AWS account to share portfolio with.
     * @param options Options for the initiate share.
     * @experimental
     */
    shareWithAccount(accountId: string, options?: PortfolioShareOptions): void;
}
declare abstract class PortfolioBase extends Resource implements IPortfolio {
    abstract readonly portfolioArn: string;
    abstract readonly portfolioId: string;
    private readonly associatedPrincipals;
    /**
     * (experimental) Associate portfolio with an IAM Role.
     *
     * @experimental
     */
    giveAccessToRole(role: iam.IRole): void;
    /**
     * (experimental) Associate portfolio with an IAM User.
     *
     * @experimental
     */
    giveAccessToUser(user: iam.IUser): void;
    /**
     * (experimental) Associate portfolio with an IAM Group.
     *
     * @experimental
     */
    giveAccessToGroup(group: iam.IGroup): void;
    /**
     * (experimental) Initiate a portfolio share with another account.
     *
     * @experimental
     */
    shareWithAccount(accountId: string, options?: PortfolioShareOptions): void;
    /**
     * Associate a principal with the portfolio.
     * If the principal is already associated, it will skip.
     */
    private associatePrincipal;
    /**
     * Create a unique id based off the L1 CfnPortfolio or the arn of an imported portfolio.
     */
    protected abstract generateUniqueHash(value: string): string;
}
/**
 * (experimental) Properties for a Portfolio.
 *
 * @experimental
 */
export interface PortfolioProps {
    /**
     * (experimental) The name of the portfolio.
     *
     * @experimental
     */
    readonly displayName: string;
    /**
     * (experimental) The provider name.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * (experimental) The accept language.
     *
     * @default - No accept language provided
     * @experimental
     */
    readonly acceptLanguage?: AcceptLanguage;
    /**
     * (experimental) Description for portfolio.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) A Service Catalog portfolio.
 *
 * @experimental
 */
export declare class Portfolio extends PortfolioBase {
    /**
     * (experimental) Creates a Portfolio construct that represents an external portfolio.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param portfolioArn the Amazon Resource Name of the existing portfolio.
     * @experimental
     */
    static fromPortfolioArn(scope: Construct, id: string, portfolioArn: string): IPortfolio;
    /**
     * (experimental) The ARN of the portfolio.
     *
     * @experimental
     */
    readonly portfolioArn: string;
    /**
     * (experimental) The ID of the portfolio.
     *
     * @experimental
     */
    readonly portfolioId: string;
    private readonly portfolio;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PortfolioProps);
    /**
     * (experimental) Create a unique id based off the L1 CfnPortfolio or the arn of an imported portfolio.
     *
     * @experimental
     */
    protected generateUniqueHash(value: string): string;
    private validatePortfolioProps;
}
export {};
