# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytenno', 'pytenno._backends', 'pytenno.interface', 'pytenno.models']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.1,<4.0.0']

setup_kwargs = {
    'name': 'pytenno',
    'version': '0.1.3',
    'description': 'A asynchronous Python library for interacting with the warframe.market API',
    'long_description': '# PyTenno\nPyTenno is an asynchronous wrapper for the [warframe.market](https://warframe.market) API, written in Python.\n\n[Read Documentation](https://pytenno.readthedocs.io/en/latest/index.html)\n\n### Disclaimer\nPyTenno is not associated with warframe.market or any of its affiliates.\nPyTenno is not associated with Digital Extremes or any of its affiliates.\n\n## Installation\n\n### Git\nUse your favorite spice of the following:\n\n```bash\npy -m pip install git+https://github.com/ShadowMagic896/pytenno.git\n```\n- [Git-SCM](https://git-scm.com/) is required for direct installation\n\n### PyPi\n\n```bash\npy -m pip install pytenno\n```\n\n## Requirements\nThe project\'s only requirement is aiohttp, which is available on PyPi.\n\n[aiohttp](https://aiohttp.readthedocs.io/en/stable/index.html) >= 3.8.1\n\n## Skill-Set Requirements\n\n### PyTenno Requires Fundamental understanding of the following:\n1. Python datatypes, attributes, etc.\n2. Asyncrhonous programming in Python (Coroutines, `async`, `await`)\n3. Fundamental understanding of context managers in Python (`async with`)\n4. How [warframe.market](https://warframe.market) works \n5. [Warframe](https://warframe.com/) mechanics\n\n## Examples\n\n### The Following Code Will Be Used in the Examples\n```python\n\nimport asyncio # To use asynchronous programming\nimport pytenno\nfrom pytenno.models.enums import Platform # To specify platforms for requests\n\nasync def main(): # PyTenno is asynchronous, so it must be done in an asynchronous context\n    default_language = "en" # Set default response language to English\n    default_platform = Platform.pc # Set default platform to PC\n\n    # Create a client with the default language and platform\n    # This must be done in an asynchronous context manager (async with ... [as ...])\n    async with pytenno.PyTenno(default_language, default_platform) as tenno:\n        ... # Example code goes here\n    \nif __name__ == "__main__":\n    asyncio.run(main()) # Create a new asyncio loop and run the coroutine\n```\n\n### Log into warframe.market\n```python\n        email = "you@example.com" # Email to account\n        password = "password123" # Password to account\n        current_user = await tenno.Auth.login(\n            email=email,\n            password=password\n        ) # Log in to warframe.market\n        # Note: the API stores absoloutely zero information about data passed. All code\n        # is open-source and available at https://github.com/ShadowMagic896/pytenno\n        print(current_user.ingame_name) # Print the ingame name of the user that was logged in\n```\n\n\n',
    'author': 'Ryan Peckham',
    'author_email': '86629697+ShadowMagic896@users.noreply.github.com',
    'maintainer': 'Ryan Peckham',
    'maintainer_email': '86629697+ShadowMagic896@users.noreply.github.com',
    'url': 'https://github.com/ShadowMagic896/pytenno',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
}


setup(**setup_kwargs)
