# This package will contain the spiders of your Scrapy project
#
# Please refer to the documentation for information on how to create and manage
# your spiders.

import scrapy
from os_scrapy_linkextractor.lx_extensions import LxExtensionManager
from os_scrapy_record.items import fetch_record


class ExampleSpider(scrapy.Spider):
    """ ExampleSpider
    Auto generated by os-scrapy-cookiecuter

    Run:
        scrapy crawl example
    """

    name = "example"

    def start_requests(self):
        yield scrapy.Request(
            url="http://club.news.sohu.com/zz2253/threads",
            meta={
                "pod.addr": "http://127.0.0.1:6789/api/queue/batchEnqueue/",
                'depth': 0,
          'download_latency': 0.11835575103759766,
          'download_slot': 'www.gushiwen.cn',
          'download_timeout': 180.0,
          'extractor.depth_limit': 3,
          'extractor.links': [['http://12365.ce.cn/zlpd/jdgl/202101/08/t20210108_7302000.shtml',
                               'http://12365.ce.cn/zlpd/qwfb/',
                               'http://12365.ce.cn/zlpd/jdgl/202101/14/t20210114_7302748.shtml',
                               'http://www.ce.cn/about/jjw/one/200907/03/t20090703_19456236.shtml',
                               'http://12365.ce.cn/zlpd/jdgl/202101/08/t20210108_7301998.shtml',
                               'http://12365.ce.cn/zlpd/zlsp/202101/15/t20210115_7302890.shtml',
                               'http://12365.ce.cn/zlpd/jdgl/202101/21/t20210121_7303606.shtml',
                               'http://12365.ce.cn/zlpd/qwfb/202101/07/t20210107_7301851.shtml',
                               'http://12365.ce.cn/zlpd/rzbz/202101/22/t20210122_7303769.shtml',
                               'http://12365.ce.cn/zlpd/jrgx/202101/25/t20210125_7303993.shtml',
                               'http://12365.ce.cn/zlpd/yw/yw/202101/06/t20210106_7301658.shtml',
                               'http://12365.ce.cn/zlpd/yw/yw/202101/07/t20210107_7301857.shtml',
                               'http://www.chinatt315.org.cn/315/',
                               'http://12365.ce.cn/zlpd/jdgl/202101/13/t20210113_7302579.shtml',
                               'http://12365.ce.cn/zlpd/jdgl/202101/07/t20210107_7301862.shtml',
                               'http://www.ce.cn/cysc/ztpd/2020zt/sbtjh/index.shtml',
                               'http://www.dajialawyer.com',
                               'http://12365.ce.cn/zlpd/jsxx/202101/19/t20210119_7303317.shtml']],
          'extractor.rules': [{'allow': [],
                               'allow_domains': [],
                               'deny': [],
                               'deny_domains': [],
                               'id': '36b763c3-c189-4070-9fe4-917dd7331bf8',
                               'meta': {
                                        "pod.addr": "http://127.0.0.1:6789/api/queue/batchEnqueue/",
                                        'named.group': '古诗文',
                                        'named.tag': '列表页'},
                               'restrict_css': ['.pagesright > .amore'],
                               'restrict_xpaths': [],
                               'type': 'lxml'},
                              {'allow': [],
                               'allow_domains': [],
                               'deny': [],
                               'deny_domains': [],
                               'id': 'ad1b0773-c6bb-4f39-92f7-e30ef0a43815',
                               'meta': {
                                        "pod.addr": "http://127.0.0.1:6789/api/queue/batchEnqueue/",
                                        'named.group': '古诗文',
                                        'named.tag': '列表页'},
                               'restrict_css': ['.sons > .cont > '
                                                'p:first-of-type > a'],
                               'restrict_xpaths': [],
                               'type': 'lxml'}]},
        )

    def parse(self, response):
        response = self.lx_manager.process_response(response)
        yield fetch_record(response=response)

    def _set_lxmanager(self, crawler):
        self.lx_manager = LxExtensionManager.from_crawler(crawler)

    @classmethod
    def from_crawler(cls, crawler, *args, **kwargs):
        spider = super().from_crawler(crawler, *args, **kwargs)
        spider._set_lxmanager(crawler)
        return spider
