from typing import Any, Type
from . import base, threadlocal

strategies: Any = ...

class EngineStrategy(object):
    def __init__(self) -> None: ...
    def create(self, *args, **kwargs): ...

class DefaultEngineStrategy(EngineStrategy):
    def create(self, name_or_url, **kwargs): ...

class PlainEngineStrategy(DefaultEngineStrategy):
    name: str
    engine_cls: Type[base.Engine]

class ThreadLocalEngineStrategy(DefaultEngineStrategy):
    name: str = ...
    engine_cls: Type[threadlocal.TLEngine] = ...

class MockEngineStrategy(EngineStrategy):
    name: str = ...
    def create(self, name_or_url, executor, **kwargs) -> MockEngineStrategy.MockConnection: ...  # type: ignore
    class MockConnection(base.Connectable):
        execute: Any = ...
        def __init__(self, dialect, execute) -> None: ...
        engine: Any = ...
        dialect: Any = ...
        name: str = ...
        schema_for_object: Any = ...
        def contextual_connect(self, **kwargs): ...
        def execution_options(self, **kw): ...
        def compiler(self, statement, parameters, **kwargs): ...
        def create(self, entity, **kwargs): ...
        def drop(self, entity, **kwargs): ...
