"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const core_1 = require("@aws-cdk/core");
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_a = props.masterSecret) === null || _a === void 0 ? void 0 : _a.secretArn
                }),
                generateStringKey: 'password',
                excludeCharacters: '"@/\\'
            }
        });
    }
}
exports.DatabaseSecret = DatabaseSecret;
//# sourceMappingURL=data:application/json;base64,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