# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class TransactionFee(BaseModel):
    """
    TransactionFee
    """
    gas_limit: Optional[StrictStr] = Field(None, alias="gasLimit", description="The maximum units of gas to use for the transaction. Required if `feeLevel` is not provided. Estimates for this limit can be obtained through the `POST /transactions/transfer/estimateFee` API. GasLimit override (only supported for EOA wallets): Using `gasLimit` together with `feeLevel`, the provided `gasLimit` is required to be greater or equal to `feeLevel` estimation and will override the estimation's gasLimit. ")
    gas_price: Optional[StrictStr] = Field(None, alias="gasPrice", description="For blockchains without EIP-1559 support, the maximum price of gas, in gwei, to use per each unit of gas (see `gasLimit`). Requires `gasLimit`. Cannot be used with `feeLevel`, `priorityFee`, or `maxFee`. Estimates for this fee can be obtained through the `POST /transactions/transfer/estimateFee` API. ")
    max_fee: Optional[StrictStr] = Field(None, alias="maxFee", description="For blockchains with EIP-1559 support, the maximum price per unit of gas (see `gasLimit`), in gwei. Requires `priorityFee`, and `gasLimit` to be present. Cannot be used with `feeLevel` or `gasPrice`. Estimates for this fee can be obtained through the `POST /transactions/transfer/estimateFee` API. ")
    priority_fee: Optional[StrictStr] = Field(None, alias="priorityFee", description="For blockchains with EIP-1559 support, the “tip”, in gwei, to add to the base fee as an incentive for validators. Please note that the `maxFee` and `gasLimit` parameters are required alongside the `priorityFee`. The `feeLevel` and `gasPrice` parameters cannot be used with the `priorityFee`.  Estimations for this fee can be obtained through the `POST /transactions/transfer/estimateFee` API. ")
    base_fee: Optional[StrictStr] = Field(None, alias="baseFee", description="For blockchains with EIP-1559 support, the estimated base fee represents the minimum fee required for a transaction to be included in a block on the blockchain.  It is measured in gwei and compensates for the computational resources validators consume to process the transaction.  The base fee is supplemented by a separate \"tip\" called the priority fee, which acts as an extra incentive for validators to prioritize the transaction.  The priority fee is added to the base fee to calculate the final transaction fee. ")
    network_fee: Optional[StrictStr] = Field(None, alias="networkFee", description="The estimated network fee is the maximum amount of cryptocurrency (such as ETH, ARB, or SOL) that you will pay for your transaction. This fee depends on the parameters you set, including Gas Limit, Priority Fee, and Max Fee. It compensates for the computational resources that validators consume to process the transaction. It is measured in native token such as ETH, SOL. Each blockchain might use different formula for network fee. Refer to each specific blockchain's documentation to understand how `networkFee` is calculated. ")
    __properties = ["gasLimit", "gasPrice", "maxFee", "priorityFee", "baseFee", "networkFee"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionFee:
        """Create an instance of TransactionFee from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionFee:
        """Create an instance of TransactionFee from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionFee.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = TransactionFee.parse_obj({
            "gas_limit": obj.get("gasLimit"),
            "gas_price": obj.get("gasPrice"),
            "max_fee": obj.get("maxFee"),
            "priority_fee": obj.get("priorityFee"),
            "base_fee": obj.get("baseFee"),
            "network_fee": obj.get("networkFee")
        })
        return _obj


