# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from circle.web3.smart_contract_platform.models.abi_parameters_inner import AbiParametersInner
from circle.web3.smart_contract_platform.models.blockchain import Blockchain

class ReadContractStateRequest(BaseModel):
    """
    ReadContractStateRequest
    """
    abi_function_signature: Optional[StrictStr] = Field(None, alias="abiFunctionSignature", description="The contract ABI function signature or `callData` field is required for interacting with the smart contract. The ABI function signature cannot be used simultaneously with `callData`. e.g. burn(uint256)")
    abi_parameters: Optional[conlist(AbiParametersInner)] = Field(None, alias="abiParameters", description="The contract ABI function signature parameters for executing the contract interaction. Supported parameter types include string, integer, boolean, and array. These parameters should be used exclusively with the abiFunctionSignature and cannot be used with `callData`.")
    abi_json: Optional[StrictStr] = Field(None, alias="abiJson", description="The contract's ABI in a JSON stringified format.")
    address: StrictStr = Field(..., description="Address of the contract to be queried.")
    blockchain: Blockchain = Field(...)
    call_data: Optional[StrictStr] = Field(None, alias="callData", description="CallData is input data that encodes method and parameters.")
    from_address: Optional[StrictStr] = Field(None, alias="fromAddress", description="FromAddress is the address that will populate msg.sender in the contract call.")
    __properties = ["abiFunctionSignature", "abiParameters", "abiJson", "address", "blockchain", "callData", "fromAddress"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReadContractStateRequest:
        """Create an instance of ReadContractStateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in abi_parameters (list)
        _items = []
        if self.abi_parameters:
            for _item in self.abi_parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['abiParameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReadContractStateRequest:
        """Create an instance of ReadContractStateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReadContractStateRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = ReadContractStateRequest.parse_obj({
            "abi_function_signature": obj.get("abiFunctionSignature"),
            "abi_parameters": [AbiParametersInner.from_dict(_item) for _item in obj.get("abiParameters")] if obj.get("abiParameters") is not None else None,
            "abi_json": obj.get("abiJson"),
            "address": obj.get("address"),
            "blockchain": obj.get("blockchain"),
            "call_data": obj.get("callData"),
            "from_address": obj.get("fromAddress")
        })
        return _obj


