# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from circle.web3.smart_contract_platform.models.event_log import EventLog

class EventLogsData(BaseModel):
    """
    EventLogsData
    """
    event_logs: conlist(EventLog) = Field(..., alias="eventLogs", description="A list of event logs generated from the specified contract events.")
    __properties = ["eventLogs"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventLogsData:
        """Create an instance of EventLogsData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in event_logs (list)
        _items = []
        if self.event_logs:
            for _item in self.event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['eventLogs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventLogsData:
        """Create an instance of EventLogsData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EventLogsData.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = EventLogsData.parse_obj({
            "event_logs": [EventLog.from_dict(_item) for _item in obj.get("eventLogs")] if obj.get("eventLogs") is not None else None
        })
        return _obj


