# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from circle.web3.smart_contract_platform.models.blockchain import Blockchain

class EventLog(BaseModel):
    """
    EventLog
    """
    id: StrictStr = Field(...)
    block_hash: StrictStr = Field(..., alias="blockHash")
    block_height: StrictInt = Field(..., alias="blockHeight")
    blockchain: Blockchain = Field(...)
    contract_address: StrictStr = Field(..., alias="contractAddress", description="The on-chain address of this contract.")
    data: StrictStr = Field(...)
    event_signature: StrictStr = Field(..., alias="eventSignature")
    event_signature_hash: StrictStr = Field(..., alias="eventSignatureHash")
    log_index: StrictStr = Field(..., alias="logIndex")
    topics: conlist(StrictStr) = Field(...)
    tx_hash: StrictStr = Field(..., alias="txHash")
    user_op_hash: StrictStr = Field(..., alias="userOpHash")
    first_confirm_date: StrictStr = Field(..., alias="firstConfirmDate")
    __properties = ["id", "blockHash", "blockHeight", "blockchain", "contractAddress", "data", "eventSignature", "eventSignatureHash", "logIndex", "topics", "txHash", "userOpHash", "firstConfirmDate"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventLog:
        """Create an instance of EventLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventLog:
        """Create an instance of EventLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EventLog.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = EventLog.parse_obj({
            "id": obj.get("id"),
            "block_hash": obj.get("blockHash"),
            "block_height": obj.get("blockHeight"),
            "blockchain": obj.get("blockchain"),
            "contract_address": obj.get("contractAddress"),
            "data": obj.get("data"),
            "event_signature": obj.get("eventSignature"),
            "event_signature_hash": obj.get("eventSignatureHash"),
            "log_index": obj.get("logIndex"),
            "topics": obj.get("topics"),
            "tx_hash": obj.get("txHash"),
            "user_op_hash": obj.get("userOpHash"),
            "first_confirm_date": obj.get("firstConfirmDate")
        })
        return _obj


