# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, List, Optional, Union
from pydantic import BaseModel, Field, StrictBytes, StrictStr, conlist, constr
from circle.web3.smart_contract_platform.models.blockchain import Blockchain
from circle.web3.smart_contract_platform.models.fee_level import FeeLevel

class ContractDeploymentRequest(BaseModel):
    """
    ContractDeploymentRequest
    """
    idempotency_key: StrictStr = Field(..., alias="idempotencyKey", description="Universally unique identifier (UUID v4) idempotency key. This key is utilized to ensure exactly-once execution of mutating requests. To create a UUIDv4 go to [uuidgenerator.net](https://www.uuidgenerator.net). If the same key is reused, it will be treated as the same request and the original response will be returned.")
    name: StrictStr = Field(..., description="The name for a contract. Must be alphanumeric [a-zA-Z0-9].")
    description: Optional[StrictStr] = Field(None, description="The description for a contract.")
    wallet_id: StrictStr = Field(..., alias="walletId", description="Unique system generated identifier of the wallet. Required when `sourceAddress` and `blockchain` are not provided.  Mutually exclusive with `sourceAddress` and `blockchain`.  For contract deploys this wallet ID will be used as the source. ")
    abi_json: StrictStr = Field(..., alias="abiJson", description="The contract's ABI in a JSON stringified format.")
    bytecode: constr(strict=True, min_length=1) = Field(..., description="Bytecode of the contract being deployed.")
    entity_secret_ciphertext: Union[StrictBytes, StrictStr] = Field(..., alias="entitySecretCiphertext", description="A base64 string expression of the entity secret ciphertext. The entity secret should be encrypted by the entity public key. Circle mandates that the entity secret ciphertext is unique for each API request. ")
    blockchain: Blockchain = Field(...)
    constructor_parameters: Optional[conlist(Any)] = Field(None, alias="constructorParameters", description="A list of arguments to pass to the contract's constructor function. Must be an empty array if there are no constructor parameters.")
    fee_level: Optional[FeeLevel] = Field(None, alias="feeLevel")
    gas_limit: Optional[StrictStr] = Field(None, alias="gasLimit", description="The maximum units of gas to use for the transaction. Required if `feeLevel` is not provided. Estimates for this limit can be obtained through the `POST /transactions/transfer/estimateFee` API. GasLimit override (only supported for EOA wallets): Using `gasLimit` together with `feeLevel`, the provided `gasLimit` is required to be greater or equal to `feeLevel` estimation and will override the estimation's gasLimit. ")
    gas_price: Optional[StrictStr] = Field(None, alias="gasPrice", description="For blockchains without EIP-1559 support, the maximum price of gas, in gwei, to use per each unit of gas (see `gasLimit`). Requires `gasLimit`. Cannot be used with `feeLevel`, `priorityFee`, or `maxFee`. Estimates for this fee can be obtained through the `POST /transactions/transfer/estimateFee` API. ")
    max_fee: Optional[StrictStr] = Field(None, alias="maxFee", description="For blockchains with EIP-1559 support, the maximum price per unit of gas (see `gasLimit`), in gwei. Requires `priorityFee`, and `gasLimit` to be present. Cannot be used with `feeLevel` or `gasPrice`. Estimates for this fee can be obtained through the `POST /transactions/transfer/estimateFee` API. ")
    priority_fee: Optional[StrictStr] = Field(None, alias="priorityFee", description="For blockchains with EIP-1559 support, the “tip”, in gwei, to add to the base fee as an incentive for validators. Please note that the `maxFee` and `gasLimit` parameters are required alongside the `priorityFee`. The `feeLevel` and `gasPrice` parameters cannot be used with the `priorityFee`.  Estimations for this fee can be obtained through the `POST /transactions/transfer/estimateFee` API. ")
    ref_id: Optional[StrictStr] = Field(None, alias="refId", description="Optional reference or description used to identify the transaction.")
    __properties = ["idempotencyKey", "name", "description", "walletId", "abiJson", "bytecode", "entitySecretCiphertext", "blockchain", "constructorParameters", "feeLevel", "gasLimit", "gasPrice", "maxFee", "priorityFee", "refId"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContractDeploymentRequest:
        """Create an instance of ContractDeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContractDeploymentRequest:
        """Create an instance of ContractDeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ContractDeploymentRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = ContractDeploymentRequest.parse_obj({
            "idempotency_key": obj.get("idempotencyKey"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "wallet_id": obj.get("walletId"),
            "abi_json": obj.get("abiJson"),
            "bytecode": obj.get("bytecode"),
            "entity_secret_ciphertext": obj.get("entitySecretCiphertext"),
            "blockchain": obj.get("blockchain"),
            "constructor_parameters": obj.get("constructorParameters"),
            "fee_level": obj.get("feeLevel"),
            "gas_limit": obj.get("gasLimit"),
            "gas_price": obj.get("gasPrice"),
            "max_fee": obj.get("maxFee"),
            "priority_fee": obj.get("priorityFee"),
            "ref_id": obj.get("refId")
        })
        return _obj


