# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictStr
from circle.web3.smart_contract_platform.models.blockchain import Blockchain

class ContractDeploymentEstimateRequest(BaseModel):
    """
    ContractDeploymentEstimateRequest
    """
    blockchain: Blockchain = Field(...)
    source_address: Optional[StrictStr] = Field(None, alias="sourceAddress", description="Source address of the transaction. Required along with `blockchain` if `walletId` is not provided.  The `sourceAddress` and `walletId` fields are mutually exclusive. ")
    template_parameters: Optional[Dict[str, StrictStr]] = Field(None, alias="templateParameters", description="JSON object that contains the template deployment parameters used to initialize the contract(s) on-chain.")
    wallet_id: Optional[StrictStr] = Field(None, alias="walletId", description="Unique system generated identifier of the wallet. Required when `sourceAddress` and `blockchain` are not provided.  Mutually exclusive with `sourceAddress` and `blockchain`.  For contract deploys this wallet ID will be used as the source. ")
    __properties = ["blockchain", "sourceAddress", "templateParameters", "walletId"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContractDeploymentEstimateRequest:
        """Create an instance of ContractDeploymentEstimateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContractDeploymentEstimateRequest:
        """Create an instance of ContractDeploymentEstimateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ContractDeploymentEstimateRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = ContractDeploymentEstimateRequest.parse_obj({
            "blockchain": obj.get("blockchain"),
            "source_address": obj.get("sourceAddress"),
            "template_parameters": obj.get("templateParameters"),
            "wallet_id": obj.get("walletId")
        })
        return _obj


