# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from circle.web3.smart_contract_platform.models.blockchain import Blockchain

class ContractDeploymentEstimateFeeRequest(BaseModel):
    """
    ContractDeploymentEstimateFeeRequest
    """
    abi_json: Optional[StrictStr] = Field(None, alias="abiJson", description="The contract's ABI in a JSON stringified format.")
    blockchain: Optional[Blockchain] = None
    bytecode: constr(strict=True, min_length=1) = Field(..., description="Bytecode of the contract being deployed.")
    constructor_signature: Optional[constr(strict=True, max_length=1000, min_length=1)] = Field(None, alias="constructorSignature", description="Signature of the constructor if the contract has one. constructor() by default.")
    constructor_parameters: Optional[conlist(Any)] = Field(None, alias="constructorParameters", description="A list of arguments to pass to the contract's constructor function. Must be an empty array if there are no constructor parameters.")
    source_address: Optional[StrictStr] = Field(None, alias="sourceAddress", description="Source address of the transaction. Required along with `blockchain` if `walletId` is not provided.  The `sourceAddress` and `walletId` fields are mutually exclusive. ")
    wallet_id: Optional[StrictStr] = Field(None, alias="walletId", description="Unique system generated identifier of the wallet. Required when `sourceAddress` and `blockchain` are not provided.  Mutually exclusive with `sourceAddress` and `blockchain`.  For contract deploys this wallet ID will be used as the source. ")
    __properties = ["abiJson", "blockchain", "bytecode", "constructorSignature", "constructorParameters", "sourceAddress", "walletId"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContractDeploymentEstimateFeeRequest:
        """Create an instance of ContractDeploymentEstimateFeeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContractDeploymentEstimateFeeRequest:
        """Create an instance of ContractDeploymentEstimateFeeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ContractDeploymentEstimateFeeRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = ContractDeploymentEstimateFeeRequest.parse_obj({
            "abi_json": obj.get("abiJson"),
            "blockchain": obj.get("blockchain"),
            "bytecode": obj.get("bytecode"),
            "constructor_signature": obj.get("constructorSignature"),
            "constructor_parameters": obj.get("constructorParameters"),
            "source_address": obj.get("sourceAddress"),
            "wallet_id": obj.get("walletId")
        })
        return _obj


