# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from circle.web3.smart_contract_platform.models.blockchain import Blockchain
from circle.web3.smart_contract_platform.models.contract_input_type import ContractInputType
from circle.web3.smart_contract_platform.models.contract_status import ContractStatus
from circle.web3.smart_contract_platform.models.event import Event
from circle.web3.smart_contract_platform.models.function import Function
from circle.web3.smart_contract_platform.models.sol_file import SolFile
from circle.web3.smart_contract_platform.models.verification_status import VerificationStatus

class Contract(BaseModel):
    """
    Contract
    """
    id: StrictStr = Field(..., description="System-generated unique identifier of the resource.")
    deployer_wallet_id: Optional[StrictStr] = Field(None, alias="deployerWalletID", description="The `id` of the Programmable Wallet that deployed this contract.")
    deployment_transaction_id: Optional[StrictStr] = Field(None, alias="deploymentTransactionId", description="The id of the deployment transaction for this contract.")
    tx_hash: Optional[StrictStr] = Field(None, alias="txHash", description="Blockchain generated identifier of the transaction.")
    abi_json: Optional[StrictStr] = Field(None, alias="abiJson", description="The contract's ABI in a JSON stringified format.")
    archived: StrictBool = Field(..., description="The archive state of the contract. If true, the contract will not be visible in your dashboard.")
    blockchain: Blockchain = Field(...)
    bytecode: Optional[constr(strict=True, min_length=1)] = Field(None, description="Bytecode of the contract being deployed.")
    contract_address: Optional[StrictStr] = Field(None, alias="contractAddress", description="The on-chain address of this contract.")
    contract_input_type: ContractInputType = Field(..., alias="contractInputType")
    deployer_address: Optional[StrictStr] = Field(None, alias="deployerAddress", description="The address that created this contract, if deployed.")
    deployer_user_id: Optional[StrictStr] = Field(None, alias="deployerUserID")
    deployment_error_reason: Optional[StrictStr] = Field(None, alias="deploymentErrorReason")
    deployment_error_details: Optional[StrictStr] = Field(None, alias="deploymentErrorDetails")
    name: StrictStr = Field(..., description="The name for a contract. Must be alphanumeric [a-zA-Z0-9].")
    description: Optional[StrictStr] = Field(None, description="The description for a contract.")
    status: ContractStatus = Field(...)
    verification_status: VerificationStatus = Field(..., alias="verificationStatus")
    metadata_link: Optional[StrictStr] = Field(None, alias="metadataLink", description="The ipfs metadata link of the contract.")
    update_date: datetime = Field(..., alias="updateDate", description="Date and time the resource was last updated, in ISO-8601 UTC format.")
    create_date: datetime = Field(..., alias="createDate", description="Date and time the resource was created, in ISO-8601 UTC format.")
    source_code: conlist(SolFile) = Field(..., alias="sourceCode")
    functions: conlist(Function) = Field(..., description="Functions supported by this contract. Parsed from abi_json.")
    events: conlist(Event) = Field(..., description="Events this contract can emit. Parsed from abi_json.")
    implementation_contract: Optional[Dict[str, Any]] = Field(None, alias="implementationContract", description="Object of the implementation contract.")
    __properties = ["id", "deployerWalletID", "deploymentTransactionId", "txHash", "abiJson", "archived", "blockchain", "bytecode", "contractAddress", "contractInputType", "deployerAddress", "deployerUserID", "deploymentErrorReason", "deploymentErrorDetails", "name", "description", "status", "verificationStatus", "metadataLink", "updateDate", "createDate", "sourceCode", "functions", "events", "implementationContract"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Contract:
        """Create an instance of Contract from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "source_code",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in source_code (list)
        _items = []
        if self.source_code:
            for _item in self.source_code:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sourceCode'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in functions (list)
        _items = []
        if self.functions:
            for _item in self.functions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['functions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in events (list)
        _items = []
        if self.events:
            for _item in self.events:
                if _item:
                    _items.append(_item.to_dict())
            _dict['events'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Contract:
        """Create an instance of Contract from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Contract.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = Contract.parse_obj({
            "id": obj.get("id"),
            "deployer_wallet_id": obj.get("deployerWalletID"),
            "deployment_transaction_id": obj.get("deploymentTransactionId"),
            "tx_hash": obj.get("txHash"),
            "abi_json": obj.get("abiJson"),
            "archived": obj.get("archived"),
            "blockchain": obj.get("blockchain"),
            "bytecode": obj.get("bytecode"),
            "contract_address": obj.get("contractAddress"),
            "contract_input_type": obj.get("contractInputType"),
            "deployer_address": obj.get("deployerAddress"),
            "deployer_user_id": obj.get("deployerUserID"),
            "deployment_error_reason": obj.get("deploymentErrorReason"),
            "deployment_error_details": obj.get("deploymentErrorDetails"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "verification_status": obj.get("verificationStatus"),
            "metadata_link": obj.get("metadataLink"),
            "update_date": obj.get("updateDate"),
            "create_date": obj.get("createDate"),
            "source_code": [SolFile.from_dict(_item) for _item in obj.get("sourceCode")] if obj.get("sourceCode") is not None else None,
            "functions": [Function.from_dict(_item) for _item in obj.get("functions")] if obj.get("functions") is not None else None,
            "events": [Event.from_dict(_item) for _item in obj.get("events")] if obj.get("events") is not None else None,
            "implementation_contract": obj.get("implementationContract")
        })
        return _obj


