# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings
import functools

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint

from typing import Optional

from circle.web3.smart_contract_platform.models.blockchain import Blockchain
from circle.web3.smart_contract_platform.models.contract_input_type import ContractInputType
from circle.web3.smart_contract_platform.models.contract_response import ContractResponse
from circle.web3.smart_contract_platform.models.contract_status import ContractStatus
from circle.web3.smart_contract_platform.models.contracts import Contracts
from circle.web3.smart_contract_platform.models.patch_contract_request import PatchContractRequest

from circle.web3.smart_contract_platform.api_client import ApiClient
from circle.web3.smart_contract_platform.api_response import ApiResponse
from circle.web3.smart_contract_platform.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


def auto_fill(func):
    functools.wraps(func)

    def wrapper(*args, **kwargs):
        api = args[0]
        for arg in args:
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        for name, arg in kwargs.items():
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        return func(*args, **kwargs)

    return wrapper


class ViewUpdateApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @auto_fill
    @validate_arguments
    def get_contract(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], **kwargs) -> ContractResponse:  # noqa: E501
        """Get a contract  # noqa: E501

        Get a single contract that you've imported or deployed. Retrieved using the contracts ID as opposed to the on-chain address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_contract(id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ContractResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_contract_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_contract_with_http_info(id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_contract_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get a contract  # noqa: E501

        Get a single contract that you've imported or deployed. Retrieved using the contracts ID as opposed to the on-chain address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_contract_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ContractResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contract" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "ContractResponse",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def list_contracts(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, contract_input_type : Annotated[Optional[ContractInputType], Field(description="Filter contracts by input type.")] = None, deployer_address : Annotated[Optional[StrictStr], Field(description="Filter contracts by deployer address.")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter contracts by name.")] = None, status : Annotated[Optional[ContractStatus], Field(description="Filter contracts by status.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> Contracts:  # noqa: E501
        """List contracts  # noqa: E501

        Fetch a list of contracts that you've imported and/or deployed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_contracts(blockchain, contract_input_type, deployer_address, name, status, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param contract_input_type: Filter contracts by input type.
        :type contract_input_type: ContractInputType
        :param deployer_address: Filter contracts by deployer address.
        :type deployer_address: str
        :param name: Filter contracts by name.
        :type name: str
        :param status: Filter contracts by status.
        :type status: ContractStatus
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Contracts
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_contracts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_contracts_with_http_info(blockchain, contract_input_type, deployer_address, name, status, var_from, to, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def list_contracts_with_http_info(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, contract_input_type : Annotated[Optional[ContractInputType], Field(description="Filter contracts by input type.")] = None, deployer_address : Annotated[Optional[StrictStr], Field(description="Filter contracts by deployer address.")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter contracts by name.")] = None, status : Annotated[Optional[ContractStatus], Field(description="Filter contracts by status.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List contracts  # noqa: E501

        Fetch a list of contracts that you've imported and/or deployed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_contracts_with_http_info(blockchain, contract_input_type, deployer_address, name, status, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param contract_input_type: Filter contracts by input type.
        :type contract_input_type: ContractInputType
        :param deployer_address: Filter contracts by deployer address.
        :type deployer_address: str
        :param name: Filter contracts by name.
        :type name: str
        :param status: Filter contracts by status.
        :type status: ContractStatus
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Contracts, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blockchain',
            'contract_input_type',
            'deployer_address',
            'name',
            'status',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_contracts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('contract_input_type') is not None:  # noqa: E501
            _query_params.append(('contractInputType', _params['contract_input_type'].value))

        if _params.get('deployer_address') is not None:  # noqa: E501
            _query_params.append(('deployerAddress', _params['deployer_address']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status'].value))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Contracts",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def update_contract(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], patch_contract_request : Annotated[PatchContractRequest, Field(..., description="Update contract properties request")], **kwargs) -> ContractResponse:  # noqa: E501
        """Update a contract  # noqa: E501

        Update the off-chain properties, such as description, of a contract that you've imported or deployed. Updated using the contracts ID as opposed to the on-chain address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_contract(id, patch_contract_request, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param patch_contract_request: Update contract properties request (required)
        :type patch_contract_request: PatchContractRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ContractResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_contract_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_contract_with_http_info(id, patch_contract_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def update_contract_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], patch_contract_request : Annotated[PatchContractRequest, Field(..., description="Update contract properties request")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update a contract  # noqa: E501

        Update the off-chain properties, such as description, of a contract that you've imported or deployed. Updated using the contracts ID as opposed to the on-chain address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_contract_with_http_info(id, patch_contract_request, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param patch_contract_request: Update contract properties request (required)
        :type patch_contract_request: PatchContractRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ContractResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'patch_contract_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_contract" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['patch_contract_request'] is not None:
            _body_params = _params['patch_contract_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "ContractResponse",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts/{id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
