# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings
import functools

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field

from circle.web3.smart_contract_platform.models.read_contract_state import ReadContractState
from circle.web3.smart_contract_platform.models.read_contract_state_request import ReadContractStateRequest

from circle.web3.smart_contract_platform.api_client import ApiClient
from circle.web3.smart_contract_platform.api_response import ApiResponse
from circle.web3.smart_contract_platform.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


def auto_fill(func):
    functools.wraps(func)

    def wrapper(*args, **kwargs):
        api = args[0]
        for arg in args:
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        for name, arg in kwargs.items():
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        return func(*args, **kwargs)

    return wrapper


class InteractApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @auto_fill
    @validate_arguments
    def query_contract(self, read_contract_state_request : Annotated[ReadContractStateRequest, Field(..., description="Read contract state by executing a read ABI function.")], **kwargs) -> ReadContractState:  # noqa: E501
        """Execute a query function on a contract  # noqa: E501

        Query the state of a contract by providing the address and blockchain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_contract(read_contract_state_request, async_req=True)
        >>> result = thread.get()

        :param read_contract_state_request: Read contract state by executing a read ABI function. (required)
        :type read_contract_state_request: ReadContractStateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReadContractState
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the query_contract_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.query_contract_with_http_info(read_contract_state_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def query_contract_with_http_info(self, read_contract_state_request : Annotated[ReadContractStateRequest, Field(..., description="Read contract state by executing a read ABI function.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Execute a query function on a contract  # noqa: E501

        Query the state of a contract by providing the address and blockchain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_contract_with_http_info(read_contract_state_request, async_req=True)
        >>> result = thread.get()

        :param read_contract_state_request: Read contract state by executing a read ABI function. (required)
        :type read_contract_state_request: ReadContractStateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ReadContractState, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'read_contract_state_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_contract" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['read_contract_state_request'] is not None:
            _body_params = _params['read_contract_state_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "ReadContractState",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts/query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
