# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings
import functools

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint

from typing import Optional

from circle.web3.smart_contract_platform.models.blockchain import Blockchain
from circle.web3.smart_contract_platform.models.create_event_monitor_request import CreateEventMonitorRequest
from circle.web3.smart_contract_platform.models.event_logs import EventLogs
from circle.web3.smart_contract_platform.models.event_monitor_response import EventMonitorResponse
from circle.web3.smart_contract_platform.models.event_monitors import EventMonitors
from circle.web3.smart_contract_platform.models.update_event_monitor_request import UpdateEventMonitorRequest

from circle.web3.smart_contract_platform.api_client import ApiClient
from circle.web3.smart_contract_platform.api_response import ApiResponse
from circle.web3.smart_contract_platform.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


def auto_fill(func):
    functools.wraps(func)

    def wrapper(*args, **kwargs):
        api = args[0]
        for arg in args:
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        for name, arg in kwargs.items():
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        return func(*args, **kwargs)

    return wrapper


class EventMonitorsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @auto_fill
    @validate_arguments
    def create_event_monitor(self, create_event_monitor_request : Annotated[Optional[CreateEventMonitorRequest], Field(description="Create Event Monitor Request")] = None, **kwargs) -> EventMonitorResponse:  # noqa: E501
        """Create Event Monitor  # noqa: E501

        Create a new event monitor based on the provided blockchain, contract address, and event signature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_event_monitor(create_event_monitor_request, async_req=True)
        >>> result = thread.get()

        :param create_event_monitor_request: Create Event Monitor Request
        :type create_event_monitor_request: CreateEventMonitorRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EventMonitorResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_event_monitor_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_event_monitor_with_http_info(create_event_monitor_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_event_monitor_with_http_info(self, create_event_monitor_request : Annotated[Optional[CreateEventMonitorRequest], Field(description="Create Event Monitor Request")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Event Monitor  # noqa: E501

        Create a new event monitor based on the provided blockchain, contract address, and event signature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_event_monitor_with_http_info(create_event_monitor_request, async_req=True)
        >>> result = thread.get()

        :param create_event_monitor_request: Create Event Monitor Request
        :type create_event_monitor_request: CreateEventMonitorRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EventMonitorResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_event_monitor_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_monitor" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_event_monitor_request'] is not None:
            _body_params = _params['create_event_monitor_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "EventMonitorResponse",
            '201': "EventMonitorResponse",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts/monitors', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def delete_event_monitor(self, id : Annotated[StrictStr, Field(..., description="Event Monitor ID.")], **kwargs) -> None:  # noqa: E501
        """Delete Event Monitor  # noqa: E501

        Delete an existing event monitor given its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_event_monitor(id, async_req=True)
        >>> result = thread.get()

        :param id: Event Monitor ID. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_event_monitor_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_event_monitor_with_http_info(id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def delete_event_monitor_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Event Monitor ID.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Event Monitor  # noqa: E501

        Delete an existing event monitor given its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_event_monitor_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Event Monitor ID. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event_monitor" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/w3s/contracts/monitors/{id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_event_monitors(self, contract_address : Annotated[Optional[StrictStr], Field(description="Filter contracts by address.")] = None, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, event_signature : Annotated[Optional[StrictStr], Field(description="Filter monitors by event signature.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> EventMonitors:  # noqa: E501
        """Get Event Monitors  # noqa: E501

        Fetch a list of event monitors, optionally filtered by blockchain, contract address, and event signature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_monitors(contract_address, blockchain, event_signature, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param contract_address: Filter contracts by address.
        :type contract_address: str
        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param event_signature: Filter monitors by event signature.
        :type event_signature: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EventMonitors
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_event_monitors_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_event_monitors_with_http_info(contract_address, blockchain, event_signature, var_from, to, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_event_monitors_with_http_info(self, contract_address : Annotated[Optional[StrictStr], Field(description="Filter contracts by address.")] = None, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, event_signature : Annotated[Optional[StrictStr], Field(description="Filter monitors by event signature.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Event Monitors  # noqa: E501

        Fetch a list of event monitors, optionally filtered by blockchain, contract address, and event signature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_monitors_with_http_info(contract_address, blockchain, event_signature, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param contract_address: Filter contracts by address.
        :type contract_address: str
        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param event_signature: Filter monitors by event signature.
        :type event_signature: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EventMonitors, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'contract_address',
            'blockchain',
            'event_signature',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_monitors" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('contract_address') is not None:  # noqa: E501
            _query_params.append(('contractAddress', _params['contract_address']))

        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('event_signature') is not None:  # noqa: E501
            _query_params.append(('eventSignature', _params['event_signature']))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "EventMonitors",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts/monitors', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def list_event_logs(self, contract_address : Annotated[Optional[StrictStr], Field(description="Filter contracts by address.")] = None, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> EventLogs:  # noqa: E501
        """Get Event Logs  # noqa: E501

        Fetch all event logs, optionally filtered by blockchain and contract address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_event_logs(contract_address, blockchain, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param contract_address: Filter contracts by address.
        :type contract_address: str
        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EventLogs
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_event_logs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_event_logs_with_http_info(contract_address, blockchain, var_from, to, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def list_event_logs_with_http_info(self, contract_address : Annotated[Optional[StrictStr], Field(description="Filter contracts by address.")] = None, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Event Logs  # noqa: E501

        Fetch all event logs, optionally filtered by blockchain and contract address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_event_logs_with_http_info(contract_address, blockchain, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param contract_address: Filter contracts by address.
        :type contract_address: str
        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EventLogs, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'contract_address',
            'blockchain',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_event_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('contract_address') is not None:  # noqa: E501
            _query_params.append(('contractAddress', _params['contract_address']))

        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "EventLogs",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts/events', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def update_event_monitor(self, id : Annotated[StrictStr, Field(..., description="Event Monitor ID.")], update_event_monitor_request : Annotated[Optional[UpdateEventMonitorRequest], Field(description="Update Event Monitor Request")] = None, **kwargs) -> EventMonitorResponse:  # noqa: E501
        """Update an Event Monitor  # noqa: E501

        Update an existing event monitor given its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_event_monitor(id, update_event_monitor_request, async_req=True)
        >>> result = thread.get()

        :param id: Event Monitor ID. (required)
        :type id: str
        :param update_event_monitor_request: Update Event Monitor Request
        :type update_event_monitor_request: UpdateEventMonitorRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EventMonitorResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_event_monitor_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_event_monitor_with_http_info(id, update_event_monitor_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def update_event_monitor_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Event Monitor ID.")], update_event_monitor_request : Annotated[Optional[UpdateEventMonitorRequest], Field(description="Update Event Monitor Request")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update an Event Monitor  # noqa: E501

        Update an existing event monitor given its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_event_monitor_with_http_info(id, update_event_monitor_request, async_req=True)
        >>> result = thread.get()

        :param id: Event Monitor ID. (required)
        :type id: str
        :param update_event_monitor_request: Update Event Monitor Request
        :type update_event_monitor_request: UpdateEventMonitorRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EventMonitorResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'update_event_monitor_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_monitor" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_event_monitor_request'] is not None:
            _body_params = _params['update_event_monitor_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "EventMonitorResponse",
            '400': "Error",
            '404': "Error",
        }

        return self.api_client.call_api(
            '/v1/w3s/contracts/monitors/{id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
