"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
/**
 * Security Groups do not allow for unrestricted SSH traffic - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnSecurityGroup) {
        const ingressRules = monocdk_1.Stack.of(node).resolve(node.securityGroupIngress);
        if (ingressRules != undefined) {
            //For each ingress rule, ensure that it does not allow unrestricted SSH traffic.
            for (const rule of ingressRules) {
                const resolvedRule = monocdk_1.Stack.of(node).resolve(rule);
                if ((resolvedRule.cidrIp != undefined && resolvedRule.cidrIp.includes('/0')) ||
                    (resolvedRule.cidrIpv6 != undefined && resolvedRule.cidrIpv6.includes('/0'))) {
                    //Is a port range specified?
                    if (resolvedRule.fromPort != undefined && resolvedRule.toPort != undefined) {
                        if ((resolvedRule.fromPort <= 22 && resolvedRule.toPort >= 22) ||
                            (resolvedRule.fromPort == -1 || resolvedRule.toPort == -1) ||
                            resolvedRule.ipProtocol == '-1') {
                            return false;
                        }
                    }
                    else {
                        if (resolvedRule.fromPort == 22 || resolvedRule.ipProtocol == '-1') {
                            return false;
                        }
                    }
                }
            }
        }
    }
    else if (node instanceof aws_ec2_1.CfnSecurityGroupIngress) {
        if ((node.cidrIp != undefined && node.cidrIp.includes('/0')) ||
            (node.cidrIpv6 != undefined && node.cidrIpv6.includes('/0'))) {
            //Is a port range specified?
            if (node.fromPort != undefined && node.toPort != undefined) {
                if ((node.fromPort <= 22 && node.toPort >= 22) ||
                    (node.fromPort == -1 || node.toPort == -1) ||
                    node.ipProtocol == '-1') {
                    return false;
                }
            }
            else {
                if (node.fromPort == 22 || node.ipProtocol == '-1') {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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