"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
/**
 * S3 Buckets should have public access restricted and blocked.
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        if (publicAccess.blockPublicAcls == undefined ||
            publicAccess.blockPublicPolicy == undefined ||
            publicAccess.ignorePublicAcls == undefined ||
            publicAccess.restrictPublicBuckets == undefined) {
            return false;
        }
        const blockPublicAcls = monocdk_1.Stack.of(node).resolve(publicAccess.blockPublicAcls);
        const blockPublicPolicy = monocdk_1.Stack.of(node).resolve(publicAccess.blockPublicPolicy);
        const ignorePublicAcls = monocdk_1.Stack.of(node).resolve(publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = monocdk_1.Stack.of(node).resolve(publicAccess.restrictPublicBuckets);
        if (blockPublicAcls == false ||
            blockPublicPolicy == false ||
            ignorePublicAcls == false ||
            restrictPublicBuckets == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUzIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL3N0b3JhZ2UvUzIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNkM7QUFDN0MsMkNBQTJDO0FBRTNDOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxrQkFBUyxFQUFFO1FBQzdCLElBQUksSUFBSSxDQUFDLDhCQUE4QixJQUFJLFNBQVMsRUFBRTtZQUNwRCxPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsTUFBTSxZQUFZLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFDakYsSUFDRSxZQUFZLENBQUMsZUFBZSxJQUFJLFNBQVM7WUFDekMsWUFBWSxDQUFDLGlCQUFpQixJQUFJLFNBQVM7WUFDM0MsWUFBWSxDQUFDLGdCQUFnQixJQUFJLFNBQVM7WUFDMUMsWUFBWSxDQUFDLHFCQUFxQixJQUFJLFNBQVMsRUFDL0M7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsTUFBTSxlQUFlLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQzdFLE1BQU0saUJBQWlCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDakYsTUFBTSxnQkFBZ0IsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUMvRSxNQUFNLHFCQUFxQixHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQ3pGLElBQ0UsZUFBZSxJQUFJLEtBQUs7WUFDeEIsaUJBQWlCLElBQUksS0FBSztZQUMxQixnQkFBZ0IsSUFBSSxLQUFLO1lBQ3pCLHFCQUFxQixJQUFJLEtBQUssRUFDOUI7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUE1QkQsNEJBNEJDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkJ1Y2tldCB9IGZyb20gJ21vbm9jZGsvYXdzLXMzJztcblxuLyoqXG4gKiBTMyBCdWNrZXRzIHNob3VsZCBoYXZlIHB1YmxpYyBhY2Nlc3MgcmVzdHJpY3RlZCBhbmQgYmxvY2tlZC5cbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5CdWNrZXQpIHtcbiAgICBpZiAobm9kZS5wdWJsaWNBY2Nlc3NCbG9ja0NvbmZpZ3VyYXRpb24gPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IHB1YmxpY0FjY2VzcyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5wdWJsaWNBY2Nlc3NCbG9ja0NvbmZpZ3VyYXRpb24pO1xuICAgIGlmIChcbiAgICAgIHB1YmxpY0FjY2Vzcy5ibG9ja1B1YmxpY0FjbHMgPT0gdW5kZWZpbmVkIHx8XG4gICAgICBwdWJsaWNBY2Nlc3MuYmxvY2tQdWJsaWNQb2xpY3kgPT0gdW5kZWZpbmVkIHx8XG4gICAgICBwdWJsaWNBY2Nlc3MuaWdub3JlUHVibGljQWNscyA9PSB1bmRlZmluZWQgfHxcbiAgICAgIHB1YmxpY0FjY2Vzcy5yZXN0cmljdFB1YmxpY0J1Y2tldHMgPT0gdW5kZWZpbmVkXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IGJsb2NrUHVibGljQWNscyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUocHVibGljQWNjZXNzLmJsb2NrUHVibGljQWNscyk7XG4gICAgY29uc3QgYmxvY2tQdWJsaWNQb2xpY3kgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKHB1YmxpY0FjY2Vzcy5ibG9ja1B1YmxpY1BvbGljeSk7XG4gICAgY29uc3QgaWdub3JlUHVibGljQWNscyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUocHVibGljQWNjZXNzLmlnbm9yZVB1YmxpY0FjbHMpO1xuICAgIGNvbnN0IHJlc3RyaWN0UHVibGljQnVja2V0cyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUocHVibGljQWNjZXNzLnJlc3RyaWN0UHVibGljQnVja2V0cyk7XG4gICAgaWYgKFxuICAgICAgYmxvY2tQdWJsaWNBY2xzID09IGZhbHNlIHx8XG4gICAgICBibG9ja1B1YmxpY1BvbGljeSA9PSBmYWxzZSB8fFxuICAgICAgaWdub3JlUHVibGljQWNscyA9PSBmYWxzZSB8fFxuICAgICAgcmVzdHJpY3RQdWJsaWNCdWNrZXRzID09IGZhbHNlXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19