"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_ecs_1 = require("monocdk/aws-ecs");
/**
 * ECS Task Definition has awslogs logging enabled at the minimum
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecs_1.CfnCluster) {
        if (node.configuration == undefined) {
            return false;
        }
        const configuration = monocdk_1.Stack.of(node).resolve(node.configuration);
        if (configuration.executeCommandConfiguration == undefined) {
            return false;
        }
        const executeCommandConfiguration = monocdk_1.Stack.of(node).resolve(configuration.executeCommandConfiguration);
        if (executeCommandConfiguration.logging == undefined ||
            executeCommandConfiguration.logging == 'NONE') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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