"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_kinesisanalytics_1 = require("monocdk/aws-kinesisanalytics");
/**
 * Kinesis Data Analytics Flink Applications have checkpointing enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_kinesisanalytics_1.CfnApplicationV2) {
        if (node.runtimeEnvironment.toLowerCase().startsWith('flink')) {
            const applicationConfiguration = monocdk_1.Stack.of(node).resolve(node.applicationConfiguration);
            if (applicationConfiguration == undefined) {
                return false;
            }
            const flinkApplicationConfiguration = monocdk_1.Stack.of(node).resolve(applicationConfiguration.flinkApplicationConfiguration);
            if (flinkApplicationConfiguration == undefined) {
                return false;
            }
            const checkpointConfiguration = monocdk_1.Stack.of(node).resolve(flinkApplicationConfiguration.checkpointConfiguration);
            if (checkpointConfiguration == undefined) {
                return false;
            }
            if (checkpointConfiguration.configurationType == 'CUSTOM') {
                const enabled = monocdk_1.Stack.of(node).resolve(checkpointConfiguration.checkpointingEnabled);
                if (!enabled) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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