<!--
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
-->

# Rules

A list of all the available rules by Rule Pack

## AwsSolutions

The [AWS Solutions Library](https://aws.amazon.com/solutions/) offers a collection of cloud-based solutions for dozens of technical and business problems, vetted for you by AWS. The AwsSolutions Rules Pack contains many of the checks that the are used as part of the vetting process.

### Warnings

| Rule ID           | Summary                                                                                                                                                | Explanation                                                                                                                                                                                                                                                                                                          |
| ----------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| AwsSolutions-CB3  | The CodeBuild project has privileged mode enabled.                                                                                                     | Privileged grants elevated rights to the system, which introduces additional risk. Privileged mode should only be set to true only if the build project is used to build Docker images. Otherwise, a build that attempts to interact with the Docker daemon fails.                                                   |
| AwsSolutions-CB5  | The Codebuild project does not use images provided by the CodeBuild service or have a cdk_nag suppression rule explaining the need for a custom image. | Explaining differences/edits to Docker images helps operators better understand system dependencies.                                                                                                                                                                                                                 |
| AwsSolutions-CFR1 | The CloudFront distribution may require Geo restrictions.                                                                                              | Geo restriction may need to be enabled for the distribution in order to allow or deny a country in order to allow or restrict users in specific locations from accessing content.                                                                                                                                    |
| AwsSolutions-CFR2 | The CloudFront distribution may require integration with AWS WAF.                                                                                      | The Web Application Firewall can help protect against application-layer attacks that can compromise the security of the system or place unnecessary load on them.                                                                                                                                                    |
| AwsSolutions-COG2 | The Cognito user pool does not require MFA.                                                                                                            | Multi-factor authentication (MFA) increases security for the application by adding another authentication method, and not relying solely on user name and password.                                                                                                                                                  |
| AwsSolutions-DDB3 | The DynamoDB table does not have Point-in-time Recovery enabled.                                                                                       | DynamoDB continuous backups represent an additional layer of insurance against accidental loss of data on top of on-demand backups. The DynamoDB service can back up the data with per-second granularity and restore it to any single second from the time PITR was enabled up to the prior 35 days.                |
| AwsSolutions-KDA3 | The Kinesis Data Analytics Flink Application does not have checkpointing enabled.                                                                      | Checkpoints are backups of application state that KDA automatically creates periodically and uses to restore from faults.                                                                                                                                                                                            |
| AwsSolutions-MS4  | The MediaStore container does not define a metric policy to send metrics to CloudWatch.                                                                | Using a combination of MediaStore metrics and CloudWatch alarms helps operators gain better insights into container operations.                                                                                                                                                                                      |
| AwsSolutions-MS7  | The MediaStore container does not define a container policy.                                                                                           | Using a container policy helps follow the standard security advice of granting least privilege, or granting only the permissions required to allow needed access to the container.                                                                                                                                   |
| AwsSolutions-MS8  | The MediaStore container does not define a CORS policy.                                                                                                | Using a CORS policy helps follow the standard security advice of granting least privilege, or granting only the permissions required to allow needed access to the container.                                                                                                                                        |
| AwsSolutions-MS10 | The MediaStore container does not define a lifecycle policy.                                                                                           | Many use cases warrant the usage of lifecycle configurations to manage container objects during their lifetime.                                                                                                                                                                                                      |
| AwsSolutions-VPC3 | A Network ACL or Network ACL entry has been implemented.                                                                                               | Network ACLs should be used sparingly for the following reasons: they can be complex to manage, they are stateless, every IP address must be explicitly opened in each (inbound/outbound) direction, and they affect a complete subnet. Use security groups when possible as they are stateful and easier to manage. |

### Errors

| Rule ID            | Summary                                                                                                                                                                                   | Explanation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| ------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| AwsSolutions-AEC1  | The ElastiCache cluster is not provisioned in a VPC.                                                                                                                                      | Provisioning the cluster within a VPC allows for better flexibility and control over the cache clusters security, availability, traffic routing and more.                                                                                                                                                                                                                                                                                                                                                                                                              |
| AwsSolutions-AEC3  | The ElastiCache Redis cluster does not have both encryption in transit and at rest enabled.                                                                                               | Encryption in transit helps secure communications to the cluster. Encryption at rest helps protect data at rest from unauthorized access.                                                                                                                                                                                                                                                                                                                                                                                                                              |
| AwsSolutions-AEC4  | The ElastiCache Redis cluster is not deployed in a Multi-AZ configuration.                                                                                                                | The cluster should use a Multi-AZ deployment configuration for high availability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| AwsSolutions-AEC5  | The ElastiCache cluster uses the default endpoint port.                                                                                                                                   | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. Redis port 6379 and Memcached port 11211).                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-AEC6  | The ElastiCache Redis cluster does not use Redis AUTH for user authentication.                                                                                                            | Redis authentication tokens enable Redis to require a token (password) before allowing clients to execute commands, thereby improving data security.                                                                                                                                                                                                                                                                                                                                                                                                                   |
| AwsSolutions-APIG1 | The API does not have access logging enabled.                                                                                                                                             | Enabling access logs helps operators view who accessed an API and how the caller accessed the API.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| AwsSolutions-APIG4 | The API does not implement authorization.                                                                                                                                                 | In most cases an API needs to have an authentication and authorization implementation strategy. This includes using such approaches as IAM, Cognito User Pools, Custom authorizer, etc.                                                                                                                                                                                                                                                                                                                                                                                |
| AwsSolutions-APIG6 | The REST API Stage does not have CloudWatch logging enabled for all methods.                                                                                                              | Enabling CloudWatch logs at the stage level helps operators to track and analyze execution behavior at the API stage level.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-AS1   | The Auto Scaling Group does not have a cooldown period.                                                                                                                                   | A cooldown period temporarily suspends any scaling activities in order to allow the newly launched EC2 instance(s) some time to start handling the application traffic.                                                                                                                                                                                                                                                                                                                                                                                                |
| AwsSolutions-AS2   | The Auto Scaling Group does not have properly configured health checks.                                                                                                                   | The health check feature enables the service to detect whether its registered EC2 instances are healthy or not.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| AwsSolutions-AS3   | The Auto Scaling Group does not have notifications configured for all scaling events.                                                                                                     | Notifications on EC2 instance launch, launch error, termination, and termination errors allow operators to gain better insights into systems attributes such as activity and health.                                                                                                                                                                                                                                                                                                                                                                                   |
| AwsSolutions-ATH1  | The Athena workgroup does not encrypt query results.                                                                                                                                      | Encrypting query results stored in S3 helps secure data to meet compliance requirements for data-at-rest encryption.                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| AwsSolutions-CB4   | The CodeBuild project does not use a CMK for encryption.                                                                                                                                  | Using a CMK helps follow the standard security advice of granting least privilege to objects generated by the project.                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-C91   | The Cloud9 instance does not use a no-ingress EC2 instance with AWS Systems Manager.                                                                                                      | SSM adds an additional layer of protection as it allows operators to control access through IAM permissions and does not require opening inbound ports.                                                                                                                                                                                                                                                                                                                                                                                                                |
| AwsSolutions-CFR3  | The CloudFront distributions does not have access logging enabled.                                                                                                                        | Enabling access logs helps operators track all viewer requests for the content delivered through the Content Delivery Network.                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| AwsSolutions-CFR5  | The CloudFront distributions uses SSLv3 or TLSv1 for communication to the origin.                                                                                                         | Vulnerabilities have been and continue to be discovered in the deprecated SSL and TLS protocols. Using a security policy with minimum TLSv1.1 or TLSv1.2 and appropriate security ciphers for HTTPS helps protect viewer connections.                                                                                                                                                                                                                                                                                                                                  |
| AwsSolutions-CFR6  | The CloudFront distribution does not use an origin access identity an S3 origin.                                                                                                          | Origin access identities help with security by restricting any direct access to objects through S3 URLs.                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| AwsSolutions-COG1  | The Cognito user pool does not have a password policy that minimally specify a password length of at least 8 characters, as well as requiring uppercase, numeric, and special characters. | Strong password policies increase system security by encouraging users to create reliable and secure passwords.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| AwsSolutions-COG3  | The Cognito user pool does not have AdvancedSecurityMode set to ENFORCED.                                                                                                                 | Advanced security features enable the system to detect and act upon malicious sign-in attempts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| AwsSolutions-COG7  | The Cognito identity pool allows for unauthenticated logins and does not have a cdk_nag rule suppression with a reason.                                                                   | In many cases applications do not warrant unauthenticated guest access applications. Metadata explaining the use case allows for transparency to operators.                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-DDB4  | The DAX cluster does not have server-side encryption enabled.                                                                                                                             | Data in cache, configuration data and log files should be encrypted using Server-Side Encryption in order to protect from unauthorized access to the underlying storage.                                                                                                                                                                                                                                                                                                                                                                                               |
| AwsSolutions-DOC1  | The Document DB cluster does not have encryption at rest enabled.                                                                                                                         | Encrypting data-at-rest protects data confidentiality and prevents unauthorized users from accessing sensitive information.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-DOC2  | The Document DB cluster uses the default endpoint port.                                                                                                                                   | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. MongoDB port 27017).                                                                                                                                                                                                                                                                                                                                                                                                                       |
| AwsSolutions-DOC3  | The Document DB cluster does not have the username and password stored in Secrets Manager.                                                                                                | Secrets Manager enables operators to replace hardcoded credentials in your code, including passwords, with an API call to Secrets Manager to retrieve the secret programmatically. This helps ensure the secret can't be compromised by someone examining system code, because the secret no longer exists in the code. Also, operators can configure Secrets Manager to automatically rotate the secret for you according to a specified schedule. This enables you to replace long-term secrets with short-term ones, significantly reducing the risk of compromise. |
| AwsSolutions-DOC4  | The Document DB cluster does not have a reasonable minimum backup retention period configured.                                                                                            | The retention period represents the number of days to retain automated snapshots. A minimum retention period of 7 days is recommended but can be adjust to meet system requirements.                                                                                                                                                                                                                                                                                                                                                                                   |
| AwsSolutions-DOC5  | The Document DB cluster does not have authenticate, createIndex, and dropCollection Log Exports enabled.                                                                                  | This allows operators to use CloudWatch to view logs to help diagnose problems in the database. The events recorded by the AWS DocumentDB audit logs include successful and failed authentication attempts, creating indexes or dropping a collection in a database within the DocumentDB cluster.                                                                                                                                                                                                                                                                     |
| AwsSolutions-EC23  | The Security Group allows for 0.0.0.0/0 or ::/0 inbound access.                                                                                                                           | Large port ranges, when open, expose instances to unwanted attacks. More than that, they make traceability of vulnerabilities very difficult. For instance, your web servers may only require 80 and 443 ports to be open, but not all. One of the most common mistakes observed is when all ports for 0.0.0.0/0 range are open in a rush to access the instance. EC2 instances must expose only to those ports enabled on the corresponding security group level.                                                                                                     |
| AwsSolutions-EC26  | The EBS volume has encryption disabled.                                                                                                                                                   | With EBS encryption, you aren't required to build, maintain, and secure your own key management infrastructure. EBS encryption uses KMS keys when creating encrypted volumes and snapshots. This helps protect data at rest.                                                                                                                                                                                                                                                                                                                                           |
| AwsSolutions-EC27  | The Security Group does not have a description.                                                                                                                                           | Descriptions help simplify operations and remove any opportunities for operator errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| AwsSolutions-EC28  | The EC2 instance/AutoScaling launch configuration does not have detailed monitoring enabled.                                                                                              | Monitoring data helps make better decisions on architecting and managing compute resources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-EC29  | The EC2 instance is not part of an ASG and has Termination Protection disabled.                                                                                                           | Termination Protection safety feature enabled in order to protect the instances from being accidentally terminated.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| AwsSolutions-ECR1  | The ECR Repository allows open access.                                                                                                                                                    | Removing \* principals in an ECR Repository helps protect against unauthorized access.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-ECS4  | The ECS Cluster has CloudWatch Container Insights disabled.                                                                                                                               | CloudWatch Container Insights allow operators to gain a better perspective on how the cluster’s applications and microservices are performing.                                                                                                                                                                                                                                                                                                                                                                                                                         |
| AwsSolutions-ECS7  | The ECS Task Definition does not have awslogs logging enabled at the minimum.                                                                                                             | Container logging allows operators to view and aggregate the logs from the container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| AwsSolutions-EFS1  | The EFS is not configured for encryption at rest.                                                                                                                                         | By using an encrypted file system, data and metadata are automatically encrypted before being written to the file system. Similarly, as data and metadata are read, they are automatically decrypted before being presented to the application. These processes are handled transparently by EFS without requiring modification of applications.                                                                                                                                                                                                                       |
| AwsSolutions-ELB1  | The ELB is used for incoming HTTP/HTTPS traffic. Use ALBs instead.                                                                                                                        | HTTP/HTTPS applications (monolithic or containerized) should use the ALB instead of the ELB for enhanced incoming traffic distribution, better performance and lower costs.                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-ELB2a | The ALB does not have access logs enabled.                                                                                                                                                | Access logs allow operators to to analyze traffic patterns and identify and troubleshoot security issues.                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| AwsSolutions-ELB2e | The ELB does not have access logs enabled.                                                                                                                                                | Access logs allow operators to to analyze traffic patterns and identify and troubleshoot security issues.                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| AwsSolutions-ELB3  | The ELB does not have connection draining enabled.                                                                                                                                        | With Connection Draining feature enabled, if an EC2 backend instance fails health checks the ELB will not send any new requests to the unhealthy instance. However, it will still allow existing (in-flight) requests to complete for the duration of the configured timeout.                                                                                                                                                                                                                                                                                          |
| AwsSolutions-ELB4  | The ELB does not use at least two AZs with the Cross-Zone Load Balancing feature enabled.                                                                                                 | ELBs can distribute the traffic evenly across all backend instances. To use Cross-Zone Load Balancing at optimal level, the system should maintain an equal EC2 capacity distribution in each of the AZs registered with the load balancer.                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-ELB5  | The ELB listener is not configured for secure (HTTPs or SSL) protocols for client communication.                                                                                          | The HTTPs or SSL protocols enable secure communication by encrypting the communication between the client and the load balancer.                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| AwsSolutions-EMR2  | The EMR cluster does not have S3 logging enabled.                                                                                                                                         | Uploading logs to S3 enables the system to keep the logging data for historical purposes or to track and analyze the clusters behavior.                                                                                                                                                                                                                                                                                                                                                                                                                                |
| AwsSolutions-EMR6  | The EMR cluster does not implement authentication via an EC2 Key Pair or Kerberos.                                                                                                        | SSH clients can use an EC2 key pair to authenticate to cluster instances. Alternatively, with EMR release version 5.10.0 or later, solutions can configure Kerberos to authenticate users and SSH connections to the master node.                                                                                                                                                                                                                                                                                                                                      |
| AwsSolutions-ESH1  | The ES domain is not provisioned inside a VPC.                                                                                                                                            | Provisioning the domain within a VPC enables better flexibility and control over the clusters access and security as this feature keeps all traffic between the VPC and Elasticsearch domains within the AWS network instead of going over the public Internet.                                                                                                                                                                                                                                                                                                        |
| AwsSolutions-ESH2  | The ES domain does not have node-to-node encryption enabled.                                                                                                                              | Enabling the node-to-node encryption feature adds an extra layer of data protection on top of the existing ES security features such as HTTPS client to cluster encryption and data-at-rest encryption.                                                                                                                                                                                                                                                                                                                                                                |
| AwsSolutions-ESH3  | The ES domain does not only grant access via allowlisted IP addresses.                                                                                                                    | Using allowlisted IP addresses helps protect the domain against unauthorized access.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| AwsSolutions-ESH4  | The ES domain does not use dedicated master nodes.                                                                                                                                        | 'Using dedicated master nodes helps improve environmental stability by offloading all the management tasks from the data nodes.                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| AwsSolutions-ESH5  | The ES domain does not allow for unsigned requests or anonymous access.                                                                                                                   | Restricting public access helps prevent unauthorized access and prevents any unsigned requests to be made to the resources.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-ESH7  | The ES domain does not have Zone Awareness enabled.                                                                                                                                       | Enabling cross-zone replication (Zone Awareness) increases the availability of the ES domain by allocating the nodes and replicate the data across two AZs in the same region in order to prevent data loss and minimize downtime in the event of node or AZ failure.                                                                                                                                                                                                                                                                                                  |
| AwsSolutions-ESH8  | The ES domain does not have encryption at rest enabled.                                                                                                                                   | Encrypting data-at-rest protects data confidentiality and prevents unauthorized users from accessing sensitive information.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-ESH9  | The ES domain does not minimally publish SEARCH_SLOW_LOGS and INDEX_SLOW_LOGS to CloudWatch Logs.                                                                                         | These logs enable operators to gain full insight into the performance of these operations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| AwsSolutions-IAM4  | The IAM user, role, or group uses AWS managed policies.                                                                                                                                   | An AWS managed policy is a standalone policy that is created and administered by AWS. Currently, many AWS managed policies do not restrict resource scope. Replace AWS managed policies with system specific (customer) managed policies.                                                                                                                                                                                                                                                                                                                              |
| AwsSolutions-IAM5  | The IAM entity contains wildcard permissions and does not have a cdk_nag rule suppression with evidence for those permission.                                                             | Metadata explaining the evidence (e.g. via supporting links) for wildcard permissions allows for transparency to operators.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-KDF1  | The Kinesis Data Firehose delivery stream does have server-side encryption enabled.                                                                                                       | This allows the system to meet strict regulatory requirements and enhance the security of system data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-KDS1  | The Kinesis Data Stream does not has server-side encryption enabled.                                                                                                                      | Data is encrypted before it's written to the Kinesis stream storage layer, and decrypted after it’s retrieved from storage. This allows the system to meet strict regulatory requirements and enhance the security of system data.                                                                                                                                                                                                                                                                                                                                     |
| AwsSolutions-KMS5  | The KMS Symmetric CMK does not have Key Rotation enabled.                                                                                                                                 | KMS Key Rotation allow a system to set an yearly rotation schedule for a CMK so when a customer master key is required to encrypt new data, the KMS service can automatically use the latest version of the HSA backing key to perform the encryption.                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-MS1   | The MediaStore container does not have container access logging enabled.                                                                                                                  | The container should have access logging enabled to provide detailed records for the requests that are made to the container.                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| AwsSolutions-MSK2  | The MSK cluster uses plaintext communication between clients and brokers.                                                                                                                 | TLS only communication secures data-in-transit by encrypting the connection between the clients and brokers.                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AwsSolutions-MSK3  | The MSK cluster uses plaintext communication between brokers.                                                                                                                             | TLS communication secures data-in-transit by encrypting the connection between brokers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| AwsSolutions-MSK6  | The MSK cluster does not send broker logs to a supported destination.                                                                                                                     | Broker logs enable operators to troubleshoot Apache Kafka applications and to analyze their communications with the MSK cluster. The cluster can deliver logs to the following resources: a CloudWatch log group, an S3 bucket, a Kinesis Data Firehose delivery stream.                                                                                                                                                                                                                                                                                               |
| AwsSolutions-N1    | The Neptune DB cluster is not deployed in a Multi-AZ configuration.                                                                                                                       | The cluster should use a Multi-AZ deployment configuration for high availability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| AwsSolutions-N2    | The Neptune DB instance does have Auto Minor Version Upgrade enabled.                                                                                                                     | The Neptune service regularly releases engine updates. Enabling Auto Minor Version Upgrade will allow the service to automatically apply these upgrades to DB Instances.                                                                                                                                                                                                                                                                                                                                                                                               |
| AwsSolutions-N3    | The Neptune DB cluster does not have a reasonable minimum backup retention period configured.                                                                                             | The retention period represents the number of days to retain automated snapshots. A minimum retention period of 7 days is recommended but can be adjust to meet system requirements.                                                                                                                                                                                                                                                                                                                                                                                   |
| AwsSolutions-N4    | The Neptune DB cluster does not have encryption at rest enabled.                                                                                                                          | Encrypting data-at-rest protects data confidentiality and prevents unauthorized users from accessing sensitive information.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-N5    | The Neptune DB cluster does not have IAM Database Authentication enabled.                                                                                                                 | With IAM Database Authentication enabled, the system doesn't have to use a password when connecting to the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| AwsSolutions-QS1   | The Quicksight data sources connection is not configured to use SSL.                                                                                                                      | SSL secures communications to data sources, especially when using public networks. Using SSL with QuickSight requires the use of certificates signed by a publicly-recognized certificate authority.                                                                                                                                                                                                                                                                                                                                                                   |
| AwsSolutions-RDS2  | The RDS instance or Aurora cluster does not have storage encryption enabled.                                                                                                              | Storage encryption helps protect data-at-rest by encrypting the underlying storage, automated backups, read replicas, and snapshots for the database.                                                                                                                                                                                                                                                                                                                                                                                                                  |
| AwsSolutions-RDS6  | The RDS Aurora MySQL/PostgresSQL cluster does not have IAM Database Authentication enabled.                                                                                               | With IAM Database Authentication enabled, the system doesn't have to use a password when connecting to the MySQL/PostgreSQL database instances, instead it uses an authentication token.                                                                                                                                                                                                                                                                                                                                                                               |
| AwsSolutions-RDS10 | The RDS instance or Aurora cluster does not have deletion protection enabled.                                                                                                             | The deletion protection feature helps protect the database from being accidentally deleted.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-RDS11 | The RDS instance or Aurora cluster uses the default endpoint port.                                                                                                                        | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. MySQL/Aurora port 3306, SQL Server port 1433, PostgreSQL port 5432, etc).                                                                                                                                                                                                                                                                                                                                                                  |
| AwsSolutions-RDS13 | The RDS instance is not configured for automated backups.                                                                                                                                 | Automated backups allow for point-in-time recovery.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| AwsSolutions-RDS14 | The RDS Aurora MySQL cluster does not have Backtrack enabled.                                                                                                                             | The RDS Aurora MySQL cluster does not have Backtrack enabled.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| AwsSolutions-RDS16 | The RDS Aurora MySQL serverless cluster does not have audit, error, general, and slowquery Log Exports enabled.                                                                           | This allows operators to use CloudWatch to view logs to help diagnose problems in the database.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| AwsSolutions-RS1   | The Redshift cluster parameter group must have the "require_ssl" parameter enabled.                                                                                                       | Enabling the "require_ssl" parameter secures data-in-transit by encrypting the connection between the clients and the Redshift clusters.                                                                                                                                                                                                                                                                                                                                                                                                                               |
| AwsSolutions-RS2   | The Redshift cluster is not provisioned in a VPC.                                                                                                                                         | Provisioning the cluster within a VPC allows for better flexibility and control over the Redshift clusters security, availability, traffic routing and more.                                                                                                                                                                                                                                                                                                                                                                                                           |
| AwsSolutions-RS3   | The Redshift cluster uses the default "awsuser" username.                                                                                                                                 | Using a custom master user name instead of the default master user name (i.e. "awsuser") provides an additional layer of defense against non-targeted attacks.                                                                                                                                                                                                                                                                                                                                                                                                         |
| AwsSolutions-RS4   | The Redshift cluster uses the default endpoint port.                                                                                                                                      | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. Redshift port 5439).                                                                                                                                                                                                                                                                                                                                                                                                                       |
| AwsSolutions-RS5   | The Redshift cluster does not have audit logging enabled.                                                                                                                                 | Audit logging helps operators troubleshoot issues and ensure security.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-RS6   | The Redshift cluster does not have encryption at rest enabled.                                                                                                                            | Encrypting data-at-rest protects data confidentiality.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-RS8   | The Redshift cluster is publicly accessible.                                                                                                                                              | Disabling public accessibility helps minimize security risks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| AwsSolutions-RS9   | The Redshift cluster does not have version upgrade enabled.                                                                                                                               | Version Upgrade must enabled to enable the cluster to automatically receive upgrades during the maintenance window.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| AwsSolutions-RS10  | The Redshift cluster does not have a retention period for automated snapshots configured.                                                                                                 | The retention period represents the number of days to retain automated snapshots. A positive retention period should be set to configure this feature.                                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-S1    | The S3 Bucket has server access logs disabled.                                                                                                                                            | The bucket should have server access logging enabled to provide detailed records for the requests that are made to the bucket.                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| AwsSolutions-S2    | The S3 Bucket does not have public access restricted and blocked.                                                                                                                         | The bucket should have public access restricted and blocked to prevent unauthorized access.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| AwsSolutions-S3    | The S3 Bucket does not default encryption enabled.                                                                                                                                        | The bucket should minimally have SSE enabled to help protect data-at-rest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| AwsSolutions-SF1   | The Step Function does not log "ALL" events to CloudWatch Logs.                                                                                                                           | Logging "ALL" events to CloudWatch logs help operators troubleshoot and audit systems.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| AwsSolutions-SF2   | The Step Function does not have X-Ray tracing enabled.                                                                                                                                    | X-ray provides an end-to-end view of how an application is performing. This helps operators to discover performance issues, detect permission problems, and track requests made to and from other AWS services.                                                                                                                                                                                                                                                                                                                                                        |
| AwsSolutions-SM1   | The SageMaker notebook instance is not provisioned inside a VPC.                                                                                                                          | Provisioning the notebook instances inside a VPC enables the notebook to access VPC-only resources such as EFS file systems.                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AwsSolutions-SM2   | The SageMaker notebook instance does not have an encrypted storage volume.                                                                                                                | Encrypting storage volumes helps protect SageMaker data-at-rest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| AwsSolutions-SM3   | The SageMaker notebook instance has direct internet access enabled.                                                                                                                       | Disabling public accessibility helps minimize security risks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| AwsSolutions-SNS2  | The SNS Topic does not have server-side encryption enabled.                                                                                                                               | Server side encryption adds additional protection of sensitive data delivered as messages to subscribers.                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| AwsSolutions-SQS2  | The SQS Queue does not have server-side encryption enabled.                                                                                                                               | Server side encryption adds additional protection of sensitive data delivered as messages to subscribers.                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| AwsSolutions-SQS3  | The SQS queue does not have a dead-letter queue (DLQ) enabled or have a cdk_nag rule suppression indicating it is a DLQ.                                                                  | Using a DLQ helps maintain the queue flow and avoid losing data by detecting and mitigating failures and service disruptions on time.                                                                                                                                                                                                                                                                                                                                                                                                                                  |

## NIST 800-53

The [Operational Best Practices for NIST 800-53 rev 4](https://docs.aws.amazon.com/config/latest/developerguide/operational-best-practices-for-nist-800-53_rev_4.html) Conformance Pack offers a collection of AWS Config Rules that enable customers to align to a subset of the NIST 800-53 standards. The NIST 800-53 Rules Pack implements many of the checks within the conformance pack.

### Warnings

There are no warnings for this rule pack.

### Errors

| Rule ID                                                                                                                                                      | Summary                                                                                                         | Explanation                                                                                                                                                                                                                                                                                                                                                   |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [NIST.800.53-EC2CheckDetailedMonitoring](https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html)             | The EC2 instance does not have detailed monitoring enabled - (Control IDs: CA-7(a)(b), SI-4(2), SI-4(a)(b)(c)). | Detailed monitoring provides additional monitoring information (such as 1-minute period graphs) on the AWS console.                                                                                                                                                                                                                                           |
| [NIST.800.53-EC2CheckInsideVPC](https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html)                                          | The EC2 instance is not within a VPC - (Control IDs: AC-4, SC-7, SC-7(3)).                                      | Because of their logical isolation, domains that reside within an Amazon VPC have an extra layer of security when compared to domains that use public endpoints.                                                                                                                                                                                              |
| [NIST.800.53-EC2CheckNoPublicIPs](https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html)                                   | The EC2 instance is associated with a public IP address - (Control IDs: AC-4, AC-6, AC-21(b), SC-7, SC-7(3)).   | Amazon EC2 instances can contain sensitive information and access control is required for such resources.                                                                                                                                                                                                                                                     |
| [NIST.800.53-EC2CheckSSHRestricted](https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html)                                            | The Security Group allows unrestricted SSH access - (Control IDs: AC-4, SC-7, SC-7(3)).                         | Not allowing ingress (or remote) traffic from 0.0.0.0/0 or ::/0 to port 22 on your resources helps to restrict remote access.                                                                                                                                                                                                                                 |
| [NIST.800.53-EFSEncrypted](https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html)                                                | The EFS does not have encryption at rest enabled - (Control IDs: SC-13, SC-28).                                 | Because sensitive data can exist and to help protect data at rest, ensure encryption is enabled for your Amazon Elastic File System (EFS).                                                                                                                                                                                                                    |
| [NIST.800.53-IAMGroupMembership](https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html)                              | The IAM user does not belong to any group(s) - (Control IDs: AC-2(1), AC-2(j), AC-3, AC-6.).                    | AWS Identity and Access Management (IAM) can help you restrict access permissions and authorizations by ensuring IAM users are members of at least one group. Allowing users more privileges than needed to complete a task may violate the principle of least privilege and separation of duties.                                                            |
| [NIST.800.53-IAMNoUserNoPolicy](https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html)                                    | The IAM policy is attached at the user level - (AC-2(j), AC-3, AC-5c, AC-6).                                    | Assigning privileges at the group or the role level helps to reduce opportunity for an identity to receive or retain excessive privileges.                                                                                                                                                                                                                    |
| [NIST.800.53-IAMNoInlinePolicy](https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html)                                    | The IAM Group, User, or Role contains an inline policy - (Control ID: AC-6).                                    | AWS recommends to use managed policies instead of inline policies. The managed policies allow reusability, versioning and rolling back, and delegating permissions management.                                                                                                                                                                                |
| [NIST.800.53-IAMPolicyNoStatementsWithAdminAccess](https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html) | The IAM policy grants admin access - (Control IDs: AC-2(1), AC-2(j), AC-3, AC-6).                               | AWS Identity and Access Management (IAM) can help you incorporate the principles of least privilege and separation of duties with access permissions and authorizations, by ensuring that IAM groups have at least one IAM user. Placing IAM users in groups based on their associated permissions or job function is one way to incorporate least privilege. |

### Excluded Rules

Rules from the AWS NIST 800-53 Conformance Pack which could not be implemented.

| AWS Config Rule Name                                                                                                 | Summary                                                                                                 | Relevant Control IDs  |
| -------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- | --------------------- |
| [ec2-imdsv2-check](https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html)                   | The EC2 instance has IMDSV2 (instance metadata service version 2) enabled.                              | AC-6                  |
| [efs-in-backup-plan](https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html)               | EFS is in an AWS Backup plan.                                                                           | CP-9(b), CP-10, SI-12 |
| [iam-user-mfa-enabled](https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html)           | AWS Identity and Access Management users have multi-factor authentication (MFA) enabled.                | IA-2(1)(2)(11)        |
| [iam-password-policy](https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html)             | The account password policy for IAM users meets the specified requirements indicated in the parameters. | AC-2(1)               |
| [iam-group-has-users-check](https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html) | IAM groups have at least one IAM user.                                                                  | AC-2(j)               |
