# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arguebuf', 'arguebuf.models', 'arguebuf.schema', 'arguebuf.services']

package_data = \
{'': ['*']}

install_requires = \
['arg-services>=0.3.8,<0.4.0',
 'graphviz>=0.20,<0.21',
 'lxml>=4.9.0,<5.0.0',
 'networkx>=2.8.4,<3.0.0',
 'pendulum>=2.1.2,<3.0.0']

extras_require = \
{'docs': ['sphinx>=4.5.0,<5.0.0',
          'furo>=2022.6.4.1,<2023.0.0.0',
          'myst-parser>=0.18.0,<0.19.0',
          'sphinx-autoapi>=1.8.4,<2.0.0',
          'autodocsumm>=0.2.8,<0.3.0']}

setup_kwargs = {
    'name': 'arguebuf',
    'version': '1.1.2',
    'description': 'A library for loading argument graphs in various formats (e.g., AIF).',
    'long_description': '# Arguebuf\n\nArguebuf is a format for serializing argument graphs and specified using Protobuf.\nThe complete specification and documentation is available at the [Buf Schema Registry](https://buf.build/recap/arg-services/docs/main:arg_services.graph.v1).\nWhile Protobuf automatically generates native code for all major programming languages (including Python), we created a custom implementation that provides some additional benefits, including:\n\n- The ability to import existing formats like [AIF](http://www.argumentinterchange.org), [SADFace](https://github.com/Open-Argumentation/SADFace), and a few others.\n- Export of Arguebuf graphs to AIF, [NetworkX](https://networkx.org), and [Graphviz](https://graphviz.org).\n- Integration with the popular NLP library [spaCy](http://spacy.io).\n- Various helper methods to programmatically manipulate/create argument graphs.\n- More pythonic interfaces than the regular code generated by `protoc`.\n\nYou can easily install the library from [PyPI](https://pypi.org/project/arguebuf/) using pip. The documentation is hosted on [ReadTheDocs](https://arguebuf.readthedocs.io/en/latest/)\n',
    'author': 'Mirko Lenz',
    'author_email': 'info@mirko-lenz.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://recap.uni-trier.de',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
