# coding: utf-8

"""
    Patch API V1

    The core API used to integrate with Patch's service  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: developers@usepatch.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import os

from patch_api.api_client import ApiClient


class TestPreferencesApi(unittest.TestCase):
    """PreferencesApi unit test stubs"""

    def setUp(self):
        api_client = ApiClient(api_key=os.environ.get("SANDBOX_API_KEY"))
        self.api = api_client.preferences  # noqa: E501

    def tearDown(self):
        self.api = None

    def test_retrieve_preferences_and_preference(self):
        """Test case for retrieve_preferences and retrieve_preference

        creates a project preference  # noqa: E501
        """
        preferences = self.api.retrieve_preferences()
        self.assertTrue(isinstance(preferences.data, list))

        if len(preferences.data) > 0:
            preference_id = preferences.data[0].id
            preference = self.api.retrieve_preference(id=preference_id).data

            self.assertTrue(preference.allocation_percentage)
            self.assertTrue(preference.id)
            self.assertTrue(preference.project)

    def test_delete_and_create_preferences(self):
        """Test case for create_preference and delete_preference"""
        project_id = "pro_test_0de1a59eed9ff8474e09077ddb3714b2"
        preferences = self.api.retrieve_preferences()
        if len(preferences.data) > 0:
            preference_id = preferences.data[0].id
            deleted_preference = self.api.delete_preference(id=preference_id)

            self.assertTrue(deleted_preference)

        preference = self.api.create_preference(project_id=project_id).data
        self.assertTrue(preference.allocation_percentage)
        self.assertTrue(preference.id)
        self.assertTrue(preference.project)


if __name__ == "__main__":
    unittest.main()
