#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.link import LinkFragment, QUERY as LinkFragmentQuery

from ..fragment.page_info import PageInfoFragment, QUERY as PageInfoFragmentQuery


# fmt: off
QUERY: List[str] = LinkFragmentQuery + PageInfoFragmentQuery + ["""
query LinksQuery($after: Cursor, $first: Int) {
  links(after: $after, first: $first) {
    edges {
      node {
        ...LinkFragment
      }
    }
    pageInfo {
      ...PageInfoFragment
    }
  }
}

"""
]


class LinksQuery:
    @dataclass(frozen=True)
    class LinksQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class LinkConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class LinkEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Link(LinkFragment):
                    pass

                node: Optional[Link]

            @dataclass(frozen=True)
            class PageInfo(PageInfoFragment):
                pass

            edges: List[LinkEdge]
            pageInfo: PageInfo

        links: LinkConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None) -> LinksQueryData.LinkConnection:
        variables: Dict[str, Any] = {"after": after, "first": first}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.LinksQueryData.from_dict(response_text)
        return res.links

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None) -> LinksQueryData.LinkConnection:
        variables: Dict[str, Any] = {"after": after, "first": first}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.LinksQueryData.from_dict(response_text)
        return res.links
