# -*- coding: utf-8 -*-
"""`Concordance between SCIAN2018 and ISIC4 <https://www.inegi.org.mx/app/scian/>`_.
"""
from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import SCIAN2018

SCIAN2018_to_ISIC4 = Concordance(
    src=SCIAN2018,
    dst=ISIC4,
    concordances=[
        ((Standards.SCIAN2018, "111110"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111121"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111122"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111129"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111131"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111132"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111139"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111140"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111151"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111152"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111160"), (Standards.ISIC4, "0112")),
        ((Standards.SCIAN2018, "111191"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111192"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111193"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111194"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111195"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111199"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111211"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111212"), (Standards.ISIC4, "0128")),
        ((Standards.SCIAN2018, "111213"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111214"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111215"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111216"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111217"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111218"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111219"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111219"), (Standards.ISIC4, "0119")),
        ((Standards.SCIAN2018, "111310"), (Standards.ISIC4, "0123")),
        ((Standards.SCIAN2018, "111321"), (Standards.ISIC4, "0123")),
        ((Standards.SCIAN2018, "111329"), (Standards.ISIC4, "0123")),
        ((Standards.SCIAN2018, "111331"), (Standards.ISIC4, "0127")),
        ((Standards.SCIAN2018, "111332"), (Standards.ISIC4, "0122")),
        ((Standards.SCIAN2018, "111333"), (Standards.ISIC4, "0122")),
        ((Standards.SCIAN2018, "111334"), (Standards.ISIC4, "0122")),
        ((Standards.SCIAN2018, "111335"), (Standards.ISIC4, "0121")),
        ((Standards.SCIAN2018, "111336"), (Standards.ISIC4, "0124")),
        ((Standards.SCIAN2018, "111337"), (Standards.ISIC4, "0127")),
        ((Standards.SCIAN2018, "111338"), (Standards.ISIC4, "0126")),
        ((Standards.SCIAN2018, "111339"), (Standards.ISIC4, "0122")),
        ((Standards.SCIAN2018, "111339"), (Standards.ISIC4, "0124")),
        ((Standards.SCIAN2018, "111339"), (Standards.ISIC4, "0125")),
        ((Standards.SCIAN2018, "111339"), (Standards.ISIC4, "0126")),
        ((Standards.SCIAN2018, "111411"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111412"), (Standards.ISIC4, "0125")),
        ((Standards.SCIAN2018, "111413"), (Standards.ISIC4, "0125")),
        ((Standards.SCIAN2018, "111414"), (Standards.ISIC4, "0128")),
        ((Standards.SCIAN2018, "111415"), (Standards.ISIC4, "0124")),
        ((Standards.SCIAN2018, "111416"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111419"), (Standards.ISIC4, "0130")),
        ((Standards.SCIAN2018, "111419"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111419"), (Standards.ISIC4, "0128")),
        ((Standards.SCIAN2018, "111421"), (Standards.ISIC4, "0119")),
        ((Standards.SCIAN2018, "111422"), (Standards.ISIC4, "0119")),
        ((Standards.SCIAN2018, "111423"), (Standards.ISIC4, "0129")),
        ((Standards.SCIAN2018, "111429"), (Standards.ISIC4, "0130")),
        ((Standards.SCIAN2018, "111910"), (Standards.ISIC4, "0115")),
        ((Standards.SCIAN2018, "111920"), (Standards.ISIC4, "0116")),
        ((Standards.SCIAN2018, "111930"), (Standards.ISIC4, "0114")),
        ((Standards.SCIAN2018, "111941"), (Standards.ISIC4, "0119")),
        ((Standards.SCIAN2018, "111942"), (Standards.ISIC4, "0119")),
        ((Standards.SCIAN2018, "111991"), (Standards.ISIC4, "0127")),
        ((Standards.SCIAN2018, "111992"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111993"), (Standards.ISIC4, "0150")),
        ((Standards.SCIAN2018, "111994"), (Standards.ISIC4, "0150")),
        ((Standards.SCIAN2018, "111995"), (Standards.ISIC4, "0150")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0111")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0113")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0116")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0119")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0125")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0127")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0128")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0129")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0130")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0164")),
        ((Standards.SCIAN2018, "111999"), (Standards.ISIC4, "0230")),
        ((Standards.SCIAN2018, "112110"), (Standards.ISIC4, "0141")),
        ((Standards.SCIAN2018, "112120"), (Standards.ISIC4, "0141")),
        ((Standards.SCIAN2018, "112131"), (Standards.ISIC4, "0141")),
        ((Standards.SCIAN2018, "112139"), (Standards.ISIC4, "0141")),
        ((Standards.SCIAN2018, "112211"), (Standards.ISIC4, "0145")),
        ((Standards.SCIAN2018, "112212"), (Standards.ISIC4, "0145")),
        ((Standards.SCIAN2018, "112311"), (Standards.ISIC4, "0146")),
        ((Standards.SCIAN2018, "112312"), (Standards.ISIC4, "0146")),
        ((Standards.SCIAN2018, "112320"), (Standards.ISIC4, "0146")),
        ((Standards.SCIAN2018, "112330"), (Standards.ISIC4, "0146")),
        ((Standards.SCIAN2018, "112340"), (Standards.ISIC4, "0146")),
        ((Standards.SCIAN2018, "112390"), (Standards.ISIC4, "0146")),
        ((Standards.SCIAN2018, "112390"), (Standards.ISIC4, "0149")),
        ((Standards.SCIAN2018, "112410"), (Standards.ISIC4, "0144")),
        ((Standards.SCIAN2018, "112420"), (Standards.ISIC4, "0144")),
        ((Standards.SCIAN2018, "112511"), (Standards.ISIC4, "0321")),
        ((Standards.SCIAN2018, "112511"), (Standards.ISIC4, "0322")),
        ((Standards.SCIAN2018, "112512"), (Standards.ISIC4, "0321")),
        ((Standards.SCIAN2018, "112512"), (Standards.ISIC4, "0322")),
        ((Standards.SCIAN2018, "112910"), (Standards.ISIC4, "0149")),
        ((Standards.SCIAN2018, "112920"), (Standards.ISIC4, "0142")),
        ((Standards.SCIAN2018, "112930"), (Standards.ISIC4, "0149")),
        ((Standards.SCIAN2018, "112991"), (Standards.ISIC4, "0150")),
        ((Standards.SCIAN2018, "112999"), (Standards.ISIC4, "0143")),
        ((Standards.SCIAN2018, "112999"), (Standards.ISIC4, "0149")),
        ((Standards.SCIAN2018, "113110"), (Standards.ISIC4, "0210")),
        ((Standards.SCIAN2018, "113211"), (Standards.ISIC4, "0210")),
        ((Standards.SCIAN2018, "113212"), (Standards.ISIC4, "0220")),
        ((Standards.SCIAN2018, "113212"), (Standards.ISIC4, "0230")),
        ((Standards.SCIAN2018, "113310"), (Standards.ISIC4, "0220")),
        ((Standards.SCIAN2018, "113310"), (Standards.ISIC4, "1610")),
        ((Standards.SCIAN2018, "114111"), (Standards.ISIC4, "0311")),
        ((Standards.SCIAN2018, "114111"), (Standards.ISIC4, "0312")),
        ((Standards.SCIAN2018, "114112"), (Standards.ISIC4, "0311")),
        ((Standards.SCIAN2018, "114113"), (Standards.ISIC4, "0311")),
        ((Standards.SCIAN2018, "114119"), (Standards.ISIC4, "0311")),
        ((Standards.SCIAN2018, "114119"), (Standards.ISIC4, "0312")),
        ((Standards.SCIAN2018, "114210"), (Standards.ISIC4, "0170")),
        ((Standards.SCIAN2018, "115111"), (Standards.ISIC4, "0161")),
        ((Standards.SCIAN2018, "115112"), (Standards.ISIC4, "0163")),
        ((Standards.SCIAN2018, "115113"), (Standards.ISIC4, "0163")),
        ((Standards.SCIAN2018, "115119"), (Standards.ISIC4, "0161")),
        ((Standards.SCIAN2018, "115210"), (Standards.ISIC4, "0141")),
        ((Standards.SCIAN2018, "115210"), (Standards.ISIC4, "0162")),
        ((Standards.SCIAN2018, "115310"), (Standards.ISIC4, "0240")),
        ((Standards.SCIAN2018, "211111"), (Standards.ISIC4, "0610")),
        ((Standards.SCIAN2018, "211111"), (Standards.ISIC4, "0620")),
        ((Standards.SCIAN2018, "211112"), (Standards.ISIC4, "0610")),
        ((Standards.SCIAN2018, "211112"), (Standards.ISIC4, "0620")),
        ((Standards.SCIAN2018, "212110"), (Standards.ISIC4, "0510")),
        ((Standards.SCIAN2018, "212110"), (Standards.ISIC4, "0520")),
        ((Standards.SCIAN2018, "212210"), (Standards.ISIC4, "0710")),
        ((Standards.SCIAN2018, "212221"), (Standards.ISIC4, "0729")),
        ((Standards.SCIAN2018, "212222"), (Standards.ISIC4, "0729")),
        ((Standards.SCIAN2018, "212231"), (Standards.ISIC4, "0729")),
        ((Standards.SCIAN2018, "212232"), (Standards.ISIC4, "0729")),
        ((Standards.SCIAN2018, "212291"), (Standards.ISIC4, "0729")),
        ((Standards.SCIAN2018, "212292"), (Standards.ISIC4, "0729")),
        ((Standards.SCIAN2018, "212293"), (Standards.ISIC4, "0721")),
        ((Standards.SCIAN2018, "212299"), (Standards.ISIC4, "0729")),
        ((Standards.SCIAN2018, "212311"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212311"), (Standards.ISIC4, "0891")),
        ((Standards.SCIAN2018, "212312"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212319"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212319"), (Standards.ISIC4, "0899")),
        ((Standards.SCIAN2018, "212321"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212322"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212323"), (Standards.ISIC4, "0899")),
        ((Standards.SCIAN2018, "212324"), (Standards.ISIC4, "0899")),
        ((Standards.SCIAN2018, "212325"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212329"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212391"), (Standards.ISIC4, "0893")),
        ((Standards.SCIAN2018, "212392"), (Standards.ISIC4, "0810")),
        ((Standards.SCIAN2018, "212393"), (Standards.ISIC4, "0891")),
        ((Standards.SCIAN2018, "212394"), (Standards.ISIC4, "0891")),
        ((Standards.SCIAN2018, "212395"), (Standards.ISIC4, "0891")),
        ((Standards.SCIAN2018, "212396"), (Standards.ISIC4, "0899")),
        ((Standards.SCIAN2018, "212397"), (Standards.ISIC4, "0891")),
        ((Standards.SCIAN2018, "212398"), (Standards.ISIC4, "0891")),
        ((Standards.SCIAN2018, "212399"), (Standards.ISIC4, "0891")),
        ((Standards.SCIAN2018, "212399"), (Standards.ISIC4, "0892")),
        ((Standards.SCIAN2018, "212399"), (Standards.ISIC4, "0899")),
        ((Standards.SCIAN2018, "213111"), (Standards.ISIC4, "0910")),
        ((Standards.SCIAN2018, "213119"), (Standards.ISIC4, "0990")),
        ((Standards.SCIAN2018, "213119"), (Standards.ISIC4, "4312")),
        ((Standards.SCIAN2018, "221111"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221112"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221113"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221114"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221119"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221121"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221122"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221123"), (Standards.ISIC4, "3510")),
        ((Standards.SCIAN2018, "221210"), (Standards.ISIC4, "3520")),
        ((Standards.SCIAN2018, "221210"), (Standards.ISIC4, "3530")),
        ((Standards.SCIAN2018, "221311"), (Standards.ISIC4, "3600")),
        ((Standards.SCIAN2018, "221311"), (Standards.ISIC4, "3700")),
        ((Standards.SCIAN2018, "221311"), (Standards.ISIC4, "4930")),
        ((Standards.SCIAN2018, "221312"), (Standards.ISIC4, "3600")),
        ((Standards.SCIAN2018, "221312"), (Standards.ISIC4, "3700")),
        ((Standards.SCIAN2018, "221312"), (Standards.ISIC4, "4930")),
        ((Standards.SCIAN2018, "236111"), (Standards.ISIC4, "4100")),
        ((Standards.SCIAN2018, "236112"), (Standards.ISIC4, "4100")),
        ((Standards.SCIAN2018, "236113"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "236211"), (Standards.ISIC4, "4100")),
        ((Standards.SCIAN2018, "236211"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "236211"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "236212"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "236221"), (Standards.ISIC4, "4100")),
        ((Standards.SCIAN2018, "236221"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "236222"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "237111"), (Standards.ISIC4, "4220")),
        ((Standards.SCIAN2018, "237112"), (Standards.ISIC4, "4220")),
        ((Standards.SCIAN2018, "237113"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "237121"), (Standards.ISIC4, "4220")),
        ((Standards.SCIAN2018, "237122"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "237123"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "237131"), (Standards.ISIC4, "4220")),
        ((Standards.SCIAN2018, "237132"), (Standards.ISIC4, "4220")),
        ((Standards.SCIAN2018, "237133"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "237211"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "237212"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "237213"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "237311"), (Standards.ISIC4, "4321")),
        ((Standards.SCIAN2018, "237312"), (Standards.ISIC4, "4210")),
        ((Standards.SCIAN2018, "237313"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "237991"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "237992"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "237993"), (Standards.ISIC4, "4210")),
        ((Standards.SCIAN2018, "237994"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "237999"), (Standards.ISIC4, "4220")),
        ((Standards.SCIAN2018, "237999"), (Standards.ISIC4, "4290")),
        ((Standards.SCIAN2018, "237999"), (Standards.ISIC4, "4312")),
        ((Standards.SCIAN2018, "238110"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "238121"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "238122"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "238130"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238190"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238210"), (Standards.ISIC4, "4321")),
        ((Standards.SCIAN2018, "238221"), (Standards.ISIC4, "4322")),
        ((Standards.SCIAN2018, "238222"), (Standards.ISIC4, "3320")),
        ((Standards.SCIAN2018, "238222"), (Standards.ISIC4, "4322")),
        ((Standards.SCIAN2018, "238222"), (Standards.ISIC4, "4329")),
        ((Standards.SCIAN2018, "238222"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "238290"), (Standards.ISIC4, "3320")),
        ((Standards.SCIAN2018, "238290"), (Standards.ISIC4, "4321")),
        ((Standards.SCIAN2018, "238290"), (Standards.ISIC4, "4329")),
        ((Standards.SCIAN2018, "238311"), (Standards.ISIC4, "4329")),
        ((Standards.SCIAN2018, "238311"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238312"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238320"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238330"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238340"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238350"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238390"), (Standards.ISIC4, "4330")),
        ((Standards.SCIAN2018, "238390"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "238910"), (Standards.ISIC4, "4311")),
        ((Standards.SCIAN2018, "238910"), (Standards.ISIC4, "4312")),
        ((Standards.SCIAN2018, "238910"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "238990"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "311110"), (Standards.ISIC4, "1080")),
        ((Standards.SCIAN2018, "311211"), (Standards.ISIC4, "1061")),
        ((Standards.SCIAN2018, "311212"), (Standards.ISIC4, "1061")),
        ((Standards.SCIAN2018, "311213"), (Standards.ISIC4, "1061")),
        ((Standards.SCIAN2018, "311214"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311214"), (Standards.ISIC4, "1061")),
        ((Standards.SCIAN2018, "311215"), (Standards.ISIC4, "1103")),
        ((Standards.SCIAN2018, "311221"), (Standards.ISIC4, "1062")),
        ((Standards.SCIAN2018, "311222"), (Standards.ISIC4, "1040")),
        ((Standards.SCIAN2018, "311222"), (Standards.ISIC4, "1062")),
        ((Standards.SCIAN2018, "311230"), (Standards.ISIC4, "1061")),
        ((Standards.SCIAN2018, "311311"), (Standards.ISIC4, "1072")),
        ((Standards.SCIAN2018, "311319"), (Standards.ISIC4, "1072")),
        ((Standards.SCIAN2018, "311340"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311340"), (Standards.ISIC4, "1073")),
        ((Standards.SCIAN2018, "311350"), (Standards.ISIC4, "1073")),
        ((Standards.SCIAN2018, "311411"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311412"), (Standards.ISIC4, "1010")),
        ((Standards.SCIAN2018, "311412"), (Standards.ISIC4, "1074")),
        ((Standards.SCIAN2018, "311412"), (Standards.ISIC4, "1075")),
        ((Standards.SCIAN2018, "311412"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311421"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311422"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311423"), (Standards.ISIC4, "1074")),
        ((Standards.SCIAN2018, "311423"), (Standards.ISIC4, "1075")),
        ((Standards.SCIAN2018, "311423"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311511"), (Standards.ISIC4, "1050")),
        ((Standards.SCIAN2018, "311512"), (Standards.ISIC4, "1050")),
        ((Standards.SCIAN2018, "311512"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311513"), (Standards.ISIC4, "1050")),
        ((Standards.SCIAN2018, "311513"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311520"), (Standards.ISIC4, "1050")),
        ((Standards.SCIAN2018, "311611"), (Standards.ISIC4, "1010")),
        ((Standards.SCIAN2018, "311612"), (Standards.ISIC4, "1010")),
        ((Standards.SCIAN2018, "311613"), (Standards.ISIC4, "1010")),
        ((Standards.SCIAN2018, "311613"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311614"), (Standards.ISIC4, "1010")),
        ((Standards.SCIAN2018, "311710"), (Standards.ISIC4, "0311")),
        ((Standards.SCIAN2018, "311710"), (Standards.ISIC4, "1020")),
        ((Standards.SCIAN2018, "311710"), (Standards.ISIC4, "1040")),
        ((Standards.SCIAN2018, "311710"), (Standards.ISIC4, "1075")),
        ((Standards.SCIAN2018, "311710"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311811"), (Standards.ISIC4, "1071")),
        ((Standards.SCIAN2018, "311812"), (Standards.ISIC4, "1071")),
        ((Standards.SCIAN2018, "311813"), (Standards.ISIC4, "1071")),
        ((Standards.SCIAN2018, "311820"), (Standards.ISIC4, "1061")),
        ((Standards.SCIAN2018, "311820"), (Standards.ISIC4, "1071")),
        ((Standards.SCIAN2018, "311820"), (Standards.ISIC4, "1074")),
        ((Standards.SCIAN2018, "311830"), (Standards.ISIC4, "1062")),
        ((Standards.SCIAN2018, "311830"), (Standards.ISIC4, "1071")),
        ((Standards.SCIAN2018, "311910"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311910"), (Standards.ISIC4, "1071")),
        ((Standards.SCIAN2018, "311921"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311922"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311923"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311924"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311930"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311930"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311940"), (Standards.ISIC4, "0893")),
        ((Standards.SCIAN2018, "311940"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311991"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311992"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311993"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311993"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "311999"), (Standards.ISIC4, "1030")),
        ((Standards.SCIAN2018, "311999"), (Standards.ISIC4, "1079")),
        ((Standards.SCIAN2018, "312111"), (Standards.ISIC4, "1104")),
        ((Standards.SCIAN2018, "312112"), (Standards.ISIC4, "1104")),
        ((Standards.SCIAN2018, "312113"), (Standards.ISIC4, "3530")),
        ((Standards.SCIAN2018, "312120"), (Standards.ISIC4, "1103")),
        ((Standards.SCIAN2018, "312131"), (Standards.ISIC4, "1101")),
        ((Standards.SCIAN2018, "312132"), (Standards.ISIC4, "1102")),
        ((Standards.SCIAN2018, "312139"), (Standards.ISIC4, "1102")),
        ((Standards.SCIAN2018, "312141"), (Standards.ISIC4, "1101")),
        ((Standards.SCIAN2018, "312142"), (Standards.ISIC4, "1101")),
        ((Standards.SCIAN2018, "312143"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "312149"), (Standards.ISIC4, "1101")),
        ((Standards.SCIAN2018, "312210"), (Standards.ISIC4, "1200")),
        ((Standards.SCIAN2018, "312221"), (Standards.ISIC4, "1200")),
        ((Standards.SCIAN2018, "312222"), (Standards.ISIC4, "1200")),
        ((Standards.SCIAN2018, "313111"), (Standards.ISIC4, "1311")),
        ((Standards.SCIAN2018, "313111"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "313112"), (Standards.ISIC4, "1311")),
        ((Standards.SCIAN2018, "313113"), (Standards.ISIC4, "1311")),
        ((Standards.SCIAN2018, "313210"), (Standards.ISIC4, "1312")),
        ((Standards.SCIAN2018, "313220"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "313230"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "313240"), (Standards.ISIC4, "1391")),
        ((Standards.SCIAN2018, "313240"), (Standards.ISIC4, "1392")),
        ((Standards.SCIAN2018, "313240"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "313310"), (Standards.ISIC4, "1313")),
        ((Standards.SCIAN2018, "313320"), (Standards.ISIC4, "1313")),
        ((Standards.SCIAN2018, "313320"), (Standards.ISIC4, "2219")),
        ((Standards.SCIAN2018, "314110"), (Standards.ISIC4, "1393")),
        ((Standards.SCIAN2018, "314120"), (Standards.ISIC4, "1392")),
        ((Standards.SCIAN2018, "314120"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "314911"), (Standards.ISIC4, "1392")),
        ((Standards.SCIAN2018, "314912"), (Standards.ISIC4, "1392")),
        ((Standards.SCIAN2018, "314991"), (Standards.ISIC4, "1313")),
        ((Standards.SCIAN2018, "314992"), (Standards.ISIC4, "1394")),
        ((Standards.SCIAN2018, "314992"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "314993"), (Standards.ISIC4, "1311")),
        ((Standards.SCIAN2018, "314993"), (Standards.ISIC4, "1392")),
        ((Standards.SCIAN2018, "314999"), (Standards.ISIC4, "1393")),
        ((Standards.SCIAN2018, "314999"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "314999"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315110"), (Standards.ISIC4, "1430")),
        ((Standards.SCIAN2018, "315191"), (Standards.ISIC4, "1430")),
        ((Standards.SCIAN2018, "315192"), (Standards.ISIC4, "1430")),
        ((Standards.SCIAN2018, "315210"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315210"), (Standards.ISIC4, "1420")),
        ((Standards.SCIAN2018, "315221"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315222"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315223"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315224"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315225"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315229"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315991"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315999"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "315999"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "315999"), (Standards.ISIC4, "1420")),
        ((Standards.SCIAN2018, "316110"), (Standards.ISIC4, "1511")),
        ((Standards.SCIAN2018, "316211"), (Standards.ISIC4, "1520")),
        ((Standards.SCIAN2018, "316212"), (Standards.ISIC4, "1520")),
        ((Standards.SCIAN2018, "316213"), (Standards.ISIC4, "1520")),
        ((Standards.SCIAN2018, "316214"), (Standards.ISIC4, "1520")),
        ((Standards.SCIAN2018, "316219"), (Standards.ISIC4, "1520")),
        ((Standards.SCIAN2018, "316991"), (Standards.ISIC4, "1512")),
        ((Standards.SCIAN2018, "316999"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "316999"), (Standards.ISIC4, "1512")),
        ((Standards.SCIAN2018, "316999"), (Standards.ISIC4, "1520")),
        ((Standards.SCIAN2018, "321111"), (Standards.ISIC4, "1610")),
        ((Standards.SCIAN2018, "321111"), (Standards.ISIC4, "1621")),
        ((Standards.SCIAN2018, "321111"), (Standards.ISIC4, "1622")),
        ((Standards.SCIAN2018, "321111"), (Standards.ISIC4, "1623")),
        ((Standards.SCIAN2018, "321111"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "321112"), (Standards.ISIC4, "1610")),
        ((Standards.SCIAN2018, "321113"), (Standards.ISIC4, "1610")),
        ((Standards.SCIAN2018, "321210"), (Standards.ISIC4, "1621")),
        ((Standards.SCIAN2018, "321210"), (Standards.ISIC4, "1622")),
        ((Standards.SCIAN2018, "321910"), (Standards.ISIC4, "1610")),
        ((Standards.SCIAN2018, "321910"), (Standards.ISIC4, "1622")),
        ((Standards.SCIAN2018, "321920"), (Standards.ISIC4, "1623")),
        ((Standards.SCIAN2018, "321920"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "321991"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "321992"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "321993"), (Standards.ISIC4, "1623")),
        ((Standards.SCIAN2018, "321999"), (Standards.ISIC4, "1610")),
        ((Standards.SCIAN2018, "321999"), (Standards.ISIC4, "1622")),
        ((Standards.SCIAN2018, "321999"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "322110"), (Standards.ISIC4, "1701")),
        ((Standards.SCIAN2018, "322121"), (Standards.ISIC4, "1701")),
        ((Standards.SCIAN2018, "322121"), (Standards.ISIC4, "1702")),
        ((Standards.SCIAN2018, "322121"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "322122"), (Standards.ISIC4, "1701")),
        ((Standards.SCIAN2018, "322122"), (Standards.ISIC4, "1702")),
        ((Standards.SCIAN2018, "322122"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "322122"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "322131"), (Standards.ISIC4, "1701")),
        ((Standards.SCIAN2018, "322131"), (Standards.ISIC4, "1702")),
        ((Standards.SCIAN2018, "322131"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "322132"), (Standards.ISIC4, "1701")),
        ((Standards.SCIAN2018, "322132"), (Standards.ISIC4, "1702")),
        ((Standards.SCIAN2018, "322210"), (Standards.ISIC4, "1702")),
        ((Standards.SCIAN2018, "322210"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "322220"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "322220"), (Standards.ISIC4, "1701")),
        ((Standards.SCIAN2018, "322220"), (Standards.ISIC4, "1702")),
        ((Standards.SCIAN2018, "322220"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "322220"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "322220"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "322220"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "322230"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "322291"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "322299"), (Standards.ISIC4, "1702")),
        ((Standards.SCIAN2018, "322299"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "323111"), (Standards.ISIC4, "1811")),
        ((Standards.SCIAN2018, "323119"), (Standards.ISIC4, "1313")),
        ((Standards.SCIAN2018, "323119"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "323119"), (Standards.ISIC4, "1811")),
        ((Standards.SCIAN2018, "323119"), (Standards.ISIC4, "8219")),
        ((Standards.SCIAN2018, "323120"), (Standards.ISIC4, "1812")),
        ((Standards.SCIAN2018, "324110"), (Standards.ISIC4, "1920")),
        ((Standards.SCIAN2018, "324120"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "324191"), (Standards.ISIC4, "1920")),
        ((Standards.SCIAN2018, "324199"), (Standards.ISIC4, "1910")),
        ((Standards.SCIAN2018, "325110"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325120"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325130"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325180"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325180"), (Standards.ISIC4, "2012")),
        ((Standards.SCIAN2018, "325190"), (Standards.ISIC4, "1910")),
        ((Standards.SCIAN2018, "325190"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325190"), (Standards.ISIC4, "2022")),
        ((Standards.SCIAN2018, "325190"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325190"), (Standards.ISIC4, "2100")),
        ((Standards.SCIAN2018, "325211"), (Standards.ISIC4, "2013")),
        ((Standards.SCIAN2018, "325212"), (Standards.ISIC4, "2013")),
        ((Standards.SCIAN2018, "325220"), (Standards.ISIC4, "2030")),
        ((Standards.SCIAN2018, "325220"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "325310"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325310"), (Standards.ISIC4, "2012")),
        ((Standards.SCIAN2018, "325320"), (Standards.ISIC4, "2021")),
        ((Standards.SCIAN2018, "325411"), (Standards.ISIC4, "2100")),
        ((Standards.SCIAN2018, "325412"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325412"), (Standards.ISIC4, "2100")),
        ((Standards.SCIAN2018, "325510"), (Standards.ISIC4, "2022")),
        ((Standards.SCIAN2018, "325520"), (Standards.ISIC4, "2022")),
        ((Standards.SCIAN2018, "325520"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325610"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325610"), (Standards.ISIC4, "2021")),
        ((Standards.SCIAN2018, "325610"), (Standards.ISIC4, "2023")),
        ((Standards.SCIAN2018, "325610"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325620"), (Standards.ISIC4, "2023")),
        ((Standards.SCIAN2018, "325910"), (Standards.ISIC4, "2022")),
        ((Standards.SCIAN2018, "325920"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325991"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325992"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325993"), (Standards.ISIC4, "2013")),
        ((Standards.SCIAN2018, "325999"), (Standards.ISIC4, "2011")),
        ((Standards.SCIAN2018, "325999"), (Standards.ISIC4, "2022")),
        ((Standards.SCIAN2018, "325999"), (Standards.ISIC4, "2023")),
        ((Standards.SCIAN2018, "325999"), (Standards.ISIC4, "2029")),
        ((Standards.SCIAN2018, "325999"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "325999"), (Standards.ISIC4, "2817")),
        ((Standards.SCIAN2018, "325999"), (Standards.ISIC4, "8292")),
        ((Standards.SCIAN2018, "326110"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326120"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326130"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326140"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326150"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326160"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326191"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326192"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326193"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326194"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326194"), (Standards.ISIC4, "3100")),
        ((Standards.SCIAN2018, "326198"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326198"), (Standards.ISIC4, "2720")),
        ((Standards.SCIAN2018, "326198"), (Standards.ISIC4, "3100")),
        ((Standards.SCIAN2018, "326199"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326211"), (Standards.ISIC4, "2219")),
        ((Standards.SCIAN2018, "326212"), (Standards.ISIC4, "2211")),
        ((Standards.SCIAN2018, "326220"), (Standards.ISIC4, "2219")),
        ((Standards.SCIAN2018, "326220"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "326290"), (Standards.ISIC4, "2219")),
        ((Standards.SCIAN2018, "326290"), (Standards.ISIC4, "2720")),
        ((Standards.SCIAN2018, "327111"), (Standards.ISIC4, "2393")),
        ((Standards.SCIAN2018, "327112"), (Standards.ISIC4, "2392")),
        ((Standards.SCIAN2018, "327121"), (Standards.ISIC4, "2392")),
        ((Standards.SCIAN2018, "327121"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327122"), (Standards.ISIC4, "2392")),
        ((Standards.SCIAN2018, "327123"), (Standards.ISIC4, "2391")),
        ((Standards.SCIAN2018, "327211"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327212"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327213"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327214"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327215"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327216"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327219"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327310"), (Standards.ISIC4, "2394")),
        ((Standards.SCIAN2018, "327310"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327320"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327330"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327391"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327399"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327410"), (Standards.ISIC4, "2394")),
        ((Standards.SCIAN2018, "327420"), (Standards.ISIC4, "2394")),
        ((Standards.SCIAN2018, "327420"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327910"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "327991"), (Standards.ISIC4, "2396")),
        ((Standards.SCIAN2018, "327999"), (Standards.ISIC4, "2310")),
        ((Standards.SCIAN2018, "327999"), (Standards.ISIC4, "2395")),
        ((Standards.SCIAN2018, "327999"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "327999"), (Standards.ISIC4, "3211")),
        ((Standards.SCIAN2018, "331111"), (Standards.ISIC4, "2410")),
        ((Standards.SCIAN2018, "331112"), (Standards.ISIC4, "2410")),
        ((Standards.SCIAN2018, "331210"), (Standards.ISIC4, "2431")),
        ((Standards.SCIAN2018, "331220"), (Standards.ISIC4, "2410")),
        ((Standards.SCIAN2018, "331220"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "331220"), (Standards.ISIC4, "2732")),
        ((Standards.SCIAN2018, "331310"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "331310"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "331310"), (Standards.ISIC4, "2732")),
        ((Standards.SCIAN2018, "331411"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "331412"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "331419"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "331420"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "331420"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "331420"), (Standards.ISIC4, "2732")),
        ((Standards.SCIAN2018, "331490"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "331490"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "331510"), (Standards.ISIC4, "2431")),
        ((Standards.SCIAN2018, "331510"), (Standards.ISIC4, "2823")),
        ((Standards.SCIAN2018, "331520"), (Standards.ISIC4, "2432")),
        ((Standards.SCIAN2018, "332110"), (Standards.ISIC4, "2591")),
        ((Standards.SCIAN2018, "332110"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "332211"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "332211"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "332211"), (Standards.ISIC4, "2816")),
        ((Standards.SCIAN2018, "332211"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "332211"), (Standards.ISIC4, "2821")),
        ((Standards.SCIAN2018, "332212"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "332212"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "332310"), (Standards.ISIC4, "2511")),
        ((Standards.SCIAN2018, "332310"), (Standards.ISIC4, "3011")),
        ((Standards.SCIAN2018, "332320"), (Standards.ISIC4, "2511")),
        ((Standards.SCIAN2018, "332320"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "332410"), (Standards.ISIC4, "2513")),
        ((Standards.SCIAN2018, "332410"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "332420"), (Standards.ISIC4, "2512")),
        ((Standards.SCIAN2018, "332420"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "332430"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "332510"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "332610"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "332610"), (Standards.ISIC4, "3099")),
        ((Standards.SCIAN2018, "332710"), (Standards.ISIC4, "2592")),
        ((Standards.SCIAN2018, "332720"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "332810"), (Standards.ISIC4, "2592")),
        ((Standards.SCIAN2018, "332910"), (Standards.ISIC4, "2410")),
        ((Standards.SCIAN2018, "332910"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "332910"), (Standards.ISIC4, "2812")),
        ((Standards.SCIAN2018, "332910"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "332910"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "332991"), (Standards.ISIC4, "2814")),
        ((Standards.SCIAN2018, "332999"), (Standards.ISIC4, "2023")),
        ((Standards.SCIAN2018, "332999"), (Standards.ISIC4, "2410")),
        ((Standards.SCIAN2018, "332999"), (Standards.ISIC4, "2420")),
        ((Standards.SCIAN2018, "332999"), (Standards.ISIC4, "2520")),
        ((Standards.SCIAN2018, "332999"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "332999"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "333111"), (Standards.ISIC4, "2818")),
        ((Standards.SCIAN2018, "333111"), (Standards.ISIC4, "2821")),
        ((Standards.SCIAN2018, "333111"), (Standards.ISIC4, "2825")),
        ((Standards.SCIAN2018, "333111"), (Standards.ISIC4, "2826")),
        ((Standards.SCIAN2018, "333111"), (Standards.ISIC4, "3099")),
        ((Standards.SCIAN2018, "333112"), (Standards.ISIC4, "2818")),
        ((Standards.SCIAN2018, "333112"), (Standards.ISIC4, "2821")),
        ((Standards.SCIAN2018, "333120"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "333120"), (Standards.ISIC4, "2816")),
        ((Standards.SCIAN2018, "333120"), (Standards.ISIC4, "2818")),
        ((Standards.SCIAN2018, "333120"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333120"), (Standards.ISIC4, "2821")),
        ((Standards.SCIAN2018, "333120"), (Standards.ISIC4, "2824")),
        ((Standards.SCIAN2018, "333130"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "333130"), (Standards.ISIC4, "2818")),
        ((Standards.SCIAN2018, "333130"), (Standards.ISIC4, "2824")),
        ((Standards.SCIAN2018, "333130"), (Standards.ISIC4, "3020")),
        ((Standards.SCIAN2018, "333241"), (Standards.ISIC4, "2822")),
        ((Standards.SCIAN2018, "333242"), (Standards.ISIC4, "2822")),
        ((Standards.SCIAN2018, "333242"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "333243"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333243"), (Standards.ISIC4, "2825")),
        ((Standards.SCIAN2018, "333244"), (Standards.ISIC4, "2826")),
        ((Standards.SCIAN2018, "333245"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "333246"), (Standards.ISIC4, "2815")),
        ((Standards.SCIAN2018, "333246"), (Standards.ISIC4, "2822")),
        ((Standards.SCIAN2018, "333246"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "333249"), (Standards.ISIC4, "2823")),
        ((Standards.SCIAN2018, "333249"), (Standards.ISIC4, "2825")),
        ((Standards.SCIAN2018, "333249"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "333249"), (Standards.ISIC4, "3250")),
        ((Standards.SCIAN2018, "333311"), (Standards.ISIC4, "2670")),
        ((Standards.SCIAN2018, "333312"), (Standards.ISIC4, "2817")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2670")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2817")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2822")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2825")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2826")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "3030")),
        ((Standards.SCIAN2018, "333319"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "333411"), (Standards.ISIC4, "2512")),
        ((Standards.SCIAN2018, "333411"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "333411"), (Standards.ISIC4, "2815")),
        ((Standards.SCIAN2018, "333411"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333412"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333510"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "333510"), (Standards.ISIC4, "2822")),
        ((Standards.SCIAN2018, "333510"), (Standards.ISIC4, "2823")),
        ((Standards.SCIAN2018, "333510"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "333610"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "333610"), (Standards.ISIC4, "2811")),
        ((Standards.SCIAN2018, "333610"), (Standards.ISIC4, "2814")),
        ((Standards.SCIAN2018, "333610"), (Standards.ISIC4, "2910")),
        ((Standards.SCIAN2018, "333610"), (Standards.ISIC4, "3091")),
        ((Standards.SCIAN2018, "333910"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "333910"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333920"), (Standards.ISIC4, "2816")),
        ((Standards.SCIAN2018, "333920"), (Standards.ISIC4, "3020")),
        ((Standards.SCIAN2018, "333991"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "333991"), (Standards.ISIC4, "2710")),
        ((Standards.SCIAN2018, "333991"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "333992"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333993"), (Standards.ISIC4, "2651")),
        ((Standards.SCIAN2018, "333993"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333999"), (Standards.ISIC4, "2812")),
        ((Standards.SCIAN2018, "333999"), (Standards.ISIC4, "2815")),
        ((Standards.SCIAN2018, "333999"), (Standards.ISIC4, "2816")),
        ((Standards.SCIAN2018, "333999"), (Standards.ISIC4, "2818")),
        ((Standards.SCIAN2018, "333999"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "333999"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "333999"), (Standards.ISIC4, "3250")),
        ((Standards.SCIAN2018, "334110"), (Standards.ISIC4, "2620")),
        ((Standards.SCIAN2018, "334210"), (Standards.ISIC4, "2630")),
        ((Standards.SCIAN2018, "334220"), (Standards.ISIC4, "2630")),
        ((Standards.SCIAN2018, "334220"), (Standards.ISIC4, "2651")),
        ((Standards.SCIAN2018, "334220"), (Standards.ISIC4, "3030")),
        ((Standards.SCIAN2018, "334290"), (Standards.ISIC4, "2630")),
        ((Standards.SCIAN2018, "334290"), (Standards.ISIC4, "2651")),
        ((Standards.SCIAN2018, "334290"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "334290"), (Standards.ISIC4, "3020")),
        ((Standards.SCIAN2018, "334310"), (Standards.ISIC4, "2640")),
        ((Standards.SCIAN2018, "334410"), (Standards.ISIC4, "2610")),
        ((Standards.SCIAN2018, "334511"), (Standards.ISIC4, "2652")),
        ((Standards.SCIAN2018, "334519"), (Standards.ISIC4, "2651")),
        ((Standards.SCIAN2018, "334519"), (Standards.ISIC4, "2652")),
        ((Standards.SCIAN2018, "334519"), (Standards.ISIC4, "2660")),
        ((Standards.SCIAN2018, "334610"), (Standards.ISIC4, "1820")),
        ((Standards.SCIAN2018, "334610"), (Standards.ISIC4, "2680")),
        ((Standards.SCIAN2018, "335110"), (Standards.ISIC4, "2740")),
        ((Standards.SCIAN2018, "335120"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "335120"), (Standards.ISIC4, "2740")),
        ((Standards.SCIAN2018, "335120"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "335210"), (Standards.ISIC4, "2750")),
        ((Standards.SCIAN2018, "335220"), (Standards.ISIC4, "2750")),
        ((Standards.SCIAN2018, "335311"), (Standards.ISIC4, "2710")),
        ((Standards.SCIAN2018, "335312"), (Standards.ISIC4, "2710")),
        ((Standards.SCIAN2018, "335312"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "335910"), (Standards.ISIC4, "2720")),
        ((Standards.SCIAN2018, "335920"), (Standards.ISIC4, "2731")),
        ((Standards.SCIAN2018, "335920"), (Standards.ISIC4, "2732")),
        ((Standards.SCIAN2018, "335930"), (Standards.ISIC4, "2733")),
        ((Standards.SCIAN2018, "335991"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "335999"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "336110"), (Standards.ISIC4, "2910")),
        ((Standards.SCIAN2018, "336120"), (Standards.ISIC4, "2910")),
        ((Standards.SCIAN2018, "336210"), (Standards.ISIC4, "2816")),
        ((Standards.SCIAN2018, "336210"), (Standards.ISIC4, "2910")),
        ((Standards.SCIAN2018, "336210"), (Standards.ISIC4, "2920")),
        ((Standards.SCIAN2018, "336210"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336310"), (Standards.ISIC4, "2811")),
        ((Standards.SCIAN2018, "336310"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "336310"), (Standards.ISIC4, "2910")),
        ((Standards.SCIAN2018, "336310"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336320"), (Standards.ISIC4, "2740")),
        ((Standards.SCIAN2018, "336320"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "336320"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336330"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "336330"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336340"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "336340"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "336340"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336350"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "336350"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336360"), (Standards.ISIC4, "1392")),
        ((Standards.SCIAN2018, "336360"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "336360"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "336360"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336360"), (Standards.ISIC4, "3011")),
        ((Standards.SCIAN2018, "336360"), (Standards.ISIC4, "3020")),
        ((Standards.SCIAN2018, "336360"), (Standards.ISIC4, "3030")),
        ((Standards.SCIAN2018, "336370"), (Standards.ISIC4, "2591")),
        ((Standards.SCIAN2018, "336390"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "336390"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "336390"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336410"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "336410"), (Standards.ISIC4, "3030")),
        ((Standards.SCIAN2018, "336510"), (Standards.ISIC4, "2910")),
        ((Standards.SCIAN2018, "336510"), (Standards.ISIC4, "3020")),
        ((Standards.SCIAN2018, "336610"), (Standards.ISIC4, "3011")),
        ((Standards.SCIAN2018, "336610"), (Standards.ISIC4, "3012")),
        ((Standards.SCIAN2018, "336610"), (Standards.ISIC4, "3315")),
        ((Standards.SCIAN2018, "336991"), (Standards.ISIC4, "3091")),
        ((Standards.SCIAN2018, "336992"), (Standards.ISIC4, "3092")),
        ((Standards.SCIAN2018, "336999"), (Standards.ISIC4, "2910")),
        ((Standards.SCIAN2018, "336999"), (Standards.ISIC4, "2930")),
        ((Standards.SCIAN2018, "336999"), (Standards.ISIC4, "3040")),
        ((Standards.SCIAN2018, "336999"), (Standards.ISIC4, "3099")),
        ((Standards.SCIAN2018, "337110"), (Standards.ISIC4, "3100")),
        ((Standards.SCIAN2018, "337120"), (Standards.ISIC4, "3100")),
        ((Standards.SCIAN2018, "337120"), (Standards.ISIC4, "3250")),
        ((Standards.SCIAN2018, "337210"), (Standards.ISIC4, "1622")),
        ((Standards.SCIAN2018, "337210"), (Standards.ISIC4, "2511")),
        ((Standards.SCIAN2018, "337210"), (Standards.ISIC4, "3100")),
        ((Standards.SCIAN2018, "337910"), (Standards.ISIC4, "2219")),
        ((Standards.SCIAN2018, "337910"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "337910"), (Standards.ISIC4, "3100")),
        ((Standards.SCIAN2018, "337920"), (Standards.ISIC4, "1392")),
        ((Standards.SCIAN2018, "337920"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "337920"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "337920"), (Standards.ISIC4, "2593")),
        ((Standards.SCIAN2018, "337920"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "339111"), (Standards.ISIC4, "2813")),
        ((Standards.SCIAN2018, "339111"), (Standards.ISIC4, "3092")),
        ((Standards.SCIAN2018, "339111"), (Standards.ISIC4, "3250")),
        ((Standards.SCIAN2018, "339111"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "339112"), (Standards.ISIC4, "2100")),
        ((Standards.SCIAN2018, "339112"), (Standards.ISIC4, "3250")),
        ((Standards.SCIAN2018, "339113"), (Standards.ISIC4, "3250")),
        ((Standards.SCIAN2018, "339911"), (Standards.ISIC4, "3211")),
        ((Standards.SCIAN2018, "339912"), (Standards.ISIC4, "2592")),
        ((Standards.SCIAN2018, "339912"), (Standards.ISIC4, "3211")),
        ((Standards.SCIAN2018, "339913"), (Standards.ISIC4, "3212")),
        ((Standards.SCIAN2018, "339914"), (Standards.ISIC4, "3212")),
        ((Standards.SCIAN2018, "339920"), (Standards.ISIC4, "2219")),
        ((Standards.SCIAN2018, "339920"), (Standards.ISIC4, "2829")),
        ((Standards.SCIAN2018, "339920"), (Standards.ISIC4, "3230")),
        ((Standards.SCIAN2018, "339920"), (Standards.ISIC4, "3240")),
        ((Standards.SCIAN2018, "339930"), (Standards.ISIC4, "2640")),
        ((Standards.SCIAN2018, "339930"), (Standards.ISIC4, "3092")),
        ((Standards.SCIAN2018, "339930"), (Standards.ISIC4, "3240")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "1701")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "2022")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "2817")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "339940"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "339950"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "339950"), (Standards.ISIC4, "1811")),
        ((Standards.SCIAN2018, "339950"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "339950"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "339950"), (Standards.ISIC4, "2790")),
        ((Standards.SCIAN2018, "339991"), (Standards.ISIC4, "3220")),
        ((Standards.SCIAN2018, "339992"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "339992"), (Standards.ISIC4, "2826")),
        ((Standards.SCIAN2018, "339992"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "339993"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "339994"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "339995"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "1399")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "1410")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "1512")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "1629")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "1709")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "2023")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "2219")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "2220")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "2399")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "2599")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "2819")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "3240")),
        ((Standards.SCIAN2018, "339999"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "431110"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431121"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431122"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431123"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431130"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431140"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431150"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431160"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431170"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431180"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431191"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431192"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431193"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431194"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431199"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431211"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431212"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431213"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "431220"), (Standards.ISIC4, "4620")),
        ((Standards.SCIAN2018, "431220"), (Standards.ISIC4, "4630")),
        ((Standards.SCIAN2018, "432111"), (Standards.ISIC4, "4641")),
        ((Standards.SCIAN2018, "432112"), (Standards.ISIC4, "4641")),
        ((Standards.SCIAN2018, "432113"), (Standards.ISIC4, "4620")),
        ((Standards.SCIAN2018, "432119"), (Standards.ISIC4, "4641")),
        ((Standards.SCIAN2018, "432120"), (Standards.ISIC4, "4641")),
        ((Standards.SCIAN2018, "432130"), (Standards.ISIC4, "4641")),
        ((Standards.SCIAN2018, "433110"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433210"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433220"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433311"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433311"), (Standards.ISIC4, "4652")),
        ((Standards.SCIAN2018, "433312"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433313"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433410"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433420"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433430"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "433510"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "434111"), (Standards.ISIC4, "4620")),
        ((Standards.SCIAN2018, "434111"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434112"), (Standards.ISIC4, "4620")),
        ((Standards.SCIAN2018, "434112"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434211"), (Standards.ISIC4, "4663")),
        ((Standards.SCIAN2018, "434219"), (Standards.ISIC4, "4663")),
        ((Standards.SCIAN2018, "434221"), (Standards.ISIC4, "4662")),
        ((Standards.SCIAN2018, "434222"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434223"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434224"), (Standards.ISIC4, "4663")),
        ((Standards.SCIAN2018, "434225"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "434226"), (Standards.ISIC4, "4663")),
        ((Standards.SCIAN2018, "434227"), (Standards.ISIC4, "4663")),
        ((Standards.SCIAN2018, "434228"), (Standards.ISIC4, "4620")),
        ((Standards.SCIAN2018, "434229"), (Standards.ISIC4, "4663")),
        ((Standards.SCIAN2018, "434230"), (Standards.ISIC4, "4661")),
        ((Standards.SCIAN2018, "434240"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "434311"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434312"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434313"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434314"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "434319"), (Standards.ISIC4, "4669")),
        ((Standards.SCIAN2018, "435110"), (Standards.ISIC4, "4653")),
        ((Standards.SCIAN2018, "435210"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435220"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435311"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "435311"), (Standards.ISIC4, "4652")),
        ((Standards.SCIAN2018, "435311"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435312"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435313"), (Standards.ISIC4, "4649")),
        ((Standards.SCIAN2018, "435313"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435319"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435411"), (Standards.ISIC4, "4651")),
        ((Standards.SCIAN2018, "435411"), (Standards.ISIC4, "4652")),
        ((Standards.SCIAN2018, "435412"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435419"), (Standards.ISIC4, "4659")),
        ((Standards.SCIAN2018, "435419"), (Standards.ISIC4, "4663")),
        ((Standards.SCIAN2018, "436111"), (Standards.ISIC4, "4510")),
        ((Standards.SCIAN2018, "436112"), (Standards.ISIC4, "4530")),
        ((Standards.SCIAN2018, "437111"), (Standards.ISIC4, "4610")),
        ((Standards.SCIAN2018, "437112"), (Standards.ISIC4, "4610")),
        ((Standards.SCIAN2018, "437113"), (Standards.ISIC4, "4610")),
        ((Standards.SCIAN2018, "437210"), (Standards.ISIC4, "4610")),
        ((Standards.SCIAN2018, "461110"), (Standards.ISIC4, "4711")),
        ((Standards.SCIAN2018, "461121"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461121"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461122"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461122"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461123"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461123"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461130"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461130"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461140"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461140"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461150"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461150"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461160"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461160"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461170"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461170"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461190"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "461190"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461211"), (Standards.ISIC4, "4722")),
        ((Standards.SCIAN2018, "461211"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461212"), (Standards.ISIC4, "4722")),
        ((Standards.SCIAN2018, "461212"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461213"), (Standards.ISIC4, "4722")),
        ((Standards.SCIAN2018, "461213"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "461220"), (Standards.ISIC4, "4723")),
        ((Standards.SCIAN2018, "461220"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "462111"), (Standards.ISIC4, "4711")),
        ((Standards.SCIAN2018, "462112"), (Standards.ISIC4, "4711")),
        ((Standards.SCIAN2018, "462210"), (Standards.ISIC4, "4719")),
        ((Standards.SCIAN2018, "463111"), (Standards.ISIC4, "4751")),
        ((Standards.SCIAN2018, "463111"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463112"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463112"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463113"), (Standards.ISIC4, "4751")),
        ((Standards.SCIAN2018, "463113"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463211"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463211"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463212"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463212"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463213"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463213"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463214"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463214"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463215"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463215"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463216"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463216"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463217"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463217"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463218"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463218"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "463310"), (Standards.ISIC4, "4771")),
        ((Standards.SCIAN2018, "463310"), (Standards.ISIC4, "4782")),
        ((Standards.SCIAN2018, "464111"), (Standards.ISIC4, "4772")),
        ((Standards.SCIAN2018, "464112"), (Standards.ISIC4, "4719")),
        ((Standards.SCIAN2018, "464113"), (Standards.ISIC4, "4721")),
        ((Standards.SCIAN2018, "464113"), (Standards.ISIC4, "4781")),
        ((Standards.SCIAN2018, "464121"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "464121"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "464122"), (Standards.ISIC4, "4772")),
        ((Standards.SCIAN2018, "465111"), (Standards.ISIC4, "4772")),
        ((Standards.SCIAN2018, "465111"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465112"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "465112"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465211"), (Standards.ISIC4, "4762")),
        ((Standards.SCIAN2018, "465211"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465212"), (Standards.ISIC4, "4764")),
        ((Standards.SCIAN2018, "465212"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465213"), (Standards.ISIC4, "4764")),
        ((Standards.SCIAN2018, "465213"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465214"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "465214"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465215"), (Standards.ISIC4, "4763")),
        ((Standards.SCIAN2018, "465215"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465216"), (Standards.ISIC4, "4759")),
        ((Standards.SCIAN2018, "465216"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465311"), (Standards.ISIC4, "4761")),
        ((Standards.SCIAN2018, "465311"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465312"), (Standards.ISIC4, "4761")),
        ((Standards.SCIAN2018, "465312"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465313"), (Standards.ISIC4, "4761")),
        ((Standards.SCIAN2018, "465313"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465911"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "465911"), (Standards.ISIC4, "4799")),
        ((Standards.SCIAN2018, "465912"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "465912"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465913"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "465913"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465914"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "465914"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "465915"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "465919"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "466111"), (Standards.ISIC4, "4759")),
        ((Standards.SCIAN2018, "466111"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466112"), (Standards.ISIC4, "4742")),
        ((Standards.SCIAN2018, "466112"), (Standards.ISIC4, "4759")),
        ((Standards.SCIAN2018, "466112"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466113"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "466113"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466114"), (Standards.ISIC4, "4759")),
        ((Standards.SCIAN2018, "466114"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466211"), (Standards.ISIC4, "4741")),
        ((Standards.SCIAN2018, "466211"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466212"), (Standards.ISIC4, "4741")),
        ((Standards.SCIAN2018, "466212"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466311"), (Standards.ISIC4, "4753")),
        ((Standards.SCIAN2018, "466311"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466312"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "466312"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466313"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "466313"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466314"), (Standards.ISIC4, "4759")),
        ((Standards.SCIAN2018, "466314"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466319"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "466319"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "466410"), (Standards.ISIC4, "4774")),
        ((Standards.SCIAN2018, "466410"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "467111"), (Standards.ISIC4, "4752")),
        ((Standards.SCIAN2018, "467112"), (Standards.ISIC4, "4752")),
        ((Standards.SCIAN2018, "467113"), (Standards.ISIC4, "4752")),
        ((Standards.SCIAN2018, "467113"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "467114"), (Standards.ISIC4, "4752")),
        ((Standards.SCIAN2018, "467114"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "467115"), (Standards.ISIC4, "4773")),
        ((Standards.SCIAN2018, "467115"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "467116"), (Standards.ISIC4, "4752")),
        ((Standards.SCIAN2018, "467117"), (Standards.ISIC4, "4752")),
        ((Standards.SCIAN2018, "468111"), (Standards.ISIC4, "4510")),
        ((Standards.SCIAN2018, "468112"), (Standards.ISIC4, "4510")),
        ((Standards.SCIAN2018, "468211"), (Standards.ISIC4, "4530")),
        ((Standards.SCIAN2018, "468211"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "468212"), (Standards.ISIC4, "4530")),
        ((Standards.SCIAN2018, "468212"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "468213"), (Standards.ISIC4, "4530")),
        ((Standards.SCIAN2018, "468213"), (Standards.ISIC4, "4789")),
        ((Standards.SCIAN2018, "468311"), (Standards.ISIC4, "4540")),
        ((Standards.SCIAN2018, "468319"), (Standards.ISIC4, "4510")),
        ((Standards.SCIAN2018, "468411"), (Standards.ISIC4, "4730")),
        ((Standards.SCIAN2018, "468412"), (Standards.ISIC4, "4799")),
        ((Standards.SCIAN2018, "468413"), (Standards.ISIC4, "4730")),
        ((Standards.SCIAN2018, "468414"), (Standards.ISIC4, "4730")),
        ((Standards.SCIAN2018, "468419"), (Standards.ISIC4, "4661")),
        ((Standards.SCIAN2018, "468420"), (Standards.ISIC4, "4730")),
        ((Standards.SCIAN2018, "468420"), (Standards.ISIC4, "4799")),
        ((Standards.SCIAN2018, "469110"), (Standards.ISIC4, "4791")),
        ((Standards.SCIAN2018, "469110"), (Standards.ISIC4, "4799")),
        ((Standards.SCIAN2018, "481111"), (Standards.ISIC4, "5110")),
        ((Standards.SCIAN2018, "481111"), (Standards.ISIC4, "5120")),
        ((Standards.SCIAN2018, "481112"), (Standards.ISIC4, "5110")),
        ((Standards.SCIAN2018, "481112"), (Standards.ISIC4, "5120")),
        ((Standards.SCIAN2018, "481210"), (Standards.ISIC4, "5110")),
        ((Standards.SCIAN2018, "481210"), (Standards.ISIC4, "5120")),
        ((Standards.SCIAN2018, "482110"), (Standards.ISIC4, "4911")),
        ((Standards.SCIAN2018, "482110"), (Standards.ISIC4, "4912")),
        ((Standards.SCIAN2018, "483111"), (Standards.ISIC4, "5011")),
        ((Standards.SCIAN2018, "483111"), (Standards.ISIC4, "5012")),
        ((Standards.SCIAN2018, "483112"), (Standards.ISIC4, "5011")),
        ((Standards.SCIAN2018, "483112"), (Standards.ISIC4, "5012")),
        ((Standards.SCIAN2018, "483113"), (Standards.ISIC4, "5012")),
        ((Standards.SCIAN2018, "483210"), (Standards.ISIC4, "5021")),
        ((Standards.SCIAN2018, "483210"), (Standards.ISIC4, "5022")),
        ((Standards.SCIAN2018, "484111"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484119"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484121"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484129"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484210"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484221"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484222"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484223"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484224"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484229"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484231"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484232"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484233"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484234"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "484239"), (Standards.ISIC4, "4923")),
        ((Standards.SCIAN2018, "485111"), (Standards.ISIC4, "4921")),
        ((Standards.SCIAN2018, "485112"), (Standards.ISIC4, "4921")),
        ((Standards.SCIAN2018, "485113"), (Standards.ISIC4, "4921")),
        ((Standards.SCIAN2018, "485114"), (Standards.ISIC4, "4921")),
        ((Standards.SCIAN2018, "485115"), (Standards.ISIC4, "4921")),
        ((Standards.SCIAN2018, "485210"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "485311"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "485312"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "485320"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "485410"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "485510"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "485990"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "486110"), (Standards.ISIC4, "4930")),
        ((Standards.SCIAN2018, "486210"), (Standards.ISIC4, "4930")),
        ((Standards.SCIAN2018, "486910"), (Standards.ISIC4, "4930")),
        ((Standards.SCIAN2018, "486990"), (Standards.ISIC4, "4930")),
        ((Standards.SCIAN2018, "487110"), (Standards.ISIC4, "4911")),
        ((Standards.SCIAN2018, "487110"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "487210"), (Standards.ISIC4, "5011")),
        ((Standards.SCIAN2018, "487210"), (Standards.ISIC4, "5021")),
        ((Standards.SCIAN2018, "487990"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "487990"), (Standards.ISIC4, "5110")),
        ((Standards.SCIAN2018, "488111"), (Standards.ISIC4, "5223")),
        ((Standards.SCIAN2018, "488112"), (Standards.ISIC4, "5223")),
        ((Standards.SCIAN2018, "488112"), (Standards.ISIC4, "5224")),
        ((Standards.SCIAN2018, "488112"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "488190"), (Standards.ISIC4, "3315")),
        ((Standards.SCIAN2018, "488190"), (Standards.ISIC4, "5223")),
        ((Standards.SCIAN2018, "488210"), (Standards.ISIC4, "3315")),
        ((Standards.SCIAN2018, "488210"), (Standards.ISIC4, "5221")),
        ((Standards.SCIAN2018, "488210"), (Standards.ISIC4, "5224")),
        ((Standards.SCIAN2018, "488210"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "488310"), (Standards.ISIC4, "5222")),
        ((Standards.SCIAN2018, "488320"), (Standards.ISIC4, "5224")),
        ((Standards.SCIAN2018, "488330"), (Standards.ISIC4, "5222")),
        ((Standards.SCIAN2018, "488390"), (Standards.ISIC4, "3315")),
        ((Standards.SCIAN2018, "488390"), (Standards.ISIC4, "5222")),
        ((Standards.SCIAN2018, "488390"), (Standards.ISIC4, "5229")),
        ((Standards.SCIAN2018, "488390"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "488410"), (Standards.ISIC4, "5221")),
        ((Standards.SCIAN2018, "488491"), (Standards.ISIC4, "5221")),
        ((Standards.SCIAN2018, "488492"), (Standards.ISIC4, "5221")),
        ((Standards.SCIAN2018, "488492"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "488493"), (Standards.ISIC4, "5224")),
        ((Standards.SCIAN2018, "488493"), (Standards.ISIC4, "5229")),
        ((Standards.SCIAN2018, "488511"), (Standards.ISIC4, "5229")),
        ((Standards.SCIAN2018, "488519"), (Standards.ISIC4, "5229")),
        ((Standards.SCIAN2018, "488990"), (Standards.ISIC4, "5229")),
        ((Standards.SCIAN2018, "488990"), (Standards.ISIC4, "0910")),
        ((Standards.SCIAN2018, "491110"), (Standards.ISIC4, "5310")),
        ((Standards.SCIAN2018, "492110"), (Standards.ISIC4, "5320")),
        ((Standards.SCIAN2018, "492210"), (Standards.ISIC4, "5320")),
        ((Standards.SCIAN2018, "493111"), (Standards.ISIC4, "5210")),
        ((Standards.SCIAN2018, "493119"), (Standards.ISIC4, "5210")),
        ((Standards.SCIAN2018, "493120"), (Standards.ISIC4, "5210")),
        ((Standards.SCIAN2018, "493130"), (Standards.ISIC4, "5210")),
        ((Standards.SCIAN2018, "493190"), (Standards.ISIC4, "5210")),
        ((Standards.SCIAN2018, "511111"), (Standards.ISIC4, "5813")),
        ((Standards.SCIAN2018, "511112"), (Standards.ISIC4, "5813")),
        ((Standards.SCIAN2018, "511121"), (Standards.ISIC4, "5813")),
        ((Standards.SCIAN2018, "511122"), (Standards.ISIC4, "5813")),
        ((Standards.SCIAN2018, "511131"), (Standards.ISIC4, "5811")),
        ((Standards.SCIAN2018, "511132"), (Standards.ISIC4, "5811")),
        ((Standards.SCIAN2018, "511141"), (Standards.ISIC4, "5812")),
        ((Standards.SCIAN2018, "511142"), (Standards.ISIC4, "5812")),
        ((Standards.SCIAN2018, "511191"), (Standards.ISIC4, "5811")),
        ((Standards.SCIAN2018, "511191"), (Standards.ISIC4, "5819")),
        ((Standards.SCIAN2018, "511192"), (Standards.ISIC4, "5811")),
        ((Standards.SCIAN2018, "511192"), (Standards.ISIC4, "5819")),
        ((Standards.SCIAN2018, "511210"), (Standards.ISIC4, "5820")),
        ((Standards.SCIAN2018, "512111"), (Standards.ISIC4, "5911")),
        ((Standards.SCIAN2018, "512112"), (Standards.ISIC4, "5911")),
        ((Standards.SCIAN2018, "512113"), (Standards.ISIC4, "5911")),
        ((Standards.SCIAN2018, "512120"), (Standards.ISIC4, "5913")),
        ((Standards.SCIAN2018, "512130"), (Standards.ISIC4, "5914")),
        ((Standards.SCIAN2018, "512190"), (Standards.ISIC4, "5912")),
        ((Standards.SCIAN2018, "512230"), (Standards.ISIC4, "5920")),
        ((Standards.SCIAN2018, "512240"), (Standards.ISIC4, "5920")),
        ((Standards.SCIAN2018, "512250"), (Standards.ISIC4, "5920")),
        ((Standards.SCIAN2018, "512290"), (Standards.ISIC4, "5920")),
        ((Standards.SCIAN2018, "515110"), (Standards.ISIC4, "6010")),
        ((Standards.SCIAN2018, "515110"), (Standards.ISIC4, "6120")),
        ((Standards.SCIAN2018, "515120"), (Standards.ISIC4, "6020")),
        ((Standards.SCIAN2018, "515210"), (Standards.ISIC4, "6020")),
        ((Standards.SCIAN2018, "515210"), (Standards.ISIC4, "6120")),
        ((Standards.SCIAN2018, "517311"), (Standards.ISIC4, "6110")),
        ((Standards.SCIAN2018, "517311"), (Standards.ISIC4, "6130")),
        ((Standards.SCIAN2018, "517312"), (Standards.ISIC4, "6120")),
        ((Standards.SCIAN2018, "517410"), (Standards.ISIC4, "6130")),
        ((Standards.SCIAN2018, "517410"), (Standards.ISIC4, "6190")),
        ((Standards.SCIAN2018, "517910"), (Standards.ISIC4, "6190")),
        ((Standards.SCIAN2018, "518210"), (Standards.ISIC4, "6311")),
        ((Standards.SCIAN2018, "518210"), (Standards.ISIC4, "7420")),
        ((Standards.SCIAN2018, "519110"), (Standards.ISIC4, "6391")),
        ((Standards.SCIAN2018, "519121"), (Standards.ISIC4, "9101")),
        ((Standards.SCIAN2018, "519122"), (Standards.ISIC4, "9101")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "5811")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "5812")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "5813")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "5819")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "5820")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "5920")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "6010")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "6020")),
        ((Standards.SCIAN2018, "519130"), (Standards.ISIC4, "6312")),
        ((Standards.SCIAN2018, "519190"), (Standards.ISIC4, "6399")),
        ((Standards.SCIAN2018, "519190"), (Standards.ISIC4, "9101")),
        ((Standards.SCIAN2018, "521110"), (Standards.ISIC4, "6411")),
        ((Standards.SCIAN2018, "522110"), (Standards.ISIC4, "6419")),
        ((Standards.SCIAN2018, "522210"), (Standards.ISIC4, "6492")),
        ((Standards.SCIAN2018, "522220"), (Standards.ISIC4, "6430")),
        ((Standards.SCIAN2018, "522310"), (Standards.ISIC4, "6419")),
        ((Standards.SCIAN2018, "522320"), (Standards.ISIC4, "6419")),
        ((Standards.SCIAN2018, "522390"), (Standards.ISIC4, "6419")),
        ((Standards.SCIAN2018, "522440"), (Standards.ISIC4, "6492")),
        ((Standards.SCIAN2018, "522451"), (Standards.ISIC4, "6492")),
        ((Standards.SCIAN2018, "522452"), (Standards.ISIC4, "6492")),
        ((Standards.SCIAN2018, "522460"), (Standards.ISIC4, "6492")),
        ((Standards.SCIAN2018, "522460"), (Standards.ISIC4, "6499")),
        ((Standards.SCIAN2018, "522490"), (Standards.ISIC4, "6492")),
        ((Standards.SCIAN2018, "522510"), (Standards.ISIC4, "6619")),
        ((Standards.SCIAN2018, "523110"), (Standards.ISIC4, "6611")),
        ((Standards.SCIAN2018, "523110"), (Standards.ISIC4, "6499")),
        ((Standards.SCIAN2018, "523121"), (Standards.ISIC4, "6612")),
        ((Standards.SCIAN2018, "523122"), (Standards.ISIC4, "6612")),
        ((Standards.SCIAN2018, "523210"), (Standards.ISIC4, "6611")),
        ((Standards.SCIAN2018, "523910"), (Standards.ISIC4, "6619")),
        ((Standards.SCIAN2018, "523990"), (Standards.ISIC4, "6612")),
        ((Standards.SCIAN2018, "524110"), (Standards.ISIC4, "6511")),
        ((Standards.SCIAN2018, "524110"), (Standards.ISIC4, "6520")),
        ((Standards.SCIAN2018, "524120"), (Standards.ISIC4, "6512")),
        ((Standards.SCIAN2018, "524130"), (Standards.ISIC4, "6512")),
        ((Standards.SCIAN2018, "524210"), (Standards.ISIC4, "6621")),
        ((Standards.SCIAN2018, "524210"), (Standards.ISIC4, "6622")),
        ((Standards.SCIAN2018, "524220"), (Standards.ISIC4, "6530")),
        ((Standards.SCIAN2018, "524220"), (Standards.ISIC4, "6629")),
        ((Standards.SCIAN2018, "524220"), (Standards.ISIC4, "6630")),
        ((Standards.SCIAN2018, "525110"), (Standards.ISIC4, "6629")),
        ((Standards.SCIAN2018, "525210"), (Standards.ISIC4, "6629")),
        ((Standards.SCIAN2018, "531111"), (Standards.ISIC4, "6810")),
        ((Standards.SCIAN2018, "531112"), (Standards.ISIC4, "6810")),
        ((Standards.SCIAN2018, "531113"), (Standards.ISIC4, "6810")),
        ((Standards.SCIAN2018, "531114"), (Standards.ISIC4, "6810")),
        ((Standards.SCIAN2018, "531115"), (Standards.ISIC4, "6810")),
        ((Standards.SCIAN2018, "531116"), (Standards.ISIC4, "6810")),
        ((Standards.SCIAN2018, "531119"), (Standards.ISIC4, "6810")),
        ((Standards.SCIAN2018, "531210"), (Standards.ISIC4, "6820")),
        ((Standards.SCIAN2018, "531311"), (Standards.ISIC4, "6820")),
        ((Standards.SCIAN2018, "531319"), (Standards.ISIC4, "6820")),
        ((Standards.SCIAN2018, "532110"), (Standards.ISIC4, "7710")),
        ((Standards.SCIAN2018, "532121"), (Standards.ISIC4, "6491")),
        ((Standards.SCIAN2018, "532121"), (Standards.ISIC4, "7710")),
        ((Standards.SCIAN2018, "532122"), (Standards.ISIC4, "6491")),
        ((Standards.SCIAN2018, "532122"), (Standards.ISIC4, "7710")),
        ((Standards.SCIAN2018, "532122"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532210"), (Standards.ISIC4, "7729")),
        ((Standards.SCIAN2018, "532281"), (Standards.ISIC4, "7729")),
        ((Standards.SCIAN2018, "532282"), (Standards.ISIC4, "7729")),
        ((Standards.SCIAN2018, "532289"), (Standards.ISIC4, "7721")),
        ((Standards.SCIAN2018, "532289"), (Standards.ISIC4, "7722")),
        ((Standards.SCIAN2018, "532289"), (Standards.ISIC4, "7729")),
        ((Standards.SCIAN2018, "532289"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532310"), (Standards.ISIC4, "7729")),
        ((Standards.SCIAN2018, "532310"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532411"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532412"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532420"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532491"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532492"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "532493"), (Standards.ISIC4, "7730")),
        ((Standards.SCIAN2018, "533110"), (Standards.ISIC4, "7740")),
        ((Standards.SCIAN2018, "541110"), (Standards.ISIC4, "6910")),
        ((Standards.SCIAN2018, "541120"), (Standards.ISIC4, "6910")),
        ((Standards.SCIAN2018, "541190"), (Standards.ISIC4, "6910")),
        ((Standards.SCIAN2018, "541211"), (Standards.ISIC4, "6920")),
        ((Standards.SCIAN2018, "541219"), (Standards.ISIC4, "6920")),
        ((Standards.SCIAN2018, "541310"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "541320"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "541330"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "541340"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "541350"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "541360"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "541370"), (Standards.ISIC4, "7110")),
        ((Standards.SCIAN2018, "541380"), (Standards.ISIC4, "7120")),
        ((Standards.SCIAN2018, "541410"), (Standards.ISIC4, "7410")),
        ((Standards.SCIAN2018, "541420"), (Standards.ISIC4, "7410")),
        ((Standards.SCIAN2018, "541430"), (Standards.ISIC4, "7410")),
        ((Standards.SCIAN2018, "541490"), (Standards.ISIC4, "7410")),
        ((Standards.SCIAN2018, "541510"), (Standards.ISIC4, "6201")),
        ((Standards.SCIAN2018, "541510"), (Standards.ISIC4, "6202")),
        ((Standards.SCIAN2018, "541510"), (Standards.ISIC4, "6209")),
        ((Standards.SCIAN2018, "541610"), (Standards.ISIC4, "6629")),
        ((Standards.SCIAN2018, "541610"), (Standards.ISIC4, "7020")),
        ((Standards.SCIAN2018, "541620"), (Standards.ISIC4, "7490")),
        ((Standards.SCIAN2018, "541690"), (Standards.ISIC4, "0240")),
        ((Standards.SCIAN2018, "541690"), (Standards.ISIC4, "7490")),
        ((Standards.SCIAN2018, "541711"), (Standards.ISIC4, "7210")),
        ((Standards.SCIAN2018, "541712"), (Standards.ISIC4, "7210")),
        ((Standards.SCIAN2018, "541721"), (Standards.ISIC4, "7220")),
        ((Standards.SCIAN2018, "541722"), (Standards.ISIC4, "7220")),
        ((Standards.SCIAN2018, "541810"), (Standards.ISIC4, "7310")),
        ((Standards.SCIAN2018, "541820"), (Standards.ISIC4, "7020")),
        ((Standards.SCIAN2018, "541830"), (Standards.ISIC4, "7310")),
        ((Standards.SCIAN2018, "541840"), (Standards.ISIC4, "7310")),
        ((Standards.SCIAN2018, "541850"), (Standards.ISIC4, "7310")),
        ((Standards.SCIAN2018, "541860"), (Standards.ISIC4, "7310")),
        ((Standards.SCIAN2018, "541870"), (Standards.ISIC4, "7310")),
        ((Standards.SCIAN2018, "541890"), (Standards.ISIC4, "7310")),
        ((Standards.SCIAN2018, "541910"), (Standards.ISIC4, "7320")),
        ((Standards.SCIAN2018, "541920"), (Standards.ISIC4, "7420")),
        ((Standards.SCIAN2018, "541930"), (Standards.ISIC4, "7490")),
        ((Standards.SCIAN2018, "541941"), (Standards.ISIC4, "7500")),
        ((Standards.SCIAN2018, "541942"), (Standards.ISIC4, "7500")),
        ((Standards.SCIAN2018, "541943"), (Standards.ISIC4, "7500")),
        ((Standards.SCIAN2018, "541944"), (Standards.ISIC4, "7500")),
        ((Standards.SCIAN2018, "541990"), (Standards.ISIC4, "7490")),
        ((Standards.SCIAN2018, "541990"), (Standards.ISIC4, "8030")),
        ((Standards.SCIAN2018, "551111"), (Standards.ISIC4, "7010")),
        ((Standards.SCIAN2018, "551112"), (Standards.ISIC4, "6420")),
        ((Standards.SCIAN2018, "561110"), (Standards.ISIC4, "8211")),
        ((Standards.SCIAN2018, "561210"), (Standards.ISIC4, "8110")),
        ((Standards.SCIAN2018, "561310"), (Standards.ISIC4, "7810")),
        ((Standards.SCIAN2018, "561320"), (Standards.ISIC4, "7820")),
        ((Standards.SCIAN2018, "561330"), (Standards.ISIC4, "7830")),
        ((Standards.SCIAN2018, "561410"), (Standards.ISIC4, "8219")),
        ((Standards.SCIAN2018, "561421"), (Standards.ISIC4, "8220")),
        ((Standards.SCIAN2018, "561422"), (Standards.ISIC4, "8220")),
        ((Standards.SCIAN2018, "561431"), (Standards.ISIC4, "8219")),
        ((Standards.SCIAN2018, "561432"), (Standards.ISIC4, "8219")),
        ((Standards.SCIAN2018, "561440"), (Standards.ISIC4, "8291")),
        ((Standards.SCIAN2018, "561450"), (Standards.ISIC4, "8291")),
        ((Standards.SCIAN2018, "561490"), (Standards.ISIC4, "8299")),
        ((Standards.SCIAN2018, "561510"), (Standards.ISIC4, "7911")),
        ((Standards.SCIAN2018, "561520"), (Standards.ISIC4, "7912")),
        ((Standards.SCIAN2018, "561590"), (Standards.ISIC4, "7990")),
        ((Standards.SCIAN2018, "561610"), (Standards.ISIC4, "8010")),
        ((Standards.SCIAN2018, "561610"), (Standards.ISIC4, "8030")),
        ((Standards.SCIAN2018, "561620"), (Standards.ISIC4, "8020")),
        ((Standards.SCIAN2018, "561710"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "561720"), (Standards.ISIC4, "8121")),
        ((Standards.SCIAN2018, "561720"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "561730"), (Standards.ISIC4, "8130")),
        ((Standards.SCIAN2018, "561740"), (Standards.ISIC4, "9601")),
        ((Standards.SCIAN2018, "561790"), (Standards.ISIC4, "4390")),
        ((Standards.SCIAN2018, "561790"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "561910"), (Standards.ISIC4, "8292")),
        ((Standards.SCIAN2018, "561920"), (Standards.ISIC4, "8230")),
        ((Standards.SCIAN2018, "561990"), (Standards.ISIC4, "8299")),
        ((Standards.SCIAN2018, "561990"), (Standards.ISIC4, "8423")),
        ((Standards.SCIAN2018, "562111"), (Standards.ISIC4, "3812")),
        ((Standards.SCIAN2018, "562112"), (Standards.ISIC4, "3812")),
        ((Standards.SCIAN2018, "562121"), (Standards.ISIC4, "3811")),
        ((Standards.SCIAN2018, "562121"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "562122"), (Standards.ISIC4, "3811")),
        ((Standards.SCIAN2018, "562122"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "562211"), (Standards.ISIC4, "3822")),
        ((Standards.SCIAN2018, "562212"), (Standards.ISIC4, "3822")),
        ((Standards.SCIAN2018, "562221"), (Standards.ISIC4, "3821")),
        ((Standards.SCIAN2018, "562222"), (Standards.ISIC4, "3821")),
        ((Standards.SCIAN2018, "562911"), (Standards.ISIC4, "3900")),
        ((Standards.SCIAN2018, "562912"), (Standards.ISIC4, "3900")),
        ((Standards.SCIAN2018, "562921"), (Standards.ISIC4, "3830")),
        ((Standards.SCIAN2018, "562922"), (Standards.ISIC4, "3830")),
        ((Standards.SCIAN2018, "562998"), (Standards.ISIC4, "3700")),
        ((Standards.SCIAN2018, "562999"), (Standards.ISIC4, "3700")),
        ((Standards.SCIAN2018, "611111"), (Standards.ISIC4, "8510")),
        ((Standards.SCIAN2018, "611112"), (Standards.ISIC4, "8510")),
        ((Standards.SCIAN2018, "611121"), (Standards.ISIC4, "8510")),
        ((Standards.SCIAN2018, "611122"), (Standards.ISIC4, "8510")),
        ((Standards.SCIAN2018, "611131"), (Standards.ISIC4, "8521")),
        ((Standards.SCIAN2018, "611132"), (Standards.ISIC4, "8521")),
        ((Standards.SCIAN2018, "611141"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611142"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611151"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611152"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611161"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611162"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611171"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611172"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611181"), (Standards.ISIC4, "8510")),
        ((Standards.SCIAN2018, "611181"), (Standards.ISIC4, "8521")),
        ((Standards.SCIAN2018, "611181"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611182"), (Standards.ISIC4, "8510")),
        ((Standards.SCIAN2018, "611182"), (Standards.ISIC4, "8521")),
        ((Standards.SCIAN2018, "611182"), (Standards.ISIC4, "8522")),
        ((Standards.SCIAN2018, "611211"), (Standards.ISIC4, "8530")),
        ((Standards.SCIAN2018, "611211"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611212"), (Standards.ISIC4, "8530")),
        ((Standards.SCIAN2018, "611212"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611311"), (Standards.ISIC4, "8530")),
        ((Standards.SCIAN2018, "611312"), (Standards.ISIC4, "8530")),
        ((Standards.SCIAN2018, "611411"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611412"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611421"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611422"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611431"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611432"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611511"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611512"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611611"), (Standards.ISIC4, "8542")),
        ((Standards.SCIAN2018, "611612"), (Standards.ISIC4, "8542")),
        ((Standards.SCIAN2018, "611621"), (Standards.ISIC4, "8541")),
        ((Standards.SCIAN2018, "611622"), (Standards.ISIC4, "8541")),
        ((Standards.SCIAN2018, "611631"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611632"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611691"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611698"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611699"), (Standards.ISIC4, "8549")),
        ((Standards.SCIAN2018, "611710"), (Standards.ISIC4, "8550")),
        ((Standards.SCIAN2018, "621111"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621112"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621113"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621114"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621115"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621116"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621211"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621212"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621311"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621312"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621320"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621331"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621332"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621341"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621342"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621391"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621392"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621398"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621399"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621411"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621411"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621412"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621412"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621421"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621421"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621422"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621422"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621491"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621491"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621492"), (Standards.ISIC4, "8620")),
        ((Standards.SCIAN2018, "621492"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621511"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621512"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621610"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621910"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621991"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "621992"), (Standards.ISIC4, "8690")),
        ((Standards.SCIAN2018, "622111"), (Standards.ISIC4, "8610")),
        ((Standards.SCIAN2018, "622112"), (Standards.ISIC4, "8610")),
        ((Standards.SCIAN2018, "622211"), (Standards.ISIC4, "8610")),
        ((Standards.SCIAN2018, "622212"), (Standards.ISIC4, "8610")),
        ((Standards.SCIAN2018, "622311"), (Standards.ISIC4, "8610")),
        ((Standards.SCIAN2018, "622312"), (Standards.ISIC4, "8610")),
        ((Standards.SCIAN2018, "623111"), (Standards.ISIC4, "8710")),
        ((Standards.SCIAN2018, "623112"), (Standards.ISIC4, "8710")),
        ((Standards.SCIAN2018, "623211"), (Standards.ISIC4, "8720")),
        ((Standards.SCIAN2018, "623212"), (Standards.ISIC4, "8720")),
        ((Standards.SCIAN2018, "623221"), (Standards.ISIC4, "8720")),
        ((Standards.SCIAN2018, "623222"), (Standards.ISIC4, "8720")),
        ((Standards.SCIAN2018, "623311"), (Standards.ISIC4, "8730")),
        ((Standards.SCIAN2018, "623312"), (Standards.ISIC4, "8730")),
        ((Standards.SCIAN2018, "623991"), (Standards.ISIC4, "8790")),
        ((Standards.SCIAN2018, "623992"), (Standards.ISIC4, "8790")),
        ((Standards.SCIAN2018, "624111"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624112"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624121"), (Standards.ISIC4, "8810")),
        ((Standards.SCIAN2018, "624122"), (Standards.ISIC4, "8810")),
        ((Standards.SCIAN2018, "624191"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624198"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624199"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624211"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624212"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624221"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624222"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624231"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624232"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624311"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624312"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624411"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "624412"), (Standards.ISIC4, "8890")),
        ((Standards.SCIAN2018, "711111"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711112"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711121"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711122"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711131"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711132"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711191"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711191"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "711192"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711192"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "711211"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "711211"), (Standards.ISIC4, "9319")),
        ((Standards.SCIAN2018, "711212"), (Standards.ISIC4, "9312")),
        ((Standards.SCIAN2018, "711311"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711311"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "711311"), (Standards.ISIC4, "9319")),
        ((Standards.SCIAN2018, "711311"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "711312"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711312"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "711312"), (Standards.ISIC4, "9319")),
        ((Standards.SCIAN2018, "711312"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "711320"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "711320"), (Standards.ISIC4, "9319")),
        ((Standards.SCIAN2018, "711320"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "711410"), (Standards.ISIC4, "7490")),
        ((Standards.SCIAN2018, "711510"), (Standards.ISIC4, "3290")),
        ((Standards.SCIAN2018, "711510"), (Standards.ISIC4, "3319")),
        ((Standards.SCIAN2018, "711510"), (Standards.ISIC4, "7420")),
        ((Standards.SCIAN2018, "711510"), (Standards.ISIC4, "9000")),
        ((Standards.SCIAN2018, "712111"), (Standards.ISIC4, "9102")),
        ((Standards.SCIAN2018, "712112"), (Standards.ISIC4, "9102")),
        ((Standards.SCIAN2018, "712120"), (Standards.ISIC4, "9102")),
        ((Standards.SCIAN2018, "712131"), (Standards.ISIC4, "9103")),
        ((Standards.SCIAN2018, "712132"), (Standards.ISIC4, "9103")),
        ((Standards.SCIAN2018, "712190"), (Standards.ISIC4, "9103")),
        ((Standards.SCIAN2018, "713111"), (Standards.ISIC4, "9321")),
        ((Standards.SCIAN2018, "713112"), (Standards.ISIC4, "9321")),
        ((Standards.SCIAN2018, "713113"), (Standards.ISIC4, "9321")),
        ((Standards.SCIAN2018, "713113"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "713114"), (Standards.ISIC4, "9321")),
        ((Standards.SCIAN2018, "713114"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "713120"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "713210"), (Standards.ISIC4, "9200")),
        ((Standards.SCIAN2018, "713291"), (Standards.ISIC4, "9200")),
        ((Standards.SCIAN2018, "713299"), (Standards.ISIC4, "9200")),
        ((Standards.SCIAN2018, "713910"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "713920"), (Standards.ISIC4, "4922")),
        ((Standards.SCIAN2018, "713920"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "713930"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "713941"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "713942"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "713943"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "713944"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "713950"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "713991"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "713992"), (Standards.ISIC4, "9312")),
        ((Standards.SCIAN2018, "713998"), (Standards.ISIC4, "7990")),
        ((Standards.SCIAN2018, "713998"), (Standards.ISIC4, "9312")),
        ((Standards.SCIAN2018, "713998"), (Standards.ISIC4, "9319")),
        ((Standards.SCIAN2018, "713998"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "713999"), (Standards.ISIC4, "9312")),
        ((Standards.SCIAN2018, "713999"), (Standards.ISIC4, "9319")),
        ((Standards.SCIAN2018, "713999"), (Standards.ISIC4, "9329")),
        ((Standards.SCIAN2018, "721111"), (Standards.ISIC4, "5510")),
        ((Standards.SCIAN2018, "721112"), (Standards.ISIC4, "5510")),
        ((Standards.SCIAN2018, "721113"), (Standards.ISIC4, "5510")),
        ((Standards.SCIAN2018, "721120"), (Standards.ISIC4, "5510")),
        ((Standards.SCIAN2018, "721120"), (Standards.ISIC4, "9200")),
        ((Standards.SCIAN2018, "721190"), (Standards.ISIC4, "5510")),
        ((Standards.SCIAN2018, "721210"), (Standards.ISIC4, "5520")),
        ((Standards.SCIAN2018, "721311"), (Standards.ISIC4, "5590")),
        ((Standards.SCIAN2018, "721312"), (Standards.ISIC4, "5590")),
        ((Standards.SCIAN2018, "722310"), (Standards.ISIC4, "5629")),
        ((Standards.SCIAN2018, "722320"), (Standards.ISIC4, "5621")),
        ((Standards.SCIAN2018, "722330"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722330"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722411"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722412"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722511"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722511"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722512"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722512"), (Standards.ISIC4, "5629")),
        ((Standards.SCIAN2018, "722512"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722513"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722513"), (Standards.ISIC4, "5629")),
        ((Standards.SCIAN2018, "722513"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722514"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722514"), (Standards.ISIC4, "5629")),
        ((Standards.SCIAN2018, "722514"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722515"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722515"), (Standards.ISIC4, "5630")),
        ((Standards.SCIAN2018, "722516"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722517"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722518"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "722519"), (Standards.ISIC4, "5610")),
        ((Standards.SCIAN2018, "811111"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811112"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811113"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811114"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811115"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811116"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811119"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811121"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811122"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811123"), (Standards.ISIC4, "2920")),
        ((Standards.SCIAN2018, "811129"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811191"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811192"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811199"), (Standards.ISIC4, "4520")),
        ((Standards.SCIAN2018, "811199"), (Standards.ISIC4, "7120")),
        ((Standards.SCIAN2018, "811211"), (Standards.ISIC4, "9521")),
        ((Standards.SCIAN2018, "811219"), (Standards.ISIC4, "3312")),
        ((Standards.SCIAN2018, "811219"), (Standards.ISIC4, "3313")),
        ((Standards.SCIAN2018, "811219"), (Standards.ISIC4, "9511")),
        ((Standards.SCIAN2018, "811219"), (Standards.ISIC4, "9512")),
        ((Standards.SCIAN2018, "811311"), (Standards.ISIC4, "3312")),
        ((Standards.SCIAN2018, "811312"), (Standards.ISIC4, "3311")),
        ((Standards.SCIAN2018, "811312"), (Standards.ISIC4, "3312")),
        ((Standards.SCIAN2018, "811312"), (Standards.ISIC4, "3314")),
        ((Standards.SCIAN2018, "811312"), (Standards.ISIC4, "3319")),
        ((Standards.SCIAN2018, "811312"), (Standards.ISIC4, "8129")),
        ((Standards.SCIAN2018, "811313"), (Standards.ISIC4, "3312")),
        ((Standards.SCIAN2018, "811314"), (Standards.ISIC4, "3312")),
        ((Standards.SCIAN2018, "811314"), (Standards.ISIC4, "3313")),
        ((Standards.SCIAN2018, "811314"), (Standards.ISIC4, "3315")),
        ((Standards.SCIAN2018, "811314"), (Standards.ISIC4, "3319")),
        ((Standards.SCIAN2018, "811410"), (Standards.ISIC4, "3312")),
        ((Standards.SCIAN2018, "811410"), (Standards.ISIC4, "9522")),
        ((Standards.SCIAN2018, "811420"), (Standards.ISIC4, "9524")),
        ((Standards.SCIAN2018, "811430"), (Standards.ISIC4, "9523")),
        ((Standards.SCIAN2018, "811491"), (Standards.ISIC4, "9529")),
        ((Standards.SCIAN2018, "811492"), (Standards.ISIC4, "4540")),
        ((Standards.SCIAN2018, "811493"), (Standards.ISIC4, "3315")),
        ((Standards.SCIAN2018, "811499"), (Standards.ISIC4, "3311")),
        ((Standards.SCIAN2018, "811499"), (Standards.ISIC4, "3315")),
        ((Standards.SCIAN2018, "811499"), (Standards.ISIC4, "9522")),
        ((Standards.SCIAN2018, "811499"), (Standards.ISIC4, "9529")),
        ((Standards.SCIAN2018, "812110"), (Standards.ISIC4, "9602")),
        ((Standards.SCIAN2018, "812120"), (Standards.ISIC4, "9609")),
        ((Standards.SCIAN2018, "812130"), (Standards.ISIC4, "9609")),
        ((Standards.SCIAN2018, "812210"), (Standards.ISIC4, "9601")),
        ((Standards.SCIAN2018, "812310"), (Standards.ISIC4, "9603")),
        ((Standards.SCIAN2018, "812321"), (Standards.ISIC4, "9603")),
        ((Standards.SCIAN2018, "812322"), (Standards.ISIC4, "9603")),
        ((Standards.SCIAN2018, "812410"), (Standards.ISIC4, "9609")),
        ((Standards.SCIAN2018, "812910"), (Standards.ISIC4, "7420")),
        ((Standards.SCIAN2018, "812990"), (Standards.ISIC4, "9609")),
        ((Standards.SCIAN2018, "813110"), (Standards.ISIC4, "9411")),
        ((Standards.SCIAN2018, "813120"), (Standards.ISIC4, "9420")),
        ((Standards.SCIAN2018, "813130"), (Standards.ISIC4, "9412")),
        ((Standards.SCIAN2018, "813140"), (Standards.ISIC4, "9311")),
        ((Standards.SCIAN2018, "813210"), (Standards.ISIC4, "9491")),
        ((Standards.SCIAN2018, "813220"), (Standards.ISIC4, "9492")),
        ((Standards.SCIAN2018, "813230"), (Standards.ISIC4, "9499")),
        ((Standards.SCIAN2018, "814110"), (Standards.ISIC4, "9700")),
        ((Standards.SCIAN2018, "931110"), (Standards.ISIC4, "8411")),
        ((Standards.SCIAN2018, "931210"), (Standards.ISIC4, "8411")),
        ((Standards.SCIAN2018, "931310"), (Standards.ISIC4, "8413")),
        ((Standards.SCIAN2018, "931410"), (Standards.ISIC4, "8423")),
        ((Standards.SCIAN2018, "931510"), (Standards.ISIC4, "8412")),
        ((Standards.SCIAN2018, "931610"), (Standards.ISIC4, "8412")),
        ((Standards.SCIAN2018, "931610"), (Standards.ISIC4, "8430")),
        ((Standards.SCIAN2018, "931710"), (Standards.ISIC4, "8421")),
        ((Standards.SCIAN2018, "931810"), (Standards.ISIC4, "8422")),
        ((Standards.SCIAN2018, "932110"), (Standards.ISIC4, "9900")),
        ((Standards.SCIAN2018, "932120"), (Standards.ISIC4, "9900")),
    ],
)
