"""`CCNAE2021 Standard <http://www.onei.gob.cu/node/14808>`_."""

from ...types import Category, Classification, Standard, Standards

CCNAE2021 = Standard(
    standard=Standards.CCNAE2021,
    classes=[
        Classification("A", "AGRICULTURA, GANADERÍA, SILVICULTURA Y PESCA", Category.SECTION),
        Classification("01", "AGRICULTURA, GANADERÍA, CAZA Y ACTIVIDADES DE SERVICIOS CONEXAS", Category.DIVISION),
        Classification("011", "CULTIVO DE PLANTAS NO PERENNES", Category.GROUP),
        Classification("0111", "CULTIVO DE CEREALES (EXCEPTO ARROZ), LEGUMBRES Y SEMILLAS OLEAGINOSAS", Category.CLASS),
        Classification("0112", "CULTIVO DE ARROZ", Category.CLASS),
        Classification("0113", "CULTIVO DE HORTALIZAS Y MELONES, RAÍCES Y TUBÉRCULOS", Category.CLASS),
        Classification("0114", "CULTIVO DE CAÑA DE AZÚCAR", Category.CLASS),
        Classification("0115", "CULTIVO DE TABACO", Category.CLASS),
        Classification("0116", "CULTIVO DE PLANTAS DE FIBRA", Category.CLASS),
        Classification("0119", "CULTIVO DE OTRAS PLANTAS NO PERENNES", Category.CLASS),
        Classification("012", "CULTIVO DE PLANTAS PERENNES", Category.GROUP),
        Classification("0121", "CULTIVO DE UVA", Category.CLASS),
        Classification("0122", "CULTIVO DE FRUTAS TROPICALES Y SUBTROPICALES", Category.CLASS),
        Classification("0123", "CULTIVO DE CÍTRICOS", Category.CLASS),
        Classification("0124", "CULTIVO DE FRUTAS DE PEPITA Y DE HUESO", Category.CLASS),
        Classification("0125", "CULTIVO DE OTROS FRUTOS Y NUECES DE ÁRBOLES Y ARBUSTOS", Category.CLASS),
        Classification("0126", "CULTIVO DE FRUTOS OLEAGINOSOS", Category.CLASS),
        Classification("0127", "CULTIVO DE PLANTAS CON LAS QUE SE PREPARAN BEBIDAS", Category.CLASS),
        Classification(
            "0128", "CULTIVO DE ESPECIAS Y DE PLANTAS AROMÁTICAS, MEDICINALES Y FARMACÉUTICAS", Category.CLASS
        ),
        Classification("0129", "CULTIVO DE OTRAS PLANTAS PERENNES", Category.CLASS),
        Classification("013", "PROPAGACIÓN DE PLANTAS", Category.GROUP),
        Classification("0130", "PROPAGACIÓN DE PLANTAS ", Category.CLASS),
        Classification("014", "GANADERÍA", Category.GROUP),
        Classification("0141", "CRÍA DE GANADO BOVINO Y BÚFALINO", Category.CLASS),
        Classification("0142", "CRÍA DE CABALLOS Y OTROS EQUINOS", Category.CLASS),
        Classification("0144", "CRÍA DE OVEJAS Y CABRAS", Category.CLASS),
        Classification("0145", "CRÍA DE GANADO PORCINO", Category.CLASS),
        Classification("0146", "CRÍA DE AVES DE CORRAL", Category.CLASS),
        Classification("0149", "CRÍA DE OTROS ANIMALES", Category.CLASS),
        Classification(
            "015",
            "CULTIVO DE PRODUCTOS AGRÍCOLAS EN COMBINACIÓN CON LA CRÍA DE ANIMALES (EXPLOTACIÓN MIXTA)",
            Category.GROUP,
        ),
        Classification(
            "0150",
            "CULTIVO DE PRODUCTOS AGRÍCOLAS EN COMBINACIÓN CON LA CRÍA DE ANIMALES (EXPLOTACIÓN MIXTA)",
            Category.CLASS,
        ),
        Classification(
            "016", "ACTIVIDADES DE APOYO A LA AGRICULTURA Y LA GANADERÍA Y ACTIVIDADES POSCOSECHA", Category.GROUP
        ),
        Classification("0161", "ACTIVIDADES DE APOYO A LA AGRICULTURA", Category.CLASS),
        Classification("0162", "ACTIVIDADES DE APOYO A LA GANADERÍA", Category.CLASS),
        Classification("0163", "ACTIVIDADES POSCOSECHA", Category.CLASS),
        Classification("0164", "TRATAMIENTO DE SEMILLAS PARA PROPAGACIÓN", Category.CLASS),
        Classification("017", "CAZA ORDINARIA Y MEDIANTE TRAMPAS Y ACTIVIDADES DE SERVICIOS CONEXAS", Category.GROUP),
        Classification("0170", "CAZA ORDINARIA Y MEDIANTE TRAMPAS Y ACTIVIDADES DE SERVICIOS CONEXAS", Category.CLASS),
        Classification("02", "SILVICULTURA Y EXTRACCIÓN DE MADERA", Category.DIVISION),
        Classification("021", "SILVICULTURA Y OTRAS ACTIVIDADES FORESTALES", Category.GROUP),
        Classification("0210", "SILVICULTURA Y OTRAS ACTIVIDADES FORESTALES", Category.CLASS),
        Classification("022", "EXTRACCIÓN DE MADERA", Category.GROUP),
        Classification("0220", "EXTRACCIÓN DE MADERA", Category.CLASS),
        Classification("023", "RECOLECCIÓN DE PRODUCTOS FORESTALES DISTINTOS DE LA MADERA", Category.GROUP),
        Classification("0230", "RECOLECCIÓN DE PRODUCTOS FORESTALES DISTINTOS DE LA MADERA", Category.CLASS),
        Classification("024", "SERVICIOS DE APOYO A LA SILVICULTURA", Category.GROUP),
        Classification("0240", "SERVICIOS DE APOYO A LA SILVICULTURA", Category.CLASS),
        Classification("03", "PESCA Y ACUICULTURA", Category.DIVISION),
        Classification("031", "PESCA", Category.GROUP),
        Classification("0311", "PESCA MARINA", Category.CLASS),
        Classification("0312", "PESCA DE AGUA DULCE", Category.CLASS),
        Classification("032", "ACUICULTURA", Category.GROUP),
        Classification("0321", "ACUICULTURA MARINA", Category.CLASS),
        Classification("0322", "ACUICULTURA DE AGUA DULCE", Category.CLASS),
        Classification("B", "EXPLOTACIÓN DE MINAS Y CANTERAS", Category.SECTION),
        Classification("05", "EXTRACCIÓN DE CARBÓN DE PIEDRA Y LIGNITO", Category.DIVISION),
        Classification("051", "EXTRACCIÓN DE CARBÓN DE PIEDRA", Category.GROUP),
        Classification("0510", "EXTRACCIÓN DE CARBÓN DE PIEDRA", Category.CLASS),
        Classification("052", "EXTRACCIÓN DE LIGNITO", Category.GROUP),
        Classification("0520", "EXTRACCIÓN DE LIGNITO", Category.CLASS),
        Classification("06", "EXTRACCIÓN DE PETRÓLEO CRUDO Y GAS NATURAL", Category.DIVISION),
        Classification("061", "EXTRACCIÓN DE PETRÓLEO CRUDO", Category.GROUP),
        Classification("0610", "EXTRACCIÓN DE PETRÓLEO CRUDO", Category.CLASS),
        Classification("062", "EXTRACCIÓN DE GAS NATURAL", Category.GROUP),
        Classification("0620", "EXTRACCIÓN DE GAS NATURAL", Category.CLASS),
        Classification("07", "EXTRACCIÓN DE MINERALES METALÍFEROS", Category.DIVISION),
        Classification("071", "EXTRACCIÓN DE MINERALES DE HIERRO", Category.GROUP),
        Classification("0710", "EXTRACCIÓN DE MINERALES DE HIERRO", Category.CLASS),
        Classification("072", "EXTRACCIÓN DE MINERALES METALÍFEROS NO FERROSOS", Category.GROUP),
        Classification("0721", "EXTRACCIÓN DE MINERALES DE URANIO Y TORIO", Category.CLASS),
        Classification("0722", "EXTRACCIÓN Y BENEFICIO DEL MINERAL NÍQUEL", Category.CLASS),
        Classification("0729", "EXTRACCIÓN DE OTROS MINERALES METALÍFEROS NO FERROSOS", Category.CLASS),
        Classification("08", "EXPLOTACIÓN DE OTRAS MINAS Y CANTERAS", Category.DIVISION),
        Classification("081", "EXTRACCIÓN DE PIEDRA ARENA Y ARCILLA", Category.GROUP),
        Classification("0810", "EXTRACCIÓN DE PIEDRA ARENA Y ARCILLA", Category.CLASS),
        Classification("089", "EXPLOTACIÓN DE MINAS Y CANTERAS N.C.P.", Category.GROUP),
        Classification(
            "0891", "EXTRACCIÓN DE MINERALES PARA LA FABRICACIÓN DE ABONOS Y PRODUCTOS QUÍMICOS", Category.CLASS
        ),
        Classification("0892", "EXTRACCIÓN DE TURBA", Category.CLASS),
        Classification("0893", "EXTRACCIÓN DE SAL", Category.CLASS),
        Classification("0899", "EXPLOTACIÓN DE OTRAS MINAS Y CANTERAS N.C.P.", Category.CLASS),
        Classification(
            "09", "ACTIVIDADES DE SERVICIOS DE APOYO PARA LA EXPLOTACIÓN DE MINAS Y CANTERAS", Category.DIVISION
        ),
        Classification("091", "ACTIVIDADES DE APOYO PARA LA EXTRACCIÓN DE PETRÓLEO Y GAS NATURAL", Category.GROUP),
        Classification("0910", "ACTIVIDADES DE APOYO PARA LA EXTRACCIÓN DE PETRÓLEO Y GAS NATURAL", Category.CLASS),
        Classification(
            "099", "ACTIVIDADES DE APOYO PARA OTRAS ACTIVIDADES DE EXPLOTACIÓN DE MINAS Y CANTERAS", Category.GROUP
        ),
        Classification(
            "0990", "ACTIVIDADES DE APOYO PARA OTRAS ACTIVIDADES DE EXPLOTACIÓN DE MINAS Y CANTERAS", Category.CLASS
        ),
        Classification("C", "INDUSTRIAS MANUFACTURERAS", Category.SECTION),
        Classification("10", "ELABORACIÓN DE PRODUCTOS ALIMENTICIOS", Category.DIVISION),
        Classification("101", "ELABORACIÓN Y CONSERVACIÓN DE CARNE", Category.GROUP),
        Classification("1010", "ELABORACIÓN Y CONSERVACIÓN DE CARNE", Category.CLASS),
        Classification("102", "ELABORACIÓN Y CONSERVACIÓN DE PESCADO, CRUSTÁCEOS Y MOLUSCOS", Category.GROUP),
        Classification("1020", "ELABORACIÓN Y CONSERVACIÓN DE PESCADO, CRUSTÁCEOS Y MOLUSCOS", Category.CLASS),
        Classification("103", "ELABORACIÓN Y CONSERVACIÓN DE FRUTAS LEGUMBRES Y HORTALIZAS", Category.GROUP),
        Classification("1030", "ELABORACIÓN Y CONSERVACIÓN DE FRUTAS LEGUMBRES Y HORTALIZAS", Category.CLASS),
        Classification("104", "ELABORACIÓN DE ACEITES Y GRASAS DE ORIGEN VEGETAL Y ANIMAL", Category.GROUP),
        Classification("1040", "ELABORACIÓN DE ACEITES Y GRASAS DE ORIGEN VEGETAL Y ANIMAL", Category.CLASS),
        Classification("105", "ELABORACIÓN DE PRODUCTOS LÁCTEOS", Category.GROUP),
        Classification("1050", "ELABORACIÓN DE PRODUCTOS LÁCTEOS", Category.CLASS),
        Classification(
            "106", "ELABORACIÓN DE PRODUCTOS DE MOLINERÍA, ALMIDONES Y PRODUCTOS DERIVADOS DEL ALMIDÓN", Category.GROUP
        ),
        Classification("1061", "ELABORACIÓN DE PRODUCTOS DE MOLINERÍA", Category.CLASS),
        Classification("1062", "ELABORACIÓN DE ALMIDONES Y PRODUCTOS DERIVADOS DEL ALMIDÓN", Category.CLASS),
        Classification("107", "ELABORACIÓN DE OTROS PRODUCTOS ALIMENTICIOS", Category.GROUP),
        Classification("1071", "ELABORACIÓN DE PRODUCTOS DE PANADERÍA", Category.CLASS),
        Classification("1072", "ELABORACIÓN DE AZÚCAR", Category.CLASS),
        Classification("1073", "ELABORACIÓN DE CACAO Y CHOCOLATE Y DE PRODUCTOS DE CONFITERÍA", Category.CLASS),
        Classification(
            "1074", "ELABORACIÓN DE MACARRONES, FIDEOS, ALCUZCUZ Y PRODUCTOS FARINÁCEOS SIMILARES", Category.CLASS
        ),
        Classification("1075", "ELABORACIÓN DE COMIDAS Y PLATOS PREPARADOS", Category.CLASS),
        Classification("1079", "ELABORACIÓN DE OTROS PRODUCTOS ALIMENTICIOS N.C.P.", Category.CLASS),
        Classification("108", "ELABORACIÓN DE PIENSOS PREPARADOS PARA ANIMALES", Category.GROUP),
        Classification("1080", "ELABORACIÓN DE PIENSOS PREPARADOS PARA ANIMALES", Category.CLASS),
        Classification("11", "ELABORACIÓN DE BEBIDAS", Category.DIVISION),
        Classification("110", "ELABORACIÓN DE BEBIDAS", Category.GROUP),
        Classification("1101", "DESTILACIÓN, RECTIFICACIÓN Y MEZCLA DE BEBIDAS ALCOHÓLICAS", Category.CLASS),
        Classification("1102", "ELABORACIÓN DE VINOS", Category.CLASS),
        Classification("1103", "ELABORACIÓN DE BEBIDAS MALTEADAS Y DE MALTA", Category.CLASS),
        Classification(
            "1104",
            "ELABORACIÓN DE BEBIDAS NO ALCOHÓLICAS; PRODUCCIÓN DE AGUAS MINERALES Y OTRAS AGUAS EMBOTELLADAS",
            Category.CLASS,
        ),
        Classification("12", "ELABORACIÓN DE PRODUCTOS DE TABACO", Category.DIVISION),
        Classification("120", "ELABORACIÓN DE PRODUCTOS DE TABACO", Category.GROUP),
        Classification("1200", "ELABORACIÓN DE PRODUCTOS DE TABACO", Category.CLASS),
        Classification("13", "FABRICACIÓN DE PRODUCTOS TEXTILES", Category.DIVISION),
        Classification("131", "HILATURA, TEJEDURA Y ACABADO DE PRODUCTOS TEXTILES", Category.GROUP),
        Classification("1311", "PREPARACIÓN E HILATURA DE FIBRAS TEXTILES", Category.CLASS),
        Classification("1312", "TEJEDURA DE PRODUCTOS TEXTILES", Category.CLASS),
        Classification("1313", "ACABADO DE PRODUCTOS TEXTILES", Category.CLASS),
        Classification("139", "FABRICACIÓN DE OTROS PRODUCTOS TEXTILES", Category.GROUP),
        Classification("1391", "FABRICACIÓN DE TEJIDOS DE PUNTO Y GANCHILLO", Category.CLASS),
        Classification(
            "1392",
            "FABRICACIÓN DE ARTÍCULOS CONFECCIONADOS DE MATERIALES TEXTILES, EXCEPTO PRENDAS DE VESTIR",
            Category.CLASS,
        ),
        Classification("1393", "FABRICACIÓN DE TAPICES Y ALFOMBRAS", Category.CLASS),
        Classification("1394", "FABRICACIÓN DE CUERDAS, CORDELES, BRAMANTES Y REDES", Category.CLASS),
        Classification("1399", "FABRICACIÓN DE OTROS PRODUCTOS TEXTILES N.C.P.", Category.CLASS),
        Classification("14", "FABRICACIÓN DE PRENDAS DE VESTIR", Category.DIVISION),
        Classification("141", "FABRICACIÓN DE PRENDAS DE VESTIR, EXCEPTO PRENDAS DE PIEL", Category.GROUP),
        Classification("1410", "FABRICACIÓN DE PRENDAS DE VESTIR, EXCEPTO PRENDAS DE PIEL", Category.CLASS),
        Classification("142", "FABRICACIÓN DE ARTÍCULOS DE PIEL", Category.GROUP),
        Classification("1420", "FABRICACIÓN DE ARTÍCULOS DE PIEL", Category.CLASS),
        Classification("143", "FABRICACIÓN DE ARTÍCULOS DE PUNTO Y GANCHILLO", Category.GROUP),
        Classification("1430", "FABRICACIÓN DE ARTÍCULOS DE PUNTO Y GANCHILLO", Category.CLASS),
        Classification("15", "FABRICACIÓN DE PRODUCTOS DE CUERO Y PRODUCTOS CONEXOS", Category.DIVISION),
        Classification(
            "151",
            "CURTIDO Y ADOBO DE CUEROS; FABRICACIÓN DE MALETASBOLSOS DE MANO Y ARTÍCULOS DE TALABARTERÍA Y GUARNICIONERÍA; ADOBO Y TEÑIDO DE PIELES",
            Category.GROUP,
        ),
        Classification("1511", "CURTIDO Y ADOBO DE CUEROS; ADOBO Y TEÑIDO DE PIELES", Category.CLASS),
        Classification(
            "1512",
            "FABRICACIÓN DE MALETAS, BOLSOS DE MANO Y ARTÍCULOS SIMILARES, Y DE ARTÍCULOS DE TALABARTERÍA Y GUARNICIONERÍA",
            Category.CLASS,
        ),
        Classification("152", "FABRICACIÓN DE CALZADO", Category.GROUP),
        Classification("1520", "FABRICACIÓN DE CALZADO", Category.CLASS),
        Classification(
            "16",
            "PRODUCCIÓN DE MADERA Y FABRICACIÓN DE PRODUCTOS DE MADERA Y CORCHO, EXCEPTO MUEBLES; FABRICACIÓN DE ARTÍCULOS DE PAJA Y DE MATERIALES TRENZABLES",
            Category.DIVISION,
        ),
        Classification("161", "ASERRADO Y ACEPILLADURA DE MADERA", Category.GROUP),
        Classification("1610", "ASERRADO Y ACEPILLADURA DE MADERA", Category.CLASS),
        Classification(
            "162", "FABRICACIÓN DE PRODUCTOS DE MADERA, CORCHO, PAJA Y MATERIALES TRENZABLES", Category.GROUP
        ),
        Classification(
            "1621", "FABRICACIÓN DE HOJAS DE MADERA PARA ENCHAPADO Y TABLEROS A BASE DE MADERA", Category.CLASS
        ),
        Classification(
            "1622", "FABRICACIÓN DE PARTES Y PIEZAS DE CARPINTERÍA PARA EDIFICIOS Y CONSTRUCCIONES", Category.CLASS
        ),
        Classification("1623", "FABRICACIÓN DE RECIPIENTES DE MADERA", Category.CLASS),
        Classification(
            "1629",
            "FABRICACIÓN DE OTROS PRODUCTOS DE MADERA; FABRICACIÓN DE ARTÍCULOS DE CORCHOPAJA Y MATERIALES TRENZABLES",
            Category.CLASS,
        ),
        Classification("17", "FABRICACIÓN DE PAPEL Y DE PRODUCTOS DE PAPEL", Category.DIVISION),
        Classification("170", "FABRICACIÓN DE PAPEL Y DE PRODUCTOS DE PAPEL", Category.GROUP),
        Classification("1701", "FABRICACIÓN DE PASTA DE MADERA, PAPEL Y CARTÓN", Category.CLASS),
        Classification("1702", "FABRICACIÓN DE PAPEL Y CARTÓN ONDULADO Y DE ENVASES DE PAPEL Y CARTÓN", Category.CLASS),
        Classification("1709", "FABRICACIÓN DE OTROS ARTÍCULOS DE PAPEL Y CARTÓN", Category.CLASS),
        Classification("18", "IMPRESIÓN Y REPRODUCCIÓN DE GRABACIONES", Category.DIVISION),
        Classification("181", "IMPRESIÓN", Category.GROUP),
        Classification("1811", "IMPRESIÓN", Category.CLASS),
        Classification("1812", "ACTIVIDADES DE SERVICIOS RELACIONADAS CON LA IMPRESIÓN", Category.CLASS),
        Classification("182", "REPRODUCCIÓN DE GRABACIONES", Category.GROUP),
        Classification("1820", "REPRODUCCIÓN DE GRABACIONES", Category.CLASS),
        Classification("19", "FABRICACIÓN DE COQUE Y PRODUCTOS DE LA REFINACIÓN DEL PETRÓLEO", Category.DIVISION),
        Classification("191", "FABRICACIÓN  DE PRODUCTOS DE HORNOS DE COQUE", Category.GROUP),
        Classification("1910", "FABRICACIÓN  DE PRODUCTOS DE HORNOS DE COQUE", Category.CLASS),
        Classification("192", "FABRICACIÓN  DE PRODUCTOS DE LA REFINACIÓN DEL PETRÓLEO", Category.GROUP),
        Classification("1920", "FABRICACIÓN  DE PRODUCTOS DE LA REFINACIÓN DEL PETRÓLEO", Category.CLASS),
        Classification("20", "FABRICACIÓN DE SUSTANCIAS Y PRODUCTOS QUÍMICOS", Category.DIVISION),
        Classification(
            "201",
            "FABRICACIÓN  DE SUSTANCIAS QUÍMICAS BÁSICAS DE ABONOS Y COMPUESTOS DE NITRÓGENO Y DE PLÁSTICOS Y CAUCHO SINTÉTICO EN FORMAS PRIMARIAS",
            Category.GROUP,
        ),
        Classification("2011", "FABRICACIÓN  DE SUSTANCIAS QUÍMICAS BÁSICAS", Category.CLASS),
        Classification("2012", "FABRICACIÓN  DE ABONOS Y COMPUESTOS DE NITRÓGENO", Category.CLASS),
        Classification("2013", "FABRICACIÓN  DE PLÁSTICOS Y CAUCHO SINTÉTICO EN FORMAS PRIMARIAS", Category.CLASS),
        Classification("202", "FABRICACIÓN DE OTROS PRODUCTOS QUÍMICOS", Category.GROUP),
        Classification(
            "2021", "FABRICACIÓN  DE PLAGUICIDAS Y OTROS PRODUCTOS QUÍMICOS DE USO AGROPECUARIO", Category.CLASS
        ),
        Classification(
            "2022",
            "FABRICACIÓN  DE PINTURAS, BARNICES Y PRODUCTOS DE REVESTIMIENTO SIMILARES, TINTAS DE IMPRENTA Y MASILLAS",
            Category.CLASS,
        ),
        Classification(
            "2023",
            "FABRICACIÓN  DE JABONES Y DETERGENTES; PREPARADOS PARA LIMPIAR Y PULIR; PERFUMES Y PREPARADOS DE TOCADOR",
            Category.CLASS,
        ),
        Classification("2029", "FABRICACIÓN  DE OTROS PRODUCTOS QUÍMICOS N.C.P.", Category.CLASS),
        Classification("203", "FABRICACIÓN  DE FIBRAS ARTIFICIALES", Category.GROUP),
        Classification("2030", "FABRICACIÓN  DE FIBRAS ARTIFICIALES", Category.CLASS),
        Classification(
            "21",
            "FABRICACIÓN  DE PRODUCTOS FARMACÉUTICOS, SUSTANCIAS QUÍMICAS MEDICINALES Y PRODUCTOS BOTÁNICOS DE USO FARMACÉUTICO",
            Category.DIVISION,
        ),
        Classification(
            "210",
            "FABRICACIÓN  DE PRODUCTOS FARMACÉUTICOS, SUSTANCIAS QUÍMICAS MEDICINALES Y PRODUCTOS BOTÁNICOS DE USO FARMACÉUTICO",
            Category.GROUP,
        ),
        Classification(
            "2100",
            "FABRICACIÓN  DE PRODUCTOS FARMACÉUTICOS, SUSTANCIAS QUÍMICAS MEDICINALES Y PRODUCTOS BOTÁNICOS DE USO FARMACÉUTICO",
            Category.CLASS,
        ),
        Classification("22", "FABRICACIÓN  DE PRODUCTOS DE CAUCHO Y DE PLÁSTICO", Category.DIVISION),
        Classification("221", "FABRICACIÓN  DE PRODUCTOS DE CAUCHO", Category.GROUP),
        Classification(
            "2211",
            "FABRICACIÓN  DE CUBIERTAS Y CÁMARAS DE CAUCHO; RECAUCHUTADO Y RENOVACIÓN DE CUBIERTAS DE CAUCHO",
            Category.CLASS,
        ),
        Classification("2219", "FABRICACIÓN  DE OTROS PRODUCTOS DE CAUCHO", Category.CLASS),
        Classification("222", "FABRICACIÓN  DE PRODUCTOS DE PLÁSTICO", Category.GROUP),
        Classification("2220", "FABRICACIÓN  DE PRODUCTOS DE PLÁSTICO", Category.CLASS),
        Classification("23", "FABRICACIÓN  DE OTROS PRODUCTOS MINERALES NO METÁLICOS", Category.DIVISION),
        Classification("231", "FABRICACIÓN  DE VIDRIO Y PRODUCTOS DE VIDRIO", Category.GROUP),
        Classification("2310", "FABRICACIÓN DE VIDRIO Y PRODUCTOS DE VIDRIO", Category.CLASS),
        Classification("239", "FABRICACIÓN DE PRODUCTOS MINERALES NO METÁLICOS N.C.P.", Category.GROUP),
        Classification("2391", "FABRICACIÓN  DE PRODUCTOS REFRACTARIOS", Category.CLASS),
        Classification("2392", "FABRICACIÓN  DE MATERIALES DE CONSTRUCCIÓN DE ARCILLA", Category.CLASS),
        Classification("2393", "FABRICACIÓN DE OTROS PRODUCTOS DE PORCELANA Y DE CERÁMICA", Category.CLASS),
        Classification("2394", "FABRICACIÓN DE CEMENTO, CAL Y YESO", Category.CLASS),
        Classification("2395", "FABRICACIÓN DE ARTÍCULOS DE HORMIGÓN, CEMENTO Y YESO", Category.CLASS),
        Classification("2396", "CORTE, TALLA Y ACABADO DE LA PIEDRA", Category.CLASS),
        Classification("2399", "FABRICACIÓN DE OTROS PRODUCTOS MINERALES NO METÁLICOS N.C.P.", Category.CLASS),
        Classification("24", "FABRICACIÓN DE METALES COMUNES", Category.DIVISION),
        Classification("241", "INDUSTRIAS BÁSICAS DE HIERRO Y ACERO", Category.GROUP),
        Classification("2410", "INDUSTRIAS BÁSICAS DE HIERRO Y ACERO", Category.CLASS),
        Classification(
            "242", "FABRICACIÓN DE PRODUCTOS PRIMARIOS DE METALES PRECIOSOS Y OTROS METALES NO FERROSOS", Category.GROUP
        ),
        Classification(
            "2420",
            "FABRICACIÓN DE PRODUCTOS PRIMARIOS DE METALES PRECIOSOS Y OTROS METALES NO FERROSOS",
            Category.CLASS,
        ),
        Classification("2421", "FABRICACIÓN DE PRODUCTOS PRIMARIOS DEL NÍQUEL", Category.CLASS),
        Classification("243", "FUNDICIÓN DE METALES", Category.GROUP),
        Classification("2431", "FUNDICIÓN DE HIERRO Y ACERO", Category.CLASS),
        Classification("2432", "FUNDICIÓN DE METALES NO FERROSOS", Category.CLASS),
        Classification(
            "25", "FABRICACIÓN DE PRODUCTOS ELABORADOS DE METAL, EXCEPTO MAQUINARIA Y EQUIPO", Category.DIVISION
        ),
        Classification(
            "251",
            "FABRICACIÓN DE PRODUCTOS METÁLICOS PARA USO ESTRUCTURALTANQUESDEPÓSITOS Y RECIPIENTES DE METAL",
            Category.GROUP,
        ),
        Classification("2511", "FABRICACIÓN DE PRODUCTOS METÁLICOS PARA USO ESTRUCTURAL", Category.CLASS),
        Classification("2512", "FABRICACIÓN DE TANQUES, DEPÓSITOS Y RECIPIENTES DE METAL", Category.CLASS),
        Classification(
            "2513",
            "FABRICACIÓN DE GENERADORES DE VAPOR, EXCEPTO CALDERAS DE AGUA CALIENTE PARA CALEFACCIÓN CENTRAL",
            Category.CLASS,
        ),
        Classification("252", "FABRICACIÓN DE ARMAS Y MUNICIONES", Category.GROUP),
        Classification("2520", "FABRICACIÓN DE ARMAS Y MUNICIONES", Category.CLASS),
        Classification(
            "259",
            "FABRICACIÓN DE OTROS PRODUCTOS ELABORADOS DE METAL; ACTIVIDADES DE SERVICIOS DE TRABAJO DE METALES",
            Category.GROUP,
        ),
        Classification("2591", "FORJA, PRENSADO, ESTAMPADO Y LAMINADO DE METALES; PULVIMETALURGIA", Category.CLASS),
        Classification("2592", "TRATAMIENTO Y REVESTIMIENTO DE METALES; MAQUINADO", Category.CLASS),
        Classification(
            "2593",
            "FABRICACIÓN DE ARTÍCULOS DE CUCHILLERÍA, HERRAMIENTAS DE MANO Y ARTÍCULOS DE FERRETERÍA",
            Category.CLASS,
        ),
        Classification("2599", "FABRICACIÓN DE OTROS PRODUCTOS ELABORADOS DE METAL N.C.P.", Category.CLASS),
        Classification("26", "FABRICACIÓN DE PRODUCTOS DE INFORMÁTICA, DE ELECTRÓNICA Y DE ÓPTICA", Category.DIVISION),
        Classification("261", "FABRICACIÓN DE COMPONENTES Y TABLEROS ELECTRÓNICOS", Category.GROUP),
        Classification("2610", "FABRICACIÓN DE COMPONENTES Y TABLEROS ELECTRÓNICOS", Category.CLASS),
        Classification("262", "FABRICACIÓN DE ORDENADORES Y EQUIPO PERIFÉRICO", Category.GROUP),
        Classification("2620", "FABRICACIÓNDE ORDENADORES Y EQUIPO PERIFÉRICO", Category.CLASS),
        Classification("263", "FABRICACIÓN DE EQUIPO DE COMUNICACIONES", Category.GROUP),
        Classification("2630", "FABRICACIÓN DE EQUIPO DE COMUNICACIONES", Category.CLASS),
        Classification("264", "FABRICACIÓN DE APARATOS ELECTRÓNICOS DE CONSUMO", Category.GROUP),
        Classification("2640", "FABRICACIÓN DE APARATOS ELECTRÓNICOS DE CONSUMO", Category.CLASS),
        Classification(
            "265", "FABRICACIÓN DE EQUIPO DE MEDICIÓN, PRUEBA, NAVEGACIÓN Y CONTROL Y DE RELOJES", Category.GROUP
        ),
        Classification("2651", "FABRICACIÓN DE EQUIPO DE MEDICIÓN, PRUEBA, NAVEGACIÓN Y CONTROL", Category.CLASS),
        Classification("2652", "FABRICACIÓN DE RELOJES", Category.CLASS),
        Classification(
            "266",
            "FABRICACIÓN DE EQUIPO DE IRRADIACIÓN Y EQUIPO ELECTRÓNICO DE USO MÉDICO Y TERAPÉUTICO",
            Category.GROUP,
        ),
        Classification(
            "2660",
            "FABRICACIÓN DE EQUIPO DE IRRADIACIÓN Y EQUIPO ELÉCTRONICO DE USO MÉDICO Y TERAPEÚTICO ",
            Category.CLASS,
        ),
        Classification("267", "FABRICACIÓN DE INSTRUMENTOS ÓPTICOS Y EQUIPO FOTOGRÁFICO", Category.GROUP),
        Classification("2670", "FABRICACIÓN DE INSTRUMENTOS ÓPTICOS Y EQUIPO FOTOGRÁFICO", Category.CLASS),
        Classification("268", "FABRICACIÓN DE SOPORTES MAGNÉTICOS Y ÓPTICOS ", Category.GROUP),
        Classification("2680", "FABRICACIÓN DE SOPORTES MAGNÉTICOS Y ÓPTICOS", Category.CLASS),
        Classification("27", "FABRICACIÓN DE EQUIPO ELÉCTRICO  ", Category.DIVISION),
        Classification(
            "271",
            "FABRICACIÓN DE MOTORES, GENERADORES Y TRANSFORMADORES ELÉCTRICOS Y APARATOS DE DISTRIBUCIÓN Y CONTROL DE LA ENERGÍA ELÉCTRICA",
            Category.GROUP,
        ),
        Classification(
            "2710",
            "FABRICACIÓN DE MOTORES, GENERADORES Y TRANSFORMADORES ELÉCTRICOS Y APARATOS DE DISTRIBUCIÓN Y CONTROL DE LA ENERGÍA ELÉCTRICA",
            Category.CLASS,
        ),
        Classification("272", "FABRICACIÓN DE PILAS, BATERÍAS Y ACUMULADORES", Category.GROUP),
        Classification("2720", "FABRICACIÓN DE PILAS, BATERÍAS Y ACUMULADORES", Category.CLASS),
        Classification("273", "FABRICACIÓN DE CABLES Y DISPOSITIVOS DE CABLEADO", Category.GROUP),
        Classification("2731", "FABRICACIÓN DE CABLES DE FIBRA ÓPTICA", Category.CLASS),
        Classification("2732", "FABRICACIÓN DE OTROS HILOS Y CABLES ELÉCTRICOS", Category.CLASS),
        Classification("2733", "FABRICACIÓN DE DISPOSITIVOS DE CABLEADO", Category.CLASS),
        Classification("274", "FABRICACIÓN DE EQUIPO ELÉCTRICO DE ILUMINACIÓN ", Category.GROUP),
        Classification("2740", "FABRICACIÓN DE EQUIPO ELECTRICO DE ILUMINACIÓN ", Category.CLASS),
        Classification("275", "FABRICACIÓN DE APARATOS DE USO DOMÉSTICO", Category.GROUP),
        Classification("2750", "FABRICACIÓN DE APARATOS DE USO DOMÉSTICO", Category.CLASS),
        Classification("279", "FABRICACIÓN DE OTROS TIPOS DE EQUIPO ELÉTRICO", Category.GROUP),
        Classification("2790", "FABRICACIÓN DE OTROS TIPOS DE EQUIPO ELÉTRICO", Category.CLASS),
        Classification("28", "FABRICACIÓN DE MAQUINARIA Y EQUIPO N.C.P.", Category.DIVISION),
        Classification("281", "FABRICACIÓN DE MAQUINARIA DE USO GENERAL", Category.GROUP),
        Classification(
            "2811",
            "FABRICACIÓN DE MOTORES Y TURBINAS, EXCEPTO MOTORES PARA AERONAVES, VEHÍCULOS AUTOMOTORES Y MOTOCICLETAS",
            Category.CLASS,
        ),
        Classification("2812", "FABRICACIÓN DE EQUIPO DE PROPULSIÓN DE FLUIDOS", Category.CLASS),
        Classification("2813", "FABRICACIÓN DE OTRAS BOMBAS COMPRESORAS GRIFOS Y VÁLVULAS", Category.CLASS),
        Classification(
            "2814", "FABRICACIÓN DE COJINETES, ENGRANAJES TRENES DE ENGRANAJES Y PIEZAS DE TRANSMISIÓN", Category.CLASS
        ),
        Classification("2815", "FABRICACIÓN DE HORNOS, HOGARES Y QUEMADORES", Category.CLASS),
        Classification("2816", "FABRICACIÓN DE EQUIPO DE ELEVACIÓN Y MANIPULACIÓN", Category.CLASS),
        Classification(
            "2817",
            "FABRICACIÓN DE MAQUINARIA Y EQUIPO DE OFICINA (EXCEPTO ORDENADORES Y EQUIPO PERIFÉRICO)",
            Category.CLASS,
        ),
        Classification("2818", "FABRICACIÓN DE HERRAMIENTAS DE MANO MOTORIZADAS", Category.CLASS),
        Classification("2819", "FABRICACIÓN DE OTROS TIPOS DE MAQUINARIA DE USO GENERAL", Category.CLASS),
        Classification("282", "FABRICACIÓN DE MAQUINARIA DE USO ESPECIAL", Category.GROUP),
        Classification("2821", "FABRICACIÓN DE MAQUINARIA AGROPECUARIA Y FORESTAL", Category.CLASS),
        Classification(
            "2822",
            "FABRICACIÓN DE MAQUINARIA PARA LA CONFORMACIÓN DE METALES Y DE MÁQUINAS HERRAMIENTA",
            Category.CLASS,
        ),
        Classification("2823", "FABRICACIÓN DE MAQUINARIA METALÚRGICA", Category.CLASS),
        Classification(
            "2824",
            "FABRICACIÓN DE MAQUINARIA PARA LA EXPLOTACIÓN DE MINAS Y CANTERAS Y PARA OBRAS DE CONSTRUCCIÓN",
            Category.CLASS,
        ),
        Classification(
            "2825", "FABRICACIÓN DE MAQUINARIA PARA LA ELABORACIÓN DE ALIMENTOS, BEBIDAS Y TABACO", Category.CLASS
        ),
        Classification(
            "2826",
            "FABRICACIÓN DE MAQUINARIA PARA LA ELABORACIÓN DE PRODUCTOS TEXTILES, PRENDAS DE VESTIR Y CUEROS",
            Category.CLASS,
        ),
        Classification("2829", "FABRICACIÓN DE OTROS TIPOS DE MAQUINARIA DE USO ESPECIAL", Category.CLASS),
        Classification("29", "FABRICACIÓN DE VEHÍCULOS AUTOMOTORES, REMOLQUES Y SEMIREMOLQUES", Category.DIVISION),
        Classification("291", "FABRICACIÓN DE VEHÍCULOS AUTOMOTORES", Category.GROUP),
        Classification("2910", "FABRICACIÓN DE VEHÍCULOS AUTOMOTORES", Category.CLASS),
        Classification(
            "292",
            "FABRICACIÓN DE CARROCERÍAS PARA VEHÍCULOS AUTOMOTORES; FABRICACIÓN DE REMOLQUES Y SEMIRREMOLQUES",
            Category.GROUP,
        ),
        Classification(
            "2920",
            "FABRICACIÓN DE CARROCERÍAS PARA VEHÍCULOS AUTOMOTORES; FABRICACIÓN DE REMOLQUES Y SEMIRREMOLQUES",
            Category.CLASS,
        ),
        Classification("293", "FABRICACIÓN DE PARTES, PIEZAS Y ACCESORIOS PARA VEHÍCULOS AUTOMOTORES", Category.GROUP),
        Classification("2930", "FABRICACIÓN DE PARTES, PIEZAS Y ACCESORIOS PARA VEHÍCULOS AUTOMOTORES", Category.CLASS),
        Classification("30", "FABRICACIÓN DE OTROS TIPOS DE EQUIPO DE TRANSPORTE", Category.DIVISION),
        Classification("301", "CONSTRUCCIÓN DE BUQUES Y OTRAS EMBARCACIONES", Category.GROUP),
        Classification("3011", "CONSTRUCCIÓN DE BUQUES Y ESTRUCTURAS FLOTANTES", Category.CLASS),
        Classification("3012", "CONSTRUCCIÓN DE EMBARCACIONES DE RECREO Y DEPORTE", Category.CLASS),
        Classification("302", "FABRICACIÓN DE LOCOMOTORAS Y MATERIAL RODANTE", Category.GROUP),
        Classification("3020", "FABRICACIÓN DE LOCOMOTORAS Y MATERIAL RODANTE", Category.CLASS),
        Classification("303", "FABRICACIÓN DE AERONAVES Y NAVES ESPACIALES Y MAQUINARIA CONEXA", Category.GROUP),
        Classification("3030", "FABRICACIÓN DE AERONAVES Y NAVES ESPECIALES Y MAQUINARIA CONEXA", Category.CLASS),
        Classification("304", "FABRICACIÓN DE VEHÍCULOS MILITARES DE COMBATE", Category.GROUP),
        Classification("3040", "FABRICACIÓN DE VEHÍCULOS MILITARES DE COMBATE", Category.CLASS),
        Classification("309", "FABRICACIÓN DE EQUIPO DE TRANSPORTE N.C.P.", Category.GROUP),
        Classification("3091", "FABRICACIÓN DE MOTOCICLETAS", Category.CLASS),
        Classification("3092", "FABRICACIÓN DE BICICLETAS Y DE SILLONES DE RUEDAS PARA INVÁLIDOS", Category.CLASS),
        Classification("3099", "FABRICACIÓN DE OTROS TIPOS DE EQUIPO DE TRANSPORTE N.C.P.", Category.CLASS),
        Classification("31", "FABRICACIÓN DE MUEBLES", Category.DIVISION),
        Classification("310", "FABRICACIÓN DE MUEBLES", Category.GROUP),
        Classification("3100", "FABRICACIÓN DE MUEBLES", Category.CLASS),
        Classification("32", "OTRAS INDUSTRIAS MANUFACTURERAS N.C.P.", Category.DIVISION),
        Classification("321", "FABRICACIÓN DE JOYAS BISUTERÍA Y ARTÍCULOS CONEXOS", Category.GROUP),
        Classification("3211", "FABRICACIÓN DE JOYAS Y ARTÍCULOS CONEXOS", Category.CLASS),
        Classification("3212", "FABRICACIÓN DE BISUTERÍA Y ARTÍCULOS CONEXOS", Category.CLASS),
        Classification("322", "FABRICACIÓN DE INSTRUMENTOS MUSICALES", Category.GROUP),
        Classification("3220", "FABRICACIÓN DE INSTRUMENTOS MUSICALES", Category.CLASS),
        Classification("323", "FABRICACIÓN DE ARTÍCULOS DE DEPORTE", Category.GROUP),
        Classification("3230", "FABRICACIÓN DE ARTÍCULOS DE DEPORTE", Category.CLASS),
        Classification("324", "FABRICACIÓN DE JUEGOS Y JUGUETES", Category.GROUP),
        Classification("3240", "FABRICACIÓN DE JUEGOS Y JUGUETES", Category.CLASS),
        Classification("325", "FABRICACIÓN DE INSTRUMENTOS Y MATERIALES MÉDICOS Y ODONTOLÓGICOS", Category.GROUP),
        Classification("3250", "FABRICACIÓN DE INSTRUMENTOS Y MATERIALES MÉDICOS Y ODONTOLÓGICOS", Category.CLASS),
        Classification("329", "OTRAS INDUSTRIAS MANUFACTURERAS N.C.P.", Category.GROUP),
        Classification("3290", "OTRAS INDUSTRIAS MANUFACTURERAS N.C.P.", Category.CLASS),
        Classification("33", "REPARACIÓN E INSTALACIÓN DE MAQUINARIA Y EQUIPO", Category.DIVISION),
        Classification("331", "REPARACIÓN DE PRODUCTOS ELABORADOS DE METAL, MAQUINARIA Y EQUIPO", Category.GROUP),
        Classification("3311", "REPARACIÓN DE PRODUCTOS ELABORADOS DE METAL ", Category.CLASS),
        Classification("3312", "REPARACIÓN DE MAQUINARIA", Category.CLASS),
        Classification("3313", "REPARACIÓN DE EQUIPO ELECTRÓNICO Y ÓPTICO", Category.CLASS),
        Classification("3314", "REPARACIÓN DE EQUIPO ELÉCTRICO", Category.CLASS),
        Classification("3315", "REPARACIÓN DE EQUIPO DE TRANSPORTE, EXCEPTO VEHÍCULOS AUTOMOTORES", Category.CLASS),
        Classification("3319", "REPARACIÓN DE OTROS TIPOS DE EQUIPO", Category.CLASS),
        Classification("332", "INSTALACIÓN DE MAQUINARIA Y EQUIPO INDUSTRIALES", Category.GROUP),
        Classification("3320", "INSTALACIÓN DE MAQUINARIA Y EQUIPO INDUSTRIALES", Category.CLASS),
        Classification("D", "SUMINISTRO DE ELECTRICIDAD, GAS VAPOR Y AIRE ACONDICIONADO", Category.SECTION),
        Classification("35", "SUMINISTRO DE ELECTRICIDAD, GAS, VAPOR Y AIRE ACONDICIONADO", Category.DIVISION),
        Classification("351", "GENERACIÓN, TRANSMISIÓN Y DISTRIBUCIÓN DE ENERGÍA ELÉCTRICA", Category.GROUP),
        Classification("3510", "GENERACIÓN, TRANSMISIÓN Y DISTRIBUCIÓN DE ENERGÍA ELÉCTRICA", Category.CLASS),
        Classification("352", "FABRICACIÓN DE GAS; DISTRIBUCIÓN DE COMBUSTIBLES GASEOSOS POR TUBERÍAS", Category.GROUP),
        Classification(
            "3520", "FABRICACIÓN DE GAS; DISTRIBUCIÓN DE COMBUSTIBLES GASEOSOS POR TUBERÍAS", Category.CLASS
        ),
        Classification("353", "SUMINISTRO DE VAPOR Y DE AIRE ACONDICIONADO", Category.GROUP),
        Classification("3530", "SUMINISTRO DE VAPOR Y DE AIRE ACONDICIONADO", Category.CLASS),
        Classification(
            "E",
            "SUMINISTRO DE AGUA; EVACUACIÓN DE AGUAS RESIDUALES, GESTIÓN DE DESECHOS Y DESCONTAMINACIÓN ",
            Category.SECTION,
        ),
        Classification("36", "CAPTACIÓN, TRATAMIENTO Y DISTRIBUCIÓN DE AGUA", Category.DIVISION),
        Classification("360", "CAPTACIÓN, TRATAMIENTO Y DISTRIBUCIÓN DE AGUA", Category.GROUP),
        Classification("3600", "CAPTACIÓN, TRATAMIENTO Y DISTRIBUCIÓN DE AGUA", Category.CLASS),
        Classification("37", "EVACUACIÓN DE AGUAS RESIDUALES", Category.DIVISION),
        Classification("370", "EVACUACIÓN DE AGUAS RESIDUALES", Category.GROUP),
        Classification("3700", "EVACUACIÓN DE AGUAS RESIDUALES", Category.CLASS),
        Classification(
            "38", "RECOGIDA, TRATAMIENTO Y ELIMINACIÓN DE DESECHOS; RECUPERACIÓN DE MATERIALES", Category.DIVISION
        ),
        Classification("381", "RECOGIDA DE DESECHOS", Category.GROUP),
        Classification("3811", "RECOGIDA DE DESECHOS NO PELIGROSOS", Category.CLASS),
        Classification("3812", "RECOGIDA DE DESECHOS PELIGROSOS", Category.CLASS),
        Classification("382", "TRATAMIENTO Y ELIMINACIÓN DE DESECHOS", Category.GROUP),
        Classification("3821", "TRATAMIENTO Y ELIMINACIÓN DE DESECHOS NO PELIGROSOS", Category.CLASS),
        Classification("3822", "TRATAMIENTO Y ELIMINACIÓN DE DESECHOS PELIGROSOS", Category.CLASS),
        Classification("383", "RECUPERACIÓN DE MATERIALES", Category.GROUP),
        Classification("3830", "RECUPERACIÓN DE MATERIALES", Category.CLASS),
        Classification(
            "39", "ACTIVIDADES DE DESCONTAMINACIÓN Y OTROS SERVICIOS DE GESTIÓN DE DESECHOS", Category.DIVISION
        ),
        Classification(
            "390", "ACTIVIDADES DE DESCONTAMINACIÓN Y OTROS SERVICIOS DE GESTIÓN DE DESECHOS", Category.GROUP
        ),
        Classification(
            "3900", "ACTIVIDADES DE DESCONTAMINACIÓN Y OTROS SERVICIOS DE GESTIÓN DE DESECHOS", Category.CLASS
        ),
        Classification("F", "CONSTRUCCIÓN", Category.SECTION),
        Classification("41", "CONSTRUCCIÓN DE EDIFICIOS", Category.DIVISION),
        Classification("410", "CONSTRUCCIÓN DE EDIFICIOS", Category.GROUP),
        Classification("4100", "CONSTRUCCIÓN DE EDIFICIOS", Category.CLASS),
        Classification("42", "OBRAS DE INGENIERÍA CIVIL", Category.DIVISION),
        Classification("421", "CONSTRUCCIÓN DE CARRETERAS Y LÍNEAS DE FERROCARRIL", Category.GROUP),
        Classification("4210", "CONSTRUCCIÓN DE CARRETERAS Y LÍNEAS DE FERROCARRIL", Category.CLASS),
        Classification("422", "CONSTRUCCIÓN DE PROYECTOS DE SERVICIO PÚBLICO", Category.GROUP),
        Classification("4220", "CONSTRUCCIÓN DE PROYECTOS DE SERVICIO PÚBLICO", Category.CLASS),
        Classification("429", "CONSTRUCCIÓN DE OTRAS OBRAS DE INGENIERÍA CIVIL", Category.GROUP),
        Classification("4290", "CONSTRUCCIÓN DE OTRAS OBRAS DE INGENIERÍA CIVIL", Category.CLASS),
        Classification("43", "ACTIVIDADES ESPECIALIZADAS DE CONSTRUCCIÓN", Category.DIVISION),
        Classification("431", "DEMOLICIÓN Y PREPARACIÓN DEL TERRENO", Category.GROUP),
        Classification("4311", "DEMOLICIÓN", Category.CLASS),
        Classification("4312", "PREPARACIÓN DEL TERRENO", Category.CLASS),
        Classification(
            "432",
            "INSTALACIONES ELÉCTRICAS Y DE FONTANERÍA Y OTRAS INSTALACIONES PARA OBRAS DE CONSTRUCCIÓN",
            Category.GROUP,
        ),
        Classification("4321", "INSTALACIONES ELÉCTRICAS", Category.CLASS),
        Classification("4322", "INSTALACIONES DE FONTANERÍA Y AIRE ACONDICIONADO", Category.CLASS),
        Classification("4329", "OTRAS INSTALACIONES OBRAS DE CONSTRUCCIÓN", Category.CLASS),
        Classification("433", "TERMINACIÓN Y ACABADO DE EDIFICIOS", Category.GROUP),
        Classification("4330", "TERMINACIÓN Y ACABADO DE EDIFICIOS", Category.CLASS),
        Classification("439", "OTRAS ACTIVIDADES ESPECIALIZADAS DE CONSTRUCCIÓN", Category.GROUP),
        Classification("4390", "OTRAS ACTIVIDADES ESPECIALIZADAS DE CONSTRUCCIÓN", Category.CLASS),
        Classification(
            "G",
            "COMERCIO AL POR MAYOR Y AL POR MENOR; REPARACIÓN DE VEHÍCULOS AUTOMOTORES Y MOTOCICLETAS",
            Category.SECTION,
        ),
        Classification(
            "45",
            "COMERCIO AL POR MAYOR Y AL POR MENOR Y REPARACIÓN DE VEHÍCULOS AUTOMOTORES Y MOTOCICLETAS",
            Category.DIVISION,
        ),
        Classification("451", "VENTA DE VEHÍCULOS AUTOMOTORES ", Category.GROUP),
        Classification("4510", "VENTA DE VEHÍCULOS AUTOMOTORES", Category.CLASS),
        Classification("452", "MANTENIMIENTO Y REPARACIÓN DE VEHÍCULOS AUTOMOTORES", Category.GROUP),
        Classification("4520", "MANTENIMIENTO Y REPARACIÓN DE VEHÍCULOS AUTOMOTORES", Category.CLASS),
        Classification("453", "VENTA DE PARTES, PIEZAS Y ACCESORIOS PARAVEHÍCULOS AUTOMOTORES", Category.GROUP),
        Classification("4530", "VENTA DE PARTES, PIEZAS Y ACCESORIOS PARA VEHÍCULOS AUTOMOTORES", Category.CLASS),
        Classification(
            "454", "VENTA, MANTENIMIENTO Y REPARACIÓN DE MOTOCICLETAS Y SUS PARTES, PIEZAS Y ACCESORIOS", Category.GROUP
        ),
        Classification(
            "4540",
            "VENTA, MANTENIMIENTO Y REPARACIÓN DE MOTOCICLETAS Y SUS PARTES, PIEZAS Y ACCESORIOS",
            Category.CLASS,
        ),
        Classification(
            "46", "COMERCIO AL POR MAYOR, EXCEPTO EL DE VEHÍCULOS AUTOMOTORES Y MOTOCICLETAS", Category.DIVISION
        ),
        Classification("461", "VENTA AL POR MAYOR A CAMBIO DE UNA RETRIBUCIÓN O POR CONTRATA", Category.GROUP),
        Classification("4610", "VENTA AL POR MAYOR A CAMBIO DE UNA RETRIBUCIÓN O POR CONTRATA", Category.CLASS),
        Classification("462", "VENTA AL POR MAYOR DE MATERIAS PRIMAS AGROPECUARIAS Y ANIMALES VIVOS", Category.GROUP),
        Classification("4620", "VENTA AL POR MAYOR DE MATERIAS PRIMAS AGROPECUARIAS Y ANIMALES VIVOS", Category.CLASS),
        Classification("463", "VENTA AL POR MAYOR DE ALIMENTOS, BEBIDAS Y TABACO", Category.GROUP),
        Classification("4630", "VENTA AL POR MAYOR DE ALIMENTOS, BEBIDAS Y TABACO", Category.CLASS),
        Classification("464", "VENTA AL POR MAYOR DE ENSERES DOMÉSTICOS", Category.GROUP),
        Classification("4641", "VENTA AL POR MAYOR DE PRODUCTOS TEXTILES, PRENDAS DE VESTIR Y CALZADO", Category.CLASS),
        Classification("4649", "VENTA AL POR MAYOR DE OTROS ENSERES DOMÉSTICOS", Category.CLASS),
        Classification("465", "VENTA AL POR MAYOR DE MAQUINARIA, EQUIPO Y MATERIALES", Category.GROUP),
        Classification(
            "4651", "VENTA AL POR MAYOR DE ORDENADORES, EQUIPO PERIFÉRICO Y PROGRAMAS INFORMÁTICOS", Category.CLASS
        ),
        Classification(
            "4652", "VENTA AL POR MAYOR DE EQUIPO, PARTES Y PIEZAS ELECTRÓNICOS Y DE TELECOMUNICACIONES", Category.CLASS
        ),
        Classification("4653", "VENTA AL POR MAYOR DE MAQUINARIA, EQUIPO Y MATERIALES AGROPECUARIOS", Category.CLASS),
        Classification("4659", "VENTA AL POR MAYOR DE OTROS TIPOS DE MAQUINARIA Y EQUIPO", Category.CLASS),
        Classification("466", "OTRAS ACTIVIDADES DE VENTA AL POR MAYOR ESPECIALIZADA", Category.GROUP),
        Classification(
            "4661",
            "VENTA AL POR MAYOR DE COMBUSTIBLES SÓLIDOS, LÍQUIDOS Y GASEOSOS Y PRODUCTOS CONEXOS",
            Category.CLASS,
        ),
        Classification("4662", "VENTA AL POR MAYOR DE METALES Y MINERALES METALÍFEROS", Category.CLASS),
        Classification(
            "4663",
            "VENTA AL POR MAYOR DE MATERIALES DE CONSTRUCCIÓN, ARTÍCULOS DE FERRETERÍA Y EQUIPO Y MATERIALES DE FONTANERÍA Y CALEFACCIÓN",
            Category.CLASS,
        ),
        Classification(
            "4669", "VENTA AL POR MAYOR DE DESPERDICIOS, DESECHOS, CHATARRA Y OTROS PRODUCTOS N.C.P.", Category.CLASS
        ),
        Classification("469", "VENTA AL POR MAYOR NO ESPECIALIZADA", Category.GROUP),
        Classification("4690", "VENTA AL POR MAYOR NO ESPECIALIZADA", Category.CLASS),
        Classification(
            "47", "COMERCIO AL POR MENOR, EXCEPTO EL DE VEHÍCULOS AUTOMOTORES Y MOTOCICLETAS", Category.DIVISION
        ),
        Classification("471", "VENTA AL POR MENOR EN COMERCIOS NO ESPECIALIZADOS", Category.GROUP),
        Classification(
            "4711",
            "VENTA AL POR MENOR EN COMERCIOS NO ESPECIALIZADOS CON PREDOMINIO DE LA VENTA DE ALIMENTOS, BEBIDAS O TABACO",
            Category.CLASS,
        ),
        Classification(
            "4719", "OTRAS ACTIVIDADES DE VENTA AL POR MENOR EN COMERCIOS NO ESPECIALIZADOS", Category.CLASS
        ),
        Classification(
            "472", "VENTA AL POR MENOR DE ALIMENTOS, BEBIDAS Y TABACO EN COMERCIOS ESPECIALIZADOS", Category.GROUP
        ),
        Classification("4721", "VENTA AL POR MENOR DE ALIMENTOS EN COMERCIOS ESPECIALIZADOS", Category.CLASS),
        Classification("4722", "VENTA AL POR MENOR DE BEBIDAS EN COMERCIOS ESPECIALIZADOS", Category.CLASS),
        Classification("4723", "VENTA AL POR MENOR DE PRODUCTOS DE TABACO COMERCIO ESPECIALIZADOS", Category.CLASS),
        Classification(
            "473",
            "VENTA AL POR MENOR DE COMBUSTIBLES PARA VEHÍCULOS AUTOMOTORES EN COMERICIOS ESPECIALIZADOS",
            Category.GROUP,
        ),
        Classification(
            "4730",
            "VENTA AL POR MENOR DE COMBUSTIBLES PARA  VEHÍCULOS AUTOMOTORES EN COMERCIOS ESPECIALIZADOS",
            Category.CLASS,
        ),
        Classification(
            "474",
            "VENTA AL POR MENOR DE EQUIPO DE INFORMACIÓN Y DE COMUNICACIONES EN COMERCIOS ESPECIALIZADOS",
            Category.GROUP,
        ),
        Classification(
            "4741",
            "VENTA AL POR MENOR DE ORDENADORES, EQUIPO PERIFÉRICO, PROGRAMAS INFORMÁTICOS Y EQUIPO DE TELECOMUNICACIONES EN COMERCIOS ESPECIALIZADOS",
            Category.CLASS,
        ),
        Classification(
            "4742", "VENTA AL POR MENOR DE EQUIPO DE SONIDO Y DE VIDEO EN COMERCIOS ESPECIALIZADOS", Category.CLASS
        ),
        Classification(
            "475", "VENTA AL POR MENOR DE OTROS ENSERES DOMÉSTICOS EN COMERCIOS ESPECIALIZADOS", Category.GROUP
        ),
        Classification("4751", "VENTA AL POR MENOR DE PRODUCTOS TEXTILES EN COMERCIOS ESPECIALIZADOS", Category.CLASS),
        Classification(
            "4752",
            "VENTA AL POR MENOR DE ARTÍCULOS DE FERRETERÍA PINTURAS Y PRODUCTOS DE VIDRIO EN COMERCIOS ESPECIALIZADOS",
            Category.CLASS,
        ),
        Classification(
            "4753",
            "VENTA AL POR MENOR DE TAPICES, ALFOMBRAS Y CUBRIMIENTOS PARA PAREDES Y PISOS EN COMERCIOS ESPECIALIZADOS",
            Category.CLASS,
        ),
        Classification(
            "4759",
            "VENTA AL POR MENOR DE APARATOS ELÉCTRICOS DE USO DOMÉTISCO, MUEBLES, EQUIPO DE ILUMINACIÓN Y OTROS ENSERES DOMÉSTICOS EN COMERCIOS ESPECIALIZADOS",
            Category.CLASS,
        ),
        Classification(
            "476",
            "VENTA AL POR MENOR DE PRODUCTOS CULTURALES Y RECREATIVOS EN COMERCIOS ESPECIALIZADOS",
            Category.GROUP,
        ),
        Classification(
            "4761",
            "VENTA AL POR MENOR DE LIBROS, PERIÓDICOS Y ARTÍCULOS DE PAPELERÍA EN COMERCIOS ESPECIALIZADOS",
            Category.CLASS,
        ),
        Classification(
            "4762", "VENTA AL POR MENOR DE GRABACIONES DE MÚSICA Y DE VÍDEO EN COMERCIOS ESPECIALIZADOS", Category.CLASS
        ),
        Classification("4763", "VENTA AL POR MENOR DE EQUIPO DE DEPORTE EN COMERCIOS ESPECIALIZADOS", Category.CLASS),
        Classification("4764", "VENTA AL POR MENOR DE JUEGOS Y JUGUETES EN COMERCIOS ESPECIALIZADOS", Category.CLASS),
        Classification("477", "VENTA AL POR MENOR DE OTROS PRODUCTOS EN COMERCIOS ESPECIALIZADOS", Category.GROUP),
        Classification(
            "4771",
            "VENTA AL POR MENOR DE PRENDAS DE VESTIR, CALZADO Y ARTÍCULOS DE CUERO EN COMERCIOS ESPECIALIZADOS ",
            Category.CLASS,
        ),
        Classification(
            "4772",
            "VENTA AL POR MENOR DE PRODUCTOS FARMACEÚTICOS Y MEDICINALES, COSMÉTICOS Y ARTÍCULOS DE TOCADOR EN COMERCIOS ESPECIALIZADOS ",
            Category.CLASS,
        ),
        Classification(
            "4773", "VENTA AL POR MENOR DE OTROS PRODUCTOS NUEVOS EN COMERCIOS ESPECIALIZADOS ", Category.CLASS
        ),
        Classification("4774", "VENTA AL POR MENOR DE ARTÍCULOS DE SEGUNDA MANO ", Category.CLASS),
        Classification("478", "VENTA AL POR MENOR EN PUESTOS DE VENTA Y MERCADOS", Category.GROUP),
        Classification(
            "4781", "VENTA AL POR MENOR DE ALIMENTOS, BEBIDAS Y TABACO EN PUESTOS DE VENTA Y MERCADOS", Category.CLASS
        ),
        Classification(
            "4782",
            "VENTA AL POR MENOR DE PRODUCTOS TEXTILES, PRENDAS DE VESTIR Y CALZADO EN PUESTOS DE VENTA Y MERCADOS",
            Category.CLASS,
        ),
        Classification("4789", "VENTA AL POR MENOR DE OTROS PRODUCTOS EN PUESTOS DE VENTA Y MERCADOS", Category.CLASS),
        Classification(
            "479", "VENTA AL POR MENOR NO REALIZADA EN COMERCIOS, PUESTOS DE VENTA O MERCADOS", Category.GROUP
        ),
        Classification("4791", "VENTA AL POR MENOR POR CORREO Y POR INTERNET", Category.CLASS),
        Classification(
            "4799",
            "OTRAS ACTIVIDADES DE VENTA AL POR MENOR NO REALIZADAS EN COMERCIOS, PUESTOS DE VENTA O MERCADOS",
            Category.CLASS,
        ),
        Classification("H", "TRANSPORTE Y ALMACENAMIENTO", Category.SECTION),
        Classification("49", "TRANSPORTE POR VÍA TERRESTRE Y TRANSPORTE POR TUBERÍAS", Category.DIVISION),
        Classification("491", "TRANSPORTE POR FERROCARRIL", Category.GROUP),
        Classification("4911", "TRANSPORTE INTERURBANO DE PASAJEROS POR FERROCARRIL", Category.CLASS),
        Classification("4912", "TRANSPORTE DE DE CARGA POR FERROCARRIL", Category.CLASS),
        Classification("492", "OTRAS ACTIVIDADES DE TRANSPORTE POR VÍA TERRESTRE", Category.GROUP),
        Classification("4921", "TRANSPORTE URBANO Y SUBURBANO DE PASAJEROS POR VÍA TERRESTRE ", Category.CLASS),
        Classification("4922", "OTRAS ACTIVIDADES DE TRANSPORTE DE PASAJEROS POR VÍA TERRESTRE", Category.CLASS),
        Classification("4923", "TRANSPORTE DE CARGA POR CARRETERA", Category.CLASS),
        Classification("493", "TRANSPORTE POR TUBERÍAS", Category.GROUP),
        Classification("4930", "TRANSPORTE POR TUBERÍAS", Category.CLASS),
        Classification("50", "TRANSPORTE POR VÍA ACUÁTICA", Category.DIVISION),
        Classification("501", "TRANSPORTE MARÍTIMO Y DE CABOTAJE", Category.GROUP),
        Classification("5011", "TRANSPORTE DE PASAJEROS MARÍTIMO Y DE CABOTAJE", Category.CLASS),
        Classification("5012", "TRANSPORTE DE CARGA MARÍTIMO Y DE CABOTAJE", Category.CLASS),
        Classification("502", "TRANSPORTE POR VÍAS DE NAVEGACIÓN INTERIORES", Category.GROUP),
        Classification("5021", "TRANSPORTE DE PASAJEROS POR VÍAS DE NAVEGACIÓN INTERIORES", Category.CLASS),
        Classification("5022", "TRANSPORTE DE CARGA DE VÍAS DE NAVEGACIÓN INTERIORES", Category.CLASS),
        Classification("51", "TRANSPORTE POR VÍA ÁEREA", Category.DIVISION),
        Classification("511", "TRANSPORTE DE PASAJEROS POR VÍA AÉREA", Category.GROUP),
        Classification("5110", "TRANSPORTE DE PASAJEROS POR VÍA AÉREA", Category.CLASS),
        Classification("512", "TRANSPORTE DE CARGA POR VÍA AÉREA", Category.GROUP),
        Classification("5120", "TRANSPORTE DE CARGA POR VÍA AÉREA", Category.CLASS),
        Classification("52", "ALMACENAMIENTO Y ACTIVIDADES DE APOYO AL TRANSPORTE", Category.DIVISION),
        Classification("521", "ALMACENAMIENTO  Y DEPÓSITO", Category.GROUP),
        Classification("5210", "ALMACENAMIENTO Y DEPÓSITO", Category.CLASS),
        Classification("522", "ACTIVIDADES DE APOYO AL TRANSPORTE", Category.GROUP),
        Classification("5221", "ACTIVIDADES DE SERVICIOS VINCULADAS AL TRANSPORTE TERRESTRE", Category.CLASS),
        Classification("5222", "ACTIVIDADES DE SERVICIOS VINCULADAS AL TRANSPORTE ACUÁTICO", Category.CLASS),
        Classification("5223", "ACTIVIDADES DE SERVICIOS VINCULADAS AL TRANSPORTE AÉREO", Category.CLASS),
        Classification("5224", "MANIPULACIÓN DE CARGA", Category.CLASS),
        Classification("5229", "OTRAS ACTIVIDADES DE APOYO AL TRANSPORTE", Category.CLASS),
        Classification("53", "ACTIVIDADES POSTALES Y DE MENSAJERÍA ", Category.DIVISION),
        Classification("531", "ACTIVIDADES POSTALES", Category.GROUP),
        Classification("5310", "ACTIVIDADES POSTALES", Category.CLASS),
        Classification("532", "ACTIVIDADES DE MENSAJERÍA", Category.GROUP),
        Classification("5320", "ACTIVIDADES DE MENSAJERÍA", Category.CLASS),
        Classification("I", "ACTIVIDADES DE ALOJAMIENTO Y DE SERVICIOS DE COMIDA", Category.SECTION),
        Classification("55", "ACTIVIDADES DE ALOJAMIENTO", Category.DIVISION),
        Classification("551", "ACTIVIDADES DE ALOJAMIENTO PARA ESTANCIAS CORTAS", Category.GROUP),
        Classification("5510", "ACTIVIDADES DE ALOJAMIENTO PARA ESTANCIAS CORTAS", Category.CLASS),
        Classification(
            "552", "ACTIVIDADES DE CAMPAMENTOS, PARQUES DE VEHÍCULOS DE RECREO Y PARQUES DE CARAVANAS", Category.GROUP
        ),
        Classification(
            "5520", "ACTIVIDADES DE CAMPISMO, PARQUES DE VEHÍCULOS DE RECREO Y PARQUES DE CARAVANAS", Category.CLASS
        ),
        Classification("559", "OTRAS ACTIVIDADES DE ALOJAMIENTO", Category.GROUP),
        Classification("5590", "OTRAS ACTIVIDADES DE ALOJAMIENTO", Category.CLASS),
        Classification("56", "ACTIVIDADES DE SERVICIO DE COMIDAS Y BEBIDAS", Category.DIVISION),
        Classification("561", "ACTIVIDADES DE RESTAURANTES Y DE SERVICIO MÓVIL DE COMIDAS", Category.GROUP),
        Classification("5610", "ACTIVIDADES DE RESTAURANTES Y DE SERVICIOS MÓVIL DE COMIDAS", Category.CLASS),
        Classification(
            "562", "SUMINISTRO DE COMIDAS POR ENCARGO Y OTRAS ACTIVIDADES DE SERVICIO DE COMIDAS", Category.GROUP
        ),
        Classification("5621", "SUMINISTRO DE COMIDAS POR ENCARGO", Category.CLASS),
        Classification("5629", "OTRAS ACTIVIDADES DE SERVICIO DE COMIDAS", Category.CLASS),
        Classification("563", "ACTIVIDADES DE SERVICIO DE BEBIDAS", Category.GROUP),
        Classification("5630", "ACTIVIDADES DE SERVICIO DE BEBIDAS", Category.CLASS),
        Classification("J", "INFORMACIÓN Y COMUNICACIONES", Category.SECTION),
        Classification("58", "ACTIVIDADES DE EDICIÓN", Category.DIVISION),
        Classification(
            "581", "EDICIÓN DE LIBROS Y PUBLICACIONES PERIÓDICAS Y OTRAS ACTIVIDADES DE EDICIÓN", Category.GROUP
        ),
        Classification("5811", "EDICIÓN DE LIBROS", Category.CLASS),
        Classification("5812", "EDICIÓN DE DIRECTORIOS Y LISTAS DE CORREO", Category.CLASS),
        Classification("5813", "EDICIÓN DE PERIÓDICOS, REVISTAS Y OTRAS PUBLICACIONES PERIÓDICAS", Category.CLASS),
        Classification("5819", "OTRAS ACTIVIDADES DE EDICIÓN", Category.CLASS),
        Classification("582", "EDICIÓN DE PROGRAMAS INFORMÁTICOS", Category.GROUP),
        Classification("5820", "EDICIÓN DE PROGRAMAS INFORMÁTICOS", Category.CLASS),
        Classification(
            "59",
            "ACTIVIDADES DE PRODUCCIÓN DE PELÍCULAS CINEMATOGRÁFICAS, VÍDEOS Y PROGRAMAS DE TELEVISIÓN, GRABACIÓN DE SONIDO Y EDICIÓN DE MÚSICA ",
            Category.DIVISION,
        ),
        Classification(
            "591",
            "ACTIVIDADES DE PRODUCCIÓN DE PELÍCULAS CINEMATOGRÁFICAS, VÍDEOS Y PROGRAMAS DE TELEVISIÓN ",
            Category.GROUP,
        ),
        Classification(
            "5911",
            "ACTIVIDADES DE PRODUCCIÓN DE PELÍCULAS CINEMATOGRÁFICAS, VÍDEOS Y PROGRAMAS DE TELEVISIÓN",
            Category.CLASS,
        ),
        Classification(
            "5912",
            "ACTIVIDADES DE POSTPRODUCCIÓN DE PELÍCULAS DE CINEMATOGRÁFICAS, VIDEOS Y PROGRAMAS DE TELVISIÓN ",
            Category.CLASS,
        ),
        Classification(
            "5913",
            "ACTIVIDADES DE DISTRIBUCIÓN DE PELÍCULAS CINEMATOGRÁFICAS VÍDEOS Y PROGRAMAS DE TELVISIÓN ",
            Category.CLASS,
        ),
        Classification(
            "5914", "ACTIVIDADES DE EXHIBICIÓN DE PELÍCULAS CINEMATOGRÁFICAS Y CINTAS DE VÍDEO", Category.CLASS
        ),
        Classification("592", "ACTIVIDADES DE GRABACIÓN DE SONIDO Y EDICIÓN DE MÚSICA", Category.GROUP),
        Classification("5920", "ACTIVIDADES DE GRABACIÓN DE SONIDO Y EDICIÓN DE MÚSICA", Category.CLASS),
        Classification("60", "ACTIVIDADES DE PROGRAMACIÓN Y TRANSMISIÓN", Category.DIVISION),
        Classification("601", "TRANSMISIONES DE RADIO", Category.GROUP),
        Classification("6010", "TRANSMISIONES DE RADIO", Category.CLASS),
        Classification("602", "PROGRAMACIÓN Y TRANSMISIONES DE TELEVISIÓN", Category.GROUP),
        Classification("6020", "PROGRAMACIÓN Y TRANSMISIONES DE TELEVISIÓN", Category.CLASS),
        Classification("61", "TELECOMUNICACIONES", Category.DIVISION),
        Classification("611", "ACTIVIDADES DE TELECOMUNICACIONES ", Category.GROUP),
        Classification("6110", "ACTIVIDADES DE TELECOMUNICACIONES ", Category.CLASS),
        Classification(
            "612",
            "ACTIVIDADES DE SOPORTE A LA INFRAESTRUCTURA PARA LA TRASMISIÓN DE RADIO Y TELEVISIÓN",
            Category.GROUP,
        ),
        Classification(
            "6120",
            "ACTIVIDADES DE SOPORTE A LA INFRAESTRUCTURA PARA LA TRASMISIÓN DE RADIO Y TELEVISIÓN",
            Category.CLASS,
        ),
        Classification("613", "ACTIVIDADES DE TELECOMUNICACIONES POR SATÉLITE", Category.GROUP),
        Classification("6130", "ACTIVIDADES DE TELECOMUNICACIONES POR SATÉLITE", Category.CLASS),
        Classification("619", "OTRAS ACTIVIDADES DE TELECOMUNICACIONES", Category.GROUP),
        Classification("6190", "OTRAS ACTIVIDADES DE TELECOMUNICACIONES", Category.CLASS),
        Classification(
            "62", "PROGRAMACIÓN INFORMÁTICA, CONSULTORÍA DE INFORMÁTICA Y ACTIVIDADES CONEXAS", Category.DIVISION
        ),
        Classification(
            "620",
            "ACTIVIDADES DE PROGRAMACIÓN INFORMÁTICA Y DE CONSULTORÍA DE INFORMÁTICA Y ACTIVIDADES CONEXAS ",
            Category.GROUP,
        ),
        Classification("6201", "ACTIVIDADES DE PROGRAMACIÓN INFORMÁTICA", Category.CLASS),
        Classification(
            "6202",
            "ACTIVIDADES DE CONSULTORÍA DE INFORMÁTICA Y DE GESTIÓN DE INSTALACIONES INFORMÁTICAS",
            Category.CLASS,
        ),
        Classification("6203", "ACTIVIDADES DE CIBERSEGURIDAD", Category.CLASS),
        Classification(
            "6209", "OTRAS ACTIVIDADES DE TECNOLOGÍA DE LA INFORMACIÓN Y DE SERVICIOS INFORMÁTICOS", Category.CLASS
        ),
        Classification("63", "ACTIVIDADES DE SERVICIOS DE INFORMACIÓN", Category.DIVISION),
        Classification("631", "PROCESAMIENTO DE DATOS, HOSPEDAJE Y ACTIVIDADES CONEXAS; PORTALES WEB", Category.GROUP),
        Classification("6311", "PROCESAMIENTO DE DATOS, HOSPEDAJE Y ACTIVIDADES CONEXAS", Category.CLASS),
        Classification("6312", "PORTALES WEB", Category.CLASS),
        Classification("639", "OTRAS ACTIVIDADES DE SERVICIOS DE INFORMACIÓN ", Category.GROUP),
        Classification("6391", "ACTIVIDADES DE AGENCIAS DE NOTICIAS", Category.CLASS),
        Classification("6399", "OTRAS ACTIVIDADES DE SERVICIOS DE INFORMACIÓN N.C.P.", Category.CLASS),
        Classification("K", "ACTIVIDADES FINANCIERAS Y DE SEGUROS", Category.SECTION),
        Classification(
            "64", "ACTIVIDADES DE SERVICIOS FINANCIEROS, EXCEPTO LAS DE SEGUROS Y FONDO DE PENSIONES", Category.DIVISION
        ),
        Classification("641", "INTERMEDIACIÓN MONETARIA", Category.GROUP),
        Classification("6411", "BANCA CENTRAL", Category.CLASS),
        Classification("6419", "OTROS TIPOS DE INTERMEDIACIÓN MONETARIA", Category.CLASS),
        Classification("642", "ACTIVIDADES DE SOCIEDADES DE CARTERA", Category.GROUP),
        Classification("6420", "ACTIVIDADES DE SOCIEDADES DE CARTERA", Category.CLASS),
        Classification("643", "FONDOS Y SOCIEDADES DE INVERSIÓN Y ENTIDADES FINANCIERAS SIMILARES", Category.GROUP),
        Classification("6430", "FONDOS Y SOCIEDADES DE INVERSIÓN Y ENTIDADES FINANCIERAS SIMILARES", Category.CLASS),
        Classification(
            "649",
            "OTRAS ACTIVIDADES DE SERVICIOS FINANCIEROS, EXCEPTO LAS DE SEGUROS Y FONDOS DE PENSIONES",
            Category.GROUP,
        ),
        Classification("6491", "ARRENDAMIENTO FINANCIERO", Category.CLASS),
        Classification("6492", "OTRAS ACTIVIDADES DE CONCESIÓN DE CRÉDITO", Category.CLASS),
        Classification(
            "6499",
            "OTRAS ACTIVIDADES DE SERVICIOS FINANCIEROS EXCEPTO LAS DE SEGUROS Y FONDOS DE PENSIONES",
            Category.CLASS,
        ),
        Classification(
            "65",
            "SEGUROS, REASEGUROS Y FONDOS DE PENSIONES EXCEPTO PLANES DE SEGURIDAD SOCIAL DE AFILIACIÓN OBLIGATORIA",
            Category.DIVISION,
        ),
        Classification("651", "SEGUROS", Category.GROUP),
        Classification("6511", "SEGUROS DE VIDA", Category.CLASS),
        Classification("6512", "SEGUROS GENERALES", Category.CLASS),
        Classification("652", "REASEGUROS", Category.GROUP),
        Classification("6520", "REASEGUROS", Category.CLASS),
        Classification("653", "FONDOS DE PENSIONES", Category.GROUP),
        Classification("6530", "FONDOS DE PENSIONES", Category.CLASS),
        Classification("66", "ACTIVIDADES AUXILIARES DE LAS ACTIVIDADES DE SERVICIOS FINANCIEROS", Category.DIVISION),
        Classification(
            "661",
            "ACTIVIDADES AUXILIARES DE LAS  ACTIVIDADES DE SERVICIOS FINANCIEROS, EXCEPTO  LAS DE SEGUROS Y FONDOS DE PENSIONES",
            Category.GROUP,
        ),
        Classification("6611", "ADMINISTRACIÓN DE MERCADOS FINANCIEROS", Category.CLASS),
        Classification("6612", "CORRETAJE DE VALORES Y DE CONTRATOS DE PRODUCTOS BÁSICOS", Category.CLASS),
        Classification(
            "6619", "OTRAS ACTIVIDADES AUXILIARES DE LAS ACTIVIDADES DE SERVICIOS FINANCIEROS", Category.CLASS
        ),
        Classification(
            "662", "ACTIVIDADES AUXILIARES DE LAS ACTIVIDADES DE SEGUROS Y FONDOS DE PENSIONES", Category.GROUP
        ),
        Classification("6621", "EVALUACIÓN DE RIESGOS Y DAÑOS", Category.CLASS),
        Classification("6622", "ACTIVIDADES DE AGENTES Y CORREDORES DE SEGUROS", Category.CLASS),
        Classification(
            "6629", "OTRAS ACTIVIDADES AUXILIARES DE LAS ACTIVIDADES DE SEGUROS y FONDOS DE PENSIONES", Category.CLASS
        ),
        Classification("663", "ACTIVIDADES DE GESTIÓN DE FONDOS", Category.GROUP),
        Classification("6630", "ACTIVIDADES DE GESTIÓN DE FONDOS", Category.CLASS),
        Classification("L", "ACTIVIDADES INMOBILIARIAS", Category.SECTION),
        Classification("68", "ACTIVIDADES INMOBILIARIAS", Category.DIVISION),
        Classification("681", "ACTIVIDADES INMOBILIARIAS REALIZADAS CON BIENES PROPIOS O ARRENDADOS", Category.GROUP),
        Classification("6810", "ACTIVIDADES INMOBILIARIAS REALIZADAS CON BIENES PROPIOS O ARRENDADOS", Category.CLASS),
        Classification(
            "682", "ACTIVIDADES INMOBILIARIAS REALIZADAS A CAMBIO DE UNARETRIBUCIÓN O POR CONTRATA", Category.GROUP
        ),
        Classification(
            "6820", "ACTIVIDADES INMOBILIARIAS REALIZADAS A CAMBIO DE UNARETRIBUCIÓN O POR CONTRATA", Category.CLASS
        ),
        Classification("M", "ACTIVIDADES PROFESIONALES, CIENTÍFICAS Y TÉCNICAS", Category.SECTION),
        Classification("69", "ACTIVIDADES JURÍDICAS Y DE CONTABILIDAD", Category.DIVISION),
        Classification("691", "ACTIVIDADES JURÍDICAS", Category.GROUP),
        Classification("6910", "ACTIVIDADES JURÍDICAS", Category.CLASS),
        Classification(
            "692", "ACTIVIDADES DE CONTABILIDAD, TENEDURÍA DE LIBROS Y AUDITORÍA; CONSULTORÍA FISCAL", Category.GROUP
        ),
        Classification(
            "6920", "ACTIVIDADES DE CONTABILIDAD, TENEDURÍA DE LIBROS Y AUDITORÍA; CONSULTORÍA FISCAL", Category.CLASS
        ),
        Classification(
            "70", "ACTIVIDADES DE OFICINAS PRINCIPALES; ACTIVIDADES DE CONSULTORÍA DE GESTIÓN", Category.DIVISION
        ),
        Classification("701", "ACTIVIDADES DE OFICINAS PRINCIPALES", Category.GROUP),
        Classification("7010", "ACTIVIDADES DE OFICINAS PRINCIPALES", Category.CLASS),
        Classification("702", "ACTIVIDADES DE CONSULTORÍA DE GESTIÓN", Category.GROUP),
        Classification("7020", "ACTIVIDADES DE CONSULTORÍA DE GESTIÓN", Category.CLASS),
        Classification(
            "71", "ACTIVIDADES DE ARQUITECTURA E INGENIERÍA; ENSAYOS Y ANÁLISIS TÉCNICOS", Category.DIVISION
        ),
        Classification(
            "711",
            "ACTIVIDADES DE ARQUITECTURA E INGENIERÍA Y ACTIVIDADES CONEXAS DE CONSULTORÍA TÉCNICA",
            Category.GROUP,
        ),
        Classification(
            "7110",
            "ACTIVIDADES DE ARQUITECTURA E INGENIERÍA Y ACTIVIDADES CONEXAS DE CONSULTORÍA TÉCNICA",
            Category.CLASS,
        ),
        Classification("712", "ENSAYOS Y ANÁLISIS TÉCNICOS", Category.GROUP),
        Classification("7120", "ENSAYOS Y ANÁLISIS TÉCNICOS", Category.CLASS),
        Classification("72", "INVESTIGACIÓN CIENTÍFICA Y DESARROLLO", Category.DIVISION),
        Classification(
            "721",
            "INVESTIGACIONES  Y DESARROLLO EXPERIMENTAL EN EL CAMPO DE LAS CIENCIAS NATURALES Y LA INGENIERÍA ",
            Category.GROUP,
        ),
        Classification(
            "7210",
            "INVESTIGACIONES  Y DESARROLLO EXPERIMENTAL EN EL CAMPO DE LAS CIENCIAS NATURALES Y LA INGENIERÍA",
            Category.CLASS,
        ),
        Classification(
            "722",
            "INVESTIGACIONES  Y DESARROLLO EXPERIMENTAL EN EL CAMPO DE LAS CIENCIAS SOCIALES Y LAS HUMANIDADES ",
            Category.GROUP,
        ),
        Classification(
            "7220",
            "INVESTIGACIONES  Y DESARROLLO EXPERIMENTAL EN EL CAMPO DE LAS CIENCIAS SOCIALES Y LAS HUMANIDADES",
            Category.CLASS,
        ),
        Classification("73", "PUBLICIDAD Y ESTUDIOS DE MERCADO", Category.DIVISION),
        Classification("731", "PUBLICIDAD", Category.GROUP),
        Classification("7310", "PUBLICIDAD", Category.CLASS),
        Classification("732", "ESTUDIOS DE MERCADO Y ENCUESTAS DE OPINIÓN PÚBLICA", Category.GROUP),
        Classification("7320", "ESTUDIOS DE MERCADO Y ENCUESTAS DE OPINIÓN PÚBLICA", Category.CLASS),
        Classification("74", "OTRAS ACTIVIDADES PROFESIONALES, CIENTÍFICAS Y TÉCNICAS", Category.DIVISION),
        Classification("741", "ACTIVIDADES ESPECIALIZADAS DE DISEÑO", Category.GROUP),
        Classification("7410", "ACTIVIDADES ESPECIALIZADAS DE DISEÑO", Category.CLASS),
        Classification("742", "ACTIVIDADES DE FOTOGRAFÍA", Category.GROUP),
        Classification("7420", "ACTIVIDADES DE FOTOGRAFÍA", Category.CLASS),
        Classification("749", "OTRAS ACTIVIDADES PROFESIONALES, CIENTÍFICAS Y TÉCNICAS N.C.P.", Category.GROUP),
        Classification("7490", "OTRAS ACTIVIDADES PROFESIONALES, CIENTÍFICAS Y TÉCNICAS N.C.P.", Category.CLASS),
        Classification("75", "ACTIVIDADES VETERINARIAS", Category.DIVISION),
        Classification("750", "ACTIVIDADES VETERINARIAS", Category.GROUP),
        Classification("7500", "ACTIVIDADES VETERINARIAS", Category.CLASS),
        Classification("N", "ACTIVIDADES DE SERVICIOS ADMINISTRATIVOS Y DE APOYO", Category.SECTION),
        Classification("77", "ACTIVIDADES DE ALQUILER Y ARRENDAMIENTO", Category.DIVISION),
        Classification("771", "ALQUILER Y ARRENDAMIENTO DE VEHÍCULOS AUTOMOTORES", Category.GROUP),
        Classification("7710", "ALQUILER Y ARRENDAMIENTO DE VEHÍCULOS AUTOMOTORES", Category.CLASS),
        Classification("772", "ALQUILER Y ARRENDAMIENTO DE EFECTOS PERSONALES Y ENSERES DOMESTICOS", Category.GROUP),
        Classification("7721", "ALQUILER Y ARRENDAMIENTO DE EQUIPO RECREATIVO Y DEPORTIVO", Category.CLASS),
        Classification("7722", "ALQUILER DE CINTAS DE VÍDEO Y DISCOS", Category.CLASS),
        Classification(
            "7729", "ALQUILER Y ARRENDAMIENTO DE OTROS EFECTOS PERSONALES Y ENSERES DOMESTICOS", Category.CLASS
        ),
        Classification(
            "773", "ALQUILER Y ARRENDAMIENTO DE OTROS TIPOS DE MAQUINARIA, EQUIPO Y BIENES TANGIBLES", Category.GROUP
        ),
        Classification(
            "7730", "ALQUILER Y ARRENDAMIENTO DE OTROS TIPOS DE MAQUINARIA, EQUIPO Y BIENES TANGIBLES", Category.CLASS
        ),
        Classification(
            "774",
            "ARRENDAMIENTO DE PROPIEDAD INTELECTUAL Y PRODUCTOS SIMILARES, EXCEPTO OBRAS PROTEGIDAS POR DERECHOS DE AUTOR",
            Category.GROUP,
        ),
        Classification(
            "7740",
            "ARRENDAMIENTO DE PROPIEDAD INTELECTUAL Y PRODUCTOS SIMILARES, EXCEPTO OBRAS PROTEGIDAS POR DERECHOS DE AUTOR",
            Category.CLASS,
        ),
        Classification("78", "ACTIVIDADES DE EMPLEO", Category.DIVISION),
        Classification("781", "ACTIVIDADES DE AGENCIAS DE EMPLEO", Category.GROUP),
        Classification("7810", "ACTIVIDADES DE AGENCIAS DE EMPLEO", Category.CLASS),
        Classification("782", "ACTIVIDADES DE AGENCIAS DE EMPLEO TEMPORAL", Category.GROUP),
        Classification("7820", "ACTIVIDADES DE AGENCIAS DE EMPLEO TEMPORAL", Category.CLASS),
        Classification("783", "OTRAS ACTIVIDADES DE DOTACIÓN DE RECURSOS HUMANOS", Category.GROUP),
        Classification("7830", "OTRAS ACTIVIDADES DE DOTACIÓN DE RECURSOS HUMANOS", Category.CLASS),
        Classification(
            "79",
            "ACTIVIDADES DE AGENCIAS DE VIAJES, OPERADORES TURÍSTICOS SERVICIOS DE RESERVA Y ACTIVIDADES CONEXAS",
            Category.DIVISION,
        ),
        Classification("791", "ACTIVIDADES DE AGENCIAS DE VIAJES, OPERADORES TURÍSTICOS", Category.GROUP),
        Classification("7911", "ACTIVIDADES DE AGENCIAS DE VIAJES", Category.CLASS),
        Classification("7912", "ACTIVIDADES DE OPERADORES TURÍSTICOS", Category.CLASS),
        Classification("799", "OTROS SERVICIOS DE RESERVAS Y ACTIVIDADES CONEXAS", Category.GROUP),
        Classification("7990", "OTROS SERVICIOS DE RESERVAS Y ACTIVIDADES CONEXAS", Category.CLASS),
        Classification("80", "ACTIVIDADES DE SEGURIDAD E INVESTIGACIÓN", Category.DIVISION),
        Classification("801", "ACTIVIDADES DE SEGURIDAD", Category.GROUP),
        Classification("8010", "ACTIVIDADES DE SEGURIDAD ", Category.CLASS),
        Classification("802", "ACTIVIDADES DE SERVICIOS DE SISTEMAS DE SEGURIDAD", Category.GROUP),
        Classification("8020", "ACTIVIDADES DE SERVICIOS DE SISTEMAS DE SEGURIDAD", Category.CLASS),
        Classification("803", "ACTIVIDADES DE INVESTIGACIÓN", Category.GROUP),
        Classification("8030", "ACTIVIDADES DE INVESTIGACIÓN", Category.CLASS),
        Classification("81", "ACTIVIDADES DE SERVICIOS A EDIFICIOS Y DE PAISAJISMO", Category.DIVISION),
        Classification("811", "ACTIVIDADES COMBINADAS DE APOYO A INSTALACIONES", Category.GROUP),
        Classification("8110", "ACTIVIDADES COMBINADAS DE APOYO A INSTALACIONES", Category.CLASS),
        Classification("812", "ACTIVIDADES DE LIMPIEZA", Category.GROUP),
        Classification("8121", "LIMPIEZA GENERAL DE EDIFICIOS", Category.CLASS),
        Classification(
            "8129", "OTRAS ACTIVIDADES DE LIMPIEZA DE EDIFICIOS E INSTALACIONES INDUSTRIALES N.C.P.", Category.CLASS
        ),
        Classification("813", "ACTIVIDADES DE PAISAJISMO Y SERVICIOS DE MANTENIMIENTO CONEXOS", Category.GROUP),
        Classification("8130", "ACTIVIDADES DE PAISAJISMO Y SERVICIOS DE MANTENIMIENTO CONEXOS", Category.CLASS),
        Classification(
            "82",
            "ACTIVIDADES ADMINISTRATIVAS Y DE APOYO DE OFICINA Y OTRAS ACTIVIDADES DE APOYO A LAS EMPRESAS",
            Category.DIVISION,
        ),
        Classification("821", "ACTIVIDADES ADMINISTRATIVAS Y DE APOYO DE OFICINA", Category.GROUP),
        Classification("8211", "ACTIVIDADES COMBINADAS DE SERVICIOS ADMINISTRATIVOS DE OFICINA", Category.CLASS),
        Classification(
            "8219",
            "FOTOCOPIADO, PREPARACIÓN DE DOCUMENTOS Y OTRAS ACTIVIDADES ESPECIALIZADAS DE APOYO DE OFICINA",
            Category.CLASS,
        ),
        Classification("822", "ACTIVIDADES DE CENTROS DE LLAMADAS", Category.GROUP),
        Classification("8220", "ACTIVIDADES DE CENTROS DE LLAMADAS", Category.CLASS),
        Classification("823", "ORGANIZACIÓN DE CONVENCIONES Y EXPOSICIONES COMERCIALES", Category.GROUP),
        Classification("8230", "ORGANIZACIÓN DE CONVENCIONES Y EXPOSICIONES COMERCIALES", Category.CLASS),
        Classification("829", "ACTIVIDADES DE SERVICIOS DE APOYO A LAS EMPRESAS N.C.P.", Category.GROUP),
        Classification(
            "8291", "ACTIVIDADES DE AGENCIAS DE COBRO Y AGENCIAS DE CALIFICACIÓN CREDITICIA", Category.CLASS
        ),
        Classification("8292", "ACTIVIDADES DE ENVASADO Y EMPAQUETADO ", Category.CLASS),
        Classification("8299", "OTRAS ACTIVIDADES DE SERVICIOS DE APOYO A LAS EMPRESAS N.C.P.", Category.CLASS),
        Classification(
            "O",
            "ADMISTRACIÓN PÚBLICA Y DEFENSA; PLANES DE SEGURIDAD SOCIAL DE AFILIACIÓN OBLIGATORIA",
            Category.SECTION,
        ),
        Classification(
            "84",
            "ADMINISTRACIÓN PÚBLICA Y DEFENSA; PLANES DE SEGURIDAD SOCIAL DE AFILIACION OBLIGATORIA",
            Category.DIVISION,
        ),
        Classification(
            "841",
            "ADMINISTRACIÓN DEL ESTADO Y APLICACIÓN DE LA POLÍTICA ECONÓMICA Y SOCIAL DE LA COMUNIDAD",
            Category.GROUP,
        ),
        Classification("8411", "ACTIVIDADES DE LA ADMINISTRACIÓN PÚBLICA EN GENERAL", Category.CLASS),
        Classification(
            "8412",
            "REGULACIÓN DE LAS ACTIVIDADES DE ORGANISMOS QUE PRESTAN SERVICIOS SANITARIOS, EDUCATIVOS, CULTURALES Y OTROS SERVICIOS SOCIALES, EXCEPTO SERVICIOS DE SEGURIDAD SOCIAL",
            Category.CLASS,
        ),
        Classification("8413", "REGULACIÓN Y FACILITACIÓN DE LA ACTIVIDAD ECONÓMICA", Category.CLASS),
        Classification(
            "8415",
            "ADMINISTRACIÓN DE ACTIVIDADES RELACIONADAS CON LOS CENSOS DE POBLACIÓN Y VIVIENDAS (CPV)",
            Category.CLASS,
        ),
        Classification("842", "PRESTACIÓN DE SERVICIOS A LA COMUNIDAD EN GENERAL", Category.GROUP),
        Classification("8421", "RELACIONES EXTERIORES", Category.CLASS),
        Classification("8422", "ACTIVIDADES DE DEFENSA", Category.CLASS),
        Classification("8423", "ACTIVIDADES DE MANTENIMIENTO DEl ORDEN PÚBLICO Y DE SEGURIDAD", Category.CLASS),
        Classification("843", "ACTIVIDADES DE PLANES DE SEGURIDAD SOCIAL DE AFILIACIÓN OBLIGATORIA", Category.GROUP),
        Classification("8430", "ACTIVIDADES DE PLANES DE SEGURIDAD SOCIAL DE AFILIACIÓN OBLIGATORIA", Category.CLASS),
        Classification("P", "EDUCACIÓN", Category.SECTION),
        Classification("85", "EDUCACIÓN", Category.DIVISION),
        Classification("851", "EDUCACIÓN PREESCOLAR Y PRIMARIA", Category.GROUP),
        Classification("8510", "EDUCACIÓN PREESCOLAR ", Category.CLASS),
        Classification("8511", "EDUCACIÓN PRIMARIA", Category.CLASS),
        Classification("8513", "EDUCACIÓN PRIMARIA PARA ADULTOS", Category.CLASS),
        Classification("852", "EDUCACIÓN SECUNDARIA", Category.GROUP),
        Classification("8521", "EDUCACIÓN SECUNDARIA DE FORMACIÓN  GENERAL Y PREUNIVERSITARIO", Category.CLASS),
        Classification("8522", "EDUCACIÓN SECUNDARIA DE FORMACIÓN TÉCNICA Y PROFESIONAL", Category.CLASS),
        Classification(
            "8523", "EDUCACIÓN SECUNDARIA DE FORMACIÓN  GENERAL Y PREUNIVERSITARIO PARA ADULTOS", Category.CLASS
        ),
        Classification("853", "EDUCACIÓN SUPERIOR", Category.GROUP),
        Classification("8530", "EDUCACIÓN SUPERIOR", Category.CLASS),
        Classification("854", "OTRAS ACTIVIDADES EDUCACIONALES", Category.GROUP),
        Classification("8541", "EDUCACIÓN DEPORTIVA Y RECREATIVA", Category.CLASS),
        Classification("8542", "EDUCACIÓN CULTURAL", Category.CLASS),
        Classification("8549", "OTRAS ACTIVIDADES EDUCACIONALES N.C.P.", Category.CLASS),
        Classification("855", "ACTIVIDADES DE APOYO A LA EDUCACiÓN", Category.GROUP),
        Classification("8550", "ACTIVIDADES DE APOYO A LA EDUCACiÓN", Category.CLASS),
        Classification("856", "EDUCACIÓN ESPECIAL Y MIXTA", Category.GROUP),
        Classification("8561", "EDUCACIÓN ESPECIAL", Category.CLASS),
        Classification("8562", "EDUCACIÓN MIXTA", Category.CLASS),
        Classification("Q", "ACTIVIDADES DE ATENCIÓN DE LA SALUD HUMANA Y DE ASISTENCIA SOCIAL  ", Category.SECTION),
        Classification("86", "ACTIVIDADES DE ATENCIÓN DE LA SALUD HUMANA ", Category.DIVISION),
        Classification("861", "ACTIVIDADES DE HOSPITALES", Category.GROUP),
        Classification("8610", "ACTIVIDADES DE HOSPITALES", Category.CLASS),
        Classification("862", "ACTIVIDADES DE MÉDICOS Y ODONTÓLOGOS", Category.GROUP),
        Classification("8620", "ACTIVIDADES DE MÉDICOS Y ODONTÓLOGOS", Category.CLASS),
        Classification("869", "OTRAS ACTIVIDADES DE ATENCIÓN DE LA SALUD HUMANA", Category.GROUP),
        Classification("8690", "OTRAS ACTIVIDADES DE ATENCIÓN DE LA SALUD HUMANA", Category.CLASS),
        Classification("87", "ACTIVIDADES DE ATENCIÓN EN INSTITUCIONES", Category.DIVISION),
        Classification("871", "ACTIVIDADES DE ATENCIÓN DE ENFERMERÍA EN INSTITUCIONES", Category.GROUP),
        Classification("8710", "ACTIVIDADES DE ATENCIÓN DE ENFERMERÍA EN INSTITUCIONES", Category.CLASS),
        Classification(
            "872",
            "ACTIVIDADES DE ATENCIÓN EN INSTITUCIONES PARA PERSONAS CON RETRASO MENTAL, ENFERMOS MENTALES Y TOXICÓMANOS",
            Category.GROUP,
        ),
        Classification(
            "8720",
            "ACTIVIDADES DE ATENCIÓN EN INSTITUCIONES PARA PERSONAS CON RETRASO MENTAL, ENFERMOS MENTALES Y TOXICÓMANOS",
            Category.CLASS,
        ),
        Classification(
            "873",
            "ACTIVIDADES DE ATENCIÓN EN INSTITUCIONES PARA PERSONAS  DE EDAD Y PERSONAS CON DISCAPACIDAD",
            Category.GROUP,
        ),
        Classification(
            "8730",
            "ACTIVIDADES DE ATENCIÓN EN INSTITUCIONES PARA PERSONAS DE EDAD Y PERSONAS CON DISCAPACIDAD",
            Category.CLASS,
        ),
        Classification("879", "OTRAS ACTIVIDADES DE ATENCIÓN EN INSTITUCIONES", Category.GROUP),
        Classification("8790", "OTRAS ACTIVIDADES DE ATENCIÓN EN INSTITUCIONES", Category.CLASS),
        Classification("88", "ACTIVIDADES DE ASISTENCIA SOCIAL SIN ALOJAMIENTO", Category.DIVISION),
        Classification(
            "881",
            "ACTIVIDADES DE ASISTENCIA SOCIAL SIN ALOJAMIENTO PARA PERSONAS DE EDAD Y PERSONAS CON DISCAPACIDAD",
            Category.GROUP,
        ),
        Classification(
            "8810",
            "ACTIVIDADES DE ASISTENCIA SOCIAL SIN ALOJAMIENTO PARA PERSONAS DE EDAD Y PERSONAS CON DISCAPACIDAD",
            Category.CLASS,
        ),
        Classification("889", "OTRAS ACTIVIDADES DE ASISTENCIA SOCIAL SIN ALOJAMIENTO", Category.GROUP),
        Classification("8890", "OTRAS ACTIVIDADES DE ASISTENCIA SOCIAL SIN ALOJAMIENTO", Category.CLASS),
        Classification("R", "ACTIVIDADES ARTISTICAS, DE ENTRETENIMIENTO Y RECREATIVAS", Category.SECTION),
        Classification("90", "ACTIVIDADES CREATIVAS, ARTÍSTICAS Y DE ENTRETENIMIENTO", Category.DIVISION),
        Classification("900", "ACTIVIDADES CREATIVAS, ARTÍSTICAS Y DE ENTRETENIMIENTO", Category.GROUP),
        Classification("9000", "ACTIVIDADES CREATIVAS, ARTÍSTICAS Y DE ENTRETENIMIENTO", Category.CLASS),
        Classification(
            "91", "ACTIVIDADES DE BIBLIOTECAS, ARCHIVOS Y MUSEOS Y OTRA ACTIVIDADES CULTURALES ", Category.DIVISION
        ),
        Classification(
            "910", "ACTIVIDADES DE BIBLIOTECAS, ARCHIVOS Y MUSEOS Y OTRA ACTIVIDADES CULTURALES ", Category.GROUP
        ),
        Classification("9101", "ACTIVIDADES DE BIBLIOTECAS Y ARCHIVOS", Category.CLASS),
        Classification("9102", "ACTIVIDADES DE MUSEOS Y GESTIÓN DE LUGARES Y EDIFICIOS HISTÓRICOS", Category.CLASS),
        Classification("9103", "ACTIVIDADES DE JARDINES BOTÁNICOS Y ZOOLÓGICOS Y RESERVAS NATURALES", Category.CLASS),
        Classification("92", "ACTIVIDADES DE JUEGOS DE AZAR Y APUESTAS", Category.DIVISION),
        Classification("920", "ACTIVIDADES DE JUEGOS DE AZAR Y APUESTAS", Category.GROUP),
        Classification("9200", "ACTIVIDADES DE JUEGOS DE AZAR Y APUESTAS", Category.CLASS),
        Classification("93", "ACTIVIDADES DEPORTIVAS, DE ESPARCIMIENTO Y RECREATIVAS ", Category.DIVISION),
        Classification("931", "ACTIVIDADES DEPORTIVAS", Category.GROUP),
        Classification("9311", "GESTIÓN DE INSTALACIONES DEPORTIVAS", Category.CLASS),
        Classification("9312", "ACTIVIDADES DE CLUBES DEPORTIVOS", Category.CLASS),
        Classification("9319", "OTRAS ACTIVIDADES DEPORTIVAS", Category.CLASS),
        Classification("932", "OTRAS ACTIVIDADES DE ESPARCIMIENTO Y RECREATIVAS  ", Category.GROUP),
        Classification("9321", "ACTIVIDADES DE PARQUES DE ATRACCIONES Y PARQUES TEMÁTICOS", Category.CLASS),
        Classification("9329", "OTRAS ACTIVIDADES DE ESPARCIMIENTO Y RECREATIVAS N.C.P  ", Category.CLASS),
        Classification("S", "OTRAS ACTIVIDADES DE SERVICIOS", Category.SECTION),
        Classification("94", "ACTIVIDADES DE ASOCIACIONES", Category.DIVISION),
        Classification("941", "ACTIVIDADES DE ASOCIACIONES EMPRESARIALES PROFESIONALES", Category.GROUP),
        Classification("9411", "ACTIVIDADES DE ASOCIACIONES EMPRESARIALES Y DE EMPLEADORAS", Category.CLASS),
        Classification("9412", "ACTIVIDADES DE ASOCIACIONES PROFESIONALES", Category.CLASS),
        Classification("942", "ACTIVIDADES DE SINDICATOS", Category.GROUP),
        Classification("9420", "ACTIVIDADES DE SINDICATOS", Category.CLASS),
        Classification("949", "ACTIVIDADES DE OTRAS ASOCIACIONES", Category.GROUP),
        Classification("9491", "ACTIVIDADES DE ORGANIZACIONES RELIGIOSAS  ", Category.CLASS),
        Classification("9492", "ACTIVIDADES DE ORGANIZACIONES POLÍTICAS  ", Category.CLASS),
        Classification("9499", "ACTIVIDADES DE OTRAS ASOCIACIONES N.C.P.", Category.CLASS),
        Classification(
            "95", "REPARACIÓN DE ORDENADORES Y DE EFECTOS PERSONALES Y ENSERES DOMÉSTICOS", Category.DIVISION
        ),
        Classification("951", "REPARACIÓN DE ORDENADORES Y EQUIPO DE COMUNICACIONES", Category.GROUP),
        Classification("9511", "REPARACIÓN DE ORDENADORES Y EQUIPO PERIFÉRICO", Category.CLASS),
        Classification("9512", "REPARACIÓN DE EQUIPO DE COMUNICACIONES", Category.CLASS),
        Classification("952", "REPARACIÓN DE EFECTOS PERSONALES Y ENSERES DOMÉSTICOS", Category.GROUP),
        Classification("9521", "REPARACIÓN DE APARATOS ELECTRÓNICOS DE CONSUMO", Category.CLASS),
        Classification(
            "9522", "REPARACIÓN DE APARATOS DE USO DOMÉSTICO Y EQUIPO DOMÉSTICO Y DE JARDINERÍA", Category.CLASS
        ),
        Classification("9523", "REPARACIÓN DE CALZADO Y ARTÍCULOS DE CUERO", Category.CLASS),
        Classification("9524", "REPARACIÓN DE MUEBLES Y ACCESORIOS DOMÉSTICOS", Category.CLASS),
        Classification("9529", "REPARACIÓN DE OTROS EFECTOS PERSONALES Y ENSERES DOMÉSTICOS", Category.CLASS),
        Classification("96", "OTRAS ACTIVIDADES DE SERVICIOS PERSONALES", Category.DIVISION),
        Classification("960", "OTRAS ACTIVIDADES DE SERVICIOS PERSONALES", Category.GROUP),
        Classification(
            "9601", "LAVADO Y LIMPIEZA INCLUÍDA LA LIMPIEZA EN SECO, DE PRODUCTOS TEXTILES Y DE PIEL", Category.CLASS
        ),
        Classification("9602", "PELUQUERÍA Y OTROS TRATAMIENTOS DE BELLEZA", Category.CLASS),
        Classification("9603", "POMPAS FÚNEBRES Y ACTIVIDADES CONEXAS", Category.CLASS),
        Classification("9609", "OTRAS ACTIVIDADES DE SERVICIOS PERSONALES N.C.P.", Category.CLASS),
        Classification(
            "T",
            "ACTIVIDADES DE LOS HOGARES COMO EMPLEADORES; ACTIVIDADES NO DIFERENCIADAS DE LOS HOGARES COMO PRODUCTORES DE BIENES Y SERVICIOS PARA USO PROPIO",
            Category.SECTION,
        ),
        Classification("97", "ACTIVIDADES DE LOS HOGARES COMO EMPLEADORES DE PERSONAL DOMÉSTICO", Category.DIVISION),
        Classification("970", "ACTIVIDADES DE LOS HOGARES COMO EMPLEADORES DEL PERSONAL DOMÉSTICO", Category.GROUP),
        Classification("9700", "ACTIVIDADES DE LOS HOGARES COMO EMPLEADORES DE PERSONAL DOMÉSTICO  ", Category.CLASS),
        Classification(
            "98",
            "ACTIVIDADES NO DIFERENCIADAS DE LOS HOGARES COMO PRODUCTORES DE BIENES Y SERVICIOS PARA USO PROPIO",
            Category.DIVISION,
        ),
        Classification(
            "981",
            "ACTIVIDADES NO DIFERENCIADAS DE LOS HOGARES COMO PRODUCTORES DE BIENES PARA USO PROPIO",
            Category.GROUP,
        ),
        Classification(
            "9810",
            "ACTIVIDADES NO DIFERENCIADAS DE LOS HOGARES COMO PRODUCTORES DE BIENES PARA USO PROPIO",
            Category.CLASS,
        ),
        Classification(
            "982",
            "ACTIVIDADES NO DIFERENCIADAS DE LOS HOGARES COMO PRODUCTORES SERVICIOS PARA USO PROPIO",
            Category.GROUP,
        ),
        Classification(
            "9820",
            "ACTIVIDADES NO DIFERENCIADAS DE LOS HOGARES COMO PRODUCTORES SERVICIOS PARA USO PROPIO",
            Category.CLASS,
        ),
        Classification("U", "ACTIVIDADES DE ORGANIZACIONES Y ÓRGANOS EXTRATERRITORIALES", Category.SECTION),
        Classification("99", "ACTIVIDADES DE ORGANIZACIONES Y ÓRGANOS EXTRATERRITORIALES", Category.DIVISION),
        Classification("990", "ACTIVIDADES DE ORGANIZACIONES Y ÓRGANOS EXTRATERRITORIALES", Category.GROUP),
    ],
)
