## Python support for Ball Aerospace COSMOS v5

---

This project allows accessing the COSMOS v5 API from the python programming language.
Additional functionality and support will be added over time.

---
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)


## Installation:

```
pip install cosmosc2
```

See the docs, examples for usage

## Create a Virtual Python Environment

`cd` to your project directory and run `virtualenv` to create the new virtual environment.

The following commands will create a new virtual environment under `cosmosc2/venv`.

```
cd cosmosc2
py -m pip install venv
py -m venv venv
```

### Activate the Environment

Now that we have a virtual environment, we need to activate it.

```
.\venv\Scripts\activate
```

After you activate the environment, your command prompt will be modified to reflect the change.

### Development requirements-dev.txt

Althought requests is required, when doing development work it is helpful to test with pytest, use black, and coverage. These can be found in `requirements-dev.txt`

```
> py -m pip install -r requirements-dev.txt
```

### Add Libraries and Create a requirements.txt File

After you activate the virtual environment, you can add packages to it using `pip`. You can also create a description of your dependencies using `pip`.

The following command creates a file called `requirements.txt` that enumerates the installed packages.

```
py -m pip freeze > requirements.txt
```

This file can then be used by collaborators to update virtual environments using the following command.

```
py -m pip install -r requirements.txt
```

### Deactivate the Environment

To return to normal system settings, use the deactivate command.

```
deactivate
```

After you issue this command, you’ll notice that the command prompt returns to normal.