# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['vmware_aria_operations_integration_sdk',
 'vmware_aria_operations_integration_sdk.adapter_template',
 'vmware_aria_operations_integration_sdk.api',
 'vmware_aria_operations_integration_sdk.validation']

package_data = \
{'': ['*']}

install_requires = \
['GitPython==3.1.30',
 'aenum==3.1.11',
 'docker==6.0.0',
 'httpx==0.23.0',
 'importlib-metadata>=5.0.0,<6.0.0',
 'importlib-resources>=5.10.0,<6.0.0',
 'jsonschema-spec>=0.1.2,<0.2.0',
 'lxml==4.9.2',
 'openapi-core==0.15.0',
 'openapi-schema-validator==0.2.3',
 'openapi-spec-validator==0.4.0',
 'pillow>=9.3.0,<10.0.0',
 'prompt-toolkit==3.0.29',
 'sen>=0.6.2,<0.7.0',
 'validators>=0.20.0,<0.21.0',
 'vmware-aria-operations-integration-sdk-lib>=0.5.0,<0.6.0',
 'xmlschema>=2.1.1,<3.0.0']

entry_points = \
{'console_scripts': ['mp-build = '
                     'vmware_aria_operations_integration_sdk.mp_build:main',
                     'mp-init = '
                     'vmware_aria_operations_integration_sdk.mp_init:main',
                     'mp-test = '
                     'vmware_aria_operations_integration_sdk.mp_test:main']}

setup_kwargs = {
    'name': 'vmware-aria-operations-integration-sdk',
    'version': '0.5.0b3',
    'description': 'A set of tools to help users create, test, and build containerized management packs for VMware Aria Operations',
    'long_description': 'VMware Aria Operations Integration SDK\n=====================\n\nWelcome to the VMware Aria Operations Integration SDK. \n\nWhere should I start?\n* If you want to get started creating your first Management Pack, or don\'t know where to start, read the \'Get Started\' tutorial below.\n* If you\'d like an introduction to VMware Aria Operations, Management Packs, and this SDK, [read the introduction](doc/introduction.md).\n* All documentation is available from the [contents](doc/contents.md) page.\n\n## Get Started\n\nThis guide will walk through setting up the SDK and using the SDK\nto create, test, and install a simple Management Pack (integration) onto VMware Aria Operations.\n\nContents\n* [Requirements](#requirements)\n* [Installation](#installation)\n* [Creating a Management Pack](#creating-a-management-pack)\n* [Testing a Management Pack](#testing-a-management-pack)\n* [Building and Installing a Management Pack](#building-and-installing-a-management-pack)\n\n### Requirements\n\n#### Operating System:\nThe VMware Aria Operations Integration SDK has been tested in the following OSes:\n* Windows 10\n* Windows 11\n* macOS Monterey\n* Debian Linux\n* Fedora Linux\n    \nOther operating systems may be compatible.\n\n#### VMware Aria Operations\nThe Management Packs generated by the VMware Aria Operations Integration SDK will only run on versions that supports containerized Management Packs. Currently, this is limited to on-prem installs, version 8.10 or later.\nIn addition, at least one Cloud Proxy (also version 8.10 or later) must be set up in VMware Aria Operations, as containerized Management Packs must be run on a Cloud Proxy collector.\n\n#### Dependencies\n* Docker 20.10.0 or later. Updating to the latest stable version is recommended. For instructions on installing Docker,\n  go to [Docker\'s installation documentation](https://docs.docker.com/engine/install/), choose the OS you need and\n  follow the instructions provided.\n* Python3 3.9.0 or later. Earlier versions of Python3 may also work, but updating to the latest stable version is\n  recommended. Python 3.8 and earlier (including Python2) are not supported. For instructions on installing Python, go\n  to [Python\'s installation documentation](https://wiki.python.org/moin/BeginnersGuide/Download), choose the OS you need\n  and follow the instructions provided.\n* Pip. If Python3 is installed, pip is most likely also installed. For instructions on installing Pip, go\n  to [Pip\'s installation documentation](https://pip.pypa.io/en/stable/installation/), and follow the instructions\n  provided.\n* Git 2.35.0 or later. Updating to the latest stable version is recommended. \n  For instructions in installing git, go to [Git\'s installation documentation](https://git-scm.com/downloads),\n  choose the OS you need and follow the instructions provided.\n\n[//]: # (TODO: Add this section back in once we support them)\n[//]: # (#### Optional Prerequisites)\n[//]: # (* Java. Java is only required for building Java Management Packs. We recommend the latest version of the [Azul Zulu SDK]&#40;https://www.azul.com/downloads/?package=jdk#download-openjdk&#41;.)\n[//]: # (* Powershell. Powershell is only required for building Powershell Management Packs. See [Microsoft\'s installation instructions for PowerShell]&#40;https://docs.microsoft.com/en-us/powershell/scripting/install/installing-powershell?view=powershell-7.2&#41;.)\n[//]: # (> Note: Creating Java and Powershell Management Packs is disabled for the Beta)\n\n### Installation\n\nTo install the SDK, use `pip` to install into the global Python environment, or `pipx` to install into a isolated environment.\n```sh\npython3 -m pip install vmware-aria-operations-integration-sdk\n```\n\n### Creating a Management Pack\nAfter the SDK is installed, create a new project, by running `mp-init`. This tool asks a series of questions that guides\nthe creation of a new management pack project. \n\n\n1. `Enter a path for the project (where code for collection, metadata, and content reside). Path:`\n\n    The path can be an absolute path, or a path relative to the directory `mp-init` was run from. The path should end in an empty\n    or non-existing directory. If the directory does not exist, it will be created. This directory will contain a new Management\n    Pack project.\n\n2. `Management Pack display name`\n\n    The Management Pack display name will show up in VMware Aria Operations (**Data Sources &rarr; Integrations &rarr;\n    Repository**), or when adding an account.\n\n    ![Integration Card for the \'TestAdapter\' Management Pack](doc/test-adapter-integration-card.png)\n\n    *This Management Pack\'s display name is \'TestAdapter\', and uses the default icon*\n\n3. `Management Pack adapter key`\n\n    This field is used internally to identify the Management Pack and Adapter Kind. By default, it is set to the \n    Management Pack display name with special characters and whitespace stripped from it.\n\n4. `Management Pack description`\n\n    This field should describe what the Management Pack will do or monitor.\n\n5. `Management Pack vendor`\n\n   The vendor field shows up in the UI under \'About\' on the Integration Card.\n\n   ![About popup for the \'TestAdapter\' Management Pack](doc/test-adapter-about.png)\n\n   *This Management Pack\'s vendor is \'VMware\'*\n\n6. `Enter a path to a EULA text file, or leave blank for no EULA`\n\n   VMware Aria Operations requires a EULA file to be present in a Management Pack. If one isn\'t provided, a stub EULA file (`eula.txt` in\n   the root project directory) will be added to the project which reads:\n    ```\n    There is no EULA associated with this Management Pack.\n    ```\n\n7. `Enter a path to the Management Pack icon file, or leave blank for no icon`\n\n   The icon is used in the VMware Aria Operations UI if present. If it is not present, a default icon will be used. The icon file must be\n   png format and 256x256 px. An icon file can be added later by copying the icon to the root project directory and\n   setting the value of the `"pak_icon"` key to the icon\'s file name in the `manifest.txt` file.\n\n8. `Select a language for the adapter. Supported languages are [...]`\n\n   Supported languages are listed. Once selected, the project will be generated, including a template adapter in the\n   selected language. The template adapter collects several objects and metrics from the container that the adapter \n   is running in, and can be used as a starting point for creating a new adapter.\n\nFor complete documentation of the `mp-init` tool see the [MP Initialization Tool Documentation](doc/mp-init.md).\n\n### Testing a Management Pack\n\nIn the Management Pack directory, the installation script writes a `requirements.txt` file containing the version of the\nSDK used to generate the project, and installs the SDK into a virtual environment named `venv`. Note that the packages\nin `requirements.txt` are _not_ installed into the adapter. To add a package to the adapter, specify it in the file\n`adapter_requirements.txt`. \n\nTo use the SDK, navigate to the newly-generated project directory and activate the virtual environment:\n\nFor Mac and Linux:\n```sh\nsource venv/bin/activate\n```\n(This script is written for the bash shell. If you use the csh or fish shells, there are alternate activate.csh and activate.fish scripts you should use instead.)\nFor Windows:\n```cmd\nvenv\\Scripts\\activate.bat\n```\nTo exit the virtual environment, run `deactivate` in the virtual environment.\n\nTo test a project, run `mp-test`  in the virtual environment.\n\nIf `mp-test` is run from anywhere outside of a root project directory, the tool will prompt to choose a project, and will\ntest the selected project. If the tool is run from a project directory, the tool will automatically test that project.\n\n`mp-test` will ask for a _connection_. No connections should exist, so choose **New Connection**. The test tool then\nreads the `conf/describe.xml` file to find the connection parameters and credentials required for a connection, and\nprompts for each. This is similar to creating a new _Adapter Instance_ in the VMware Aria Operations UI. Connections are automatically\nsaved per project, and can be reused when re-running the `mp-test` tool.\n\n> Note: In the template project, the only connection parameter is `ID`, and because it connects to the container it is running on, this parameter is not necessary; it is only there as an example, and can be set to any value. The template also implements an example Test Connection. If a Test Connection is run (see below), with the `ID` set to the text `bad`, then the Test Connection will fail.\n\nThe test tool also asks for the method to test. There are four options:\n\n* Test Connection - This call tests the connection and returns either an error message if the connection failed, or an\n  empty json object if the connection succeeded.\n* Collect - This call test the collection, and returns objects, metrics, properties, events, and relationships.\n* Endpoint URLs - This returns a list (possibly empty) of URLs that have distinct SSL certificates that VMware Aria Operations can ask\n  the end user to import into the TrustStore.\n* Version - This returns\n  the [VMware Aria Operations Collector API](vmware_aria_operations_integration_sdk/api/vmware-aria-operations-collector-fwk2.json) version the\n  adapter implements. The implementation of this method is not generally handled by the developer.\n\nFor more information on these endpoints, see\nthe [Swagger API documentation](vmware_aria_operations_integration_sdk/api/vmware-aria-operations-collector-fwk2.json). Each\nresponse is validated against the API.\n\nFor complete documentation of the `mp-test` tool see the [MP Test Tool Documentation](doc/mp-test.md).\n\n### Building and Installing a Management Pack\nTo build a project, run `mp-build`  in the virtual environment.\n\nIf `mp-build` is run from anywhere outside of a root project directory, the tool will prompt to choose a project, and will\nbuild the selected project. If the tool is run from a project directory, the tool will automatically build that\nproject.\n\nOnce the project is selected (if necessary), the tool will build the management pack and emit a `pak` file which can be \ninstalled on VMware Aria Operations. The `pak` file will be located in the project directory.\n\nTo install the `pak` file, in VMware Aria Operations navigate to **Data Sources &rarr; Integrations &rarr;\nRepository** and click `ADD`. Select and upload the generated `pak` file, accept the README, and install the management pack.\n\nTo configure the management pack, VMware Aria Operations navigate to **Data Sources &rarr; Integrations &rarr;\nAccounts** and click `ADD ACCOUNT`. Select the newly-installed management pack and configure the required fields. For \n`Collector/Group`, make sure that a cloud proxy collector is selected. Click `VALIDATE CONNECTION` to test the connection. \nIt should return successfully, then click `ADD`.\n\nBy default, a collection will run every 5 minutes. The first collection should happen immediately, however newly-created\nobjects cannot have metrics, properties, and events added to them. After the second collection, approximately five\nminutes later, the objects\' metrics, properties, and events should appear. These can be checked by navigating to **\nEnvironment &rarr; Object Browser &rarr; All Objects** and expanding the Adapter and associated object types and object.\n\n![CPU Idle Time](doc/test-adapter-cpu-idle-time.png)\n*The CPU object\'s `idle-time` metric in a Management Pack named `QAAdapterName`.*\n\nFor complete documentation of the `mp-build` tool see the [MP Build Tool Documentation](doc/mp-build.md).\n\n## Contributing\n\nThe vmware-aria-operations-integration-sdk project team welcomes contributions from the community. Before you start\nworking with this project please read and sign our Contributor License Agreement (https://cla.vmware.com/cla/1/preview).\nIf you wish to contribute code and you have not signed our Contributor Licence Agreement (CLA), our bot will prompt you\nto do so when you open a Pull Request. For any questions about the CLA process, please refer to our\n[FAQ](https://cla.vmware.com/faq).\n\n## License\n\nThis project is licensed under the APACHE-2 License.\n',
    'author': 'Kyle Rokos',
    'author_email': 'krokos@vmware.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/vmware/vrealize-operations-integration-sdk',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
