VMware Aria Operations Integration SDK
=====================

Welcome to the VMware Aria Operations Integration SDK. 

Where should I start?
* If you want to get started creating your first Management Pack, or don't know where to start, read the 'Get Started' tutorial below.
* If you'd like an introduction to VMware Aria Operations, Management Packs, and this SDK, [read the introduction](doc/introduction.md).
* All documentation is available from the [contents](doc/contents.md) page.

## Get Started

This guide will walk through setting up the SDK and using the SDK
to create, test, and install a simple Management Pack (integration) onto VMware Aria Operations.

Contents
* [Requirements](#requirements)
* [Installation](#installation)
* [Creating a Management Pack](#creating-a-management-pack)
* [Testing a Management Pack](#testing-a-management-pack)
* [Building and Installing a Management Pack](#building-and-installing-a-management-pack)

### Requirements

#### Operating System:
The VMware Aria Operations Integration SDK has been tested in the following OSes:
* Windows 10
* Windows 11
* macOS Monterey
* Debian Linux
* Fedora Linux
    
Other operating systems may be compatible.

#### VMware Aria Operations
The Management Packs generated by the VMware Aria Operations Integration SDK will only run on versions that supports containerized Management Packs. Currently, this is limited to on-prem installs, version 8.10 or later.
In addition, at least one Cloud Proxy (also version 8.10 or later) must be set up in VMware Aria Operations, as containerized Management Packs must be run on a Cloud Proxy collector.

#### Dependencies
* Docker 20.10.0 or later. Updating to the latest stable version is recommended. For instructions on installing Docker,
  go to [Docker's installation documentation](https://docs.docker.com/engine/install/), choose the OS you need and
  follow the instructions provided.
* Python3 3.9.0 or later. Earlier versions of Python3 may also work, but updating to the latest stable version is
  recommended. Python 3.8 and earlier (including Python2) are not supported. For instructions on installing Python, go
  to [Python's installation documentation](https://wiki.python.org/moin/BeginnersGuide/Download), choose the OS you need
  and follow the instructions provided.
* Pip. If Python3 is installed, pip is most likely also installed. For instructions on installing Pip, go
  to [Pip's installation documentation](https://pip.pypa.io/en/stable/installation/), and follow the instructions
  provided.
* Git 2.35.0 or later. Updating to the latest stable version is recommended. 
  For instructions in installing git, go to [Git's installation documentation](https://git-scm.com/downloads),
  choose the OS you need and follow the instructions provided.

[//]: # (TODO: Add this section back in once we support them)
[//]: # (#### Optional Prerequisites)
[//]: # (* Java. Java is only required for building Java Management Packs. We recommend the latest version of the [Azul Zulu SDK]&#40;https://www.azul.com/downloads/?package=jdk#download-openjdk&#41;.)
[//]: # (* Powershell. Powershell is only required for building Powershell Management Packs. See [Microsoft's installation instructions for PowerShell]&#40;https://docs.microsoft.com/en-us/powershell/scripting/install/installing-powershell?view=powershell-7.2&#41;.)
[//]: # (> Note: Creating Java and Powershell Management Packs is disabled for the Beta)

### Installation

To install the SDK, use `pip` to install into the global Python environment, or `pipx` to install into a isolated environment.
```sh
python3 -m pip install vmware-aria-operations-integration-sdk
```

### Creating a Management Pack
After the SDK is installed, create a new project, by running `mp-init`. This tool asks a series of questions that guides
the creation of a new management pack project. 


1. `Enter a path for the project (where code for collection, metadata, and content reside). Path:`

    The path can be an absolute path, or a path relative to the directory `mp-init` was run from. The path should end in an empty
    or non-existing directory. If the directory does not exist, it will be created. This directory will contain a new Management
    Pack project.

2. `Management Pack display name`

    The Management Pack display name will show up in VMware Aria Operations (**Data Sources &rarr; Integrations &rarr;
    Repository**), or when adding an account.

    ![Integration Card for the 'TestAdapter' Management Pack](doc/test-adapter-integration-card.png)

    *This Management Pack's display name is 'TestAdapter', and uses the default icon*

3. `Management Pack adapter key`

    This field is used internally to identify the Management Pack and Adapter Kind. By default, it is set to the 
    Management Pack display name with special characters and whitespace stripped from it.

4. `Management Pack description`

    This field should describe what the Management Pack will do or monitor.

5. `Management Pack vendor`

   The vendor field shows up in the UI under 'About' on the Integration Card.

   ![About popup for the 'TestAdapter' Management Pack](doc/test-adapter-about.png)

   *This Management Pack's vendor is 'VMware'*

6. `Enter a path to a EULA text file, or leave blank for no EULA`

   VMware Aria Operations requires a EULA file to be present in a Management Pack. If one isn't provided, a stub EULA file (`eula.txt` in
   the root project directory) will be added to the project which reads:
    ```
    There is no EULA associated with this Management Pack.
    ```

7. `Enter a path to the Management Pack icon file, or leave blank for no icon`

   The icon is used in the VMware Aria Operations UI if present. If it is not present, a default icon will be used. The icon file must be
   png format and 256x256 px. An icon file can be added later by copying the icon to the root project directory and
   setting the value of the `"pak_icon"` key to the icon's file name in the `manifest.txt` file.

8. `Select a language for the adapter. Supported languages are [...]`

   Supported languages are listed. Once selected, the project will be generated, including a template adapter in the
   selected language. The template adapter collects several objects and metrics from the container that the adapter 
   is running in, and can be used as a starting point for creating a new adapter.

For complete documentation of the `mp-init` tool see the [MP Initialization Tool Documentation](doc/mp-init.md).

### Testing a Management Pack

In the Management Pack directory, the installation script writes a `requirements.txt` file containing the version of the
SDK used to generate the project, and installs the SDK into a virtual environment named `venv`. Note that the packages
in `requirements.txt` are _not_ installed into the adapter. To add a package to the adapter, specify it in the file
`adapter_requirements.txt`. 

To use the SDK, navigate to the newly-generated project directory and activate the virtual environment:

For Mac and Linux:
```sh
source venv/bin/activate
```
(This script is written for the bash shell. If you use the csh or fish shells, there are alternate activate.csh and activate.fish scripts you should use instead.)
For Windows:
```cmd
venv\Scripts\activate.bat
```
To exit the virtual environment, run `deactivate` in the virtual environment.

To test a project, run `mp-test`  in the virtual environment.

If `mp-test` is run from anywhere outside of a root project directory, the tool will prompt to choose a project, and will
test the selected project. If the tool is run from a project directory, the tool will automatically test that project.

`mp-test` will ask for a _connection_. No connections should exist, so choose **New Connection**. The test tool then
reads the `conf/describe.xml` file to find the connection parameters and credentials required for a connection, and
prompts for each. This is similar to creating a new _Adapter Instance_ in the VMware Aria Operations UI. Connections are automatically
saved per project, and can be reused when re-running the `mp-test` tool.

> Note: In the template project, the only connection parameter is `ID`, and because it connects to the container it is running on, this parameter is not necessary; it is only there as an example, and can be set to any value. The template also implements an example Test Connection. If a Test Connection is run (see below), with the `ID` set to the text `bad`, then the Test Connection will fail.

The test tool also asks for the method to test. There are four options:

* Test Connection - This call tests the connection and returns either an error message if the connection failed, or an
  empty json object if the connection succeeded.
* Collect - This call test the collection, and returns objects, metrics, properties, events, and relationships.
* Endpoint URLs - This returns a list (possibly empty) of URLs that have distinct SSL certificates that VMware Aria Operations can ask
  the end user to import into the TrustStore.
* Version - This returns
  the [VMware Aria Operations Collector API](vmware_aria_operations_integration_sdk/api/vmware-aria-operations-collector-fwk2.json) version the
  adapter implements. The implementation of this method is not generally handled by the developer.

For more information on these endpoints, see
the [Swagger API documentation](vmware_aria_operations_integration_sdk/api/vmware-aria-operations-collector-fwk2.json). Each
response is validated against the API.

For complete documentation of the `mp-test` tool see the [MP Test Tool Documentation](doc/mp-test.md).

### Building and Installing a Management Pack
To build a project, run `mp-build`  in the virtual environment.

If `mp-build` is run from anywhere outside of a root project directory, the tool will prompt to choose a project, and will
build the selected project. If the tool is run from a project directory, the tool will automatically build that
project.

Once the project is selected (if necessary), the tool will build the management pack and emit a `pak` file which can be 
installed on VMware Aria Operations. The `pak` file will be located in the project directory.

To install the `pak` file, in VMware Aria Operations navigate to **Data Sources &rarr; Integrations &rarr;
Repository** and click `ADD`. Select and upload the generated `pak` file, accept the README, and install the management pack.

To configure the management pack, VMware Aria Operations navigate to **Data Sources &rarr; Integrations &rarr;
Accounts** and click `ADD ACCOUNT`. Select the newly-installed management pack and configure the required fields. For 
`Collector/Group`, make sure that a cloud proxy collector is selected. Click `VALIDATE CONNECTION` to test the connection. 
It should return successfully, then click `ADD`.

By default, a collection will run every 5 minutes. The first collection should happen immediately, however newly-created
objects cannot have metrics, properties, and events added to them. After the second collection, approximately five
minutes later, the objects' metrics, properties, and events should appear. These can be checked by navigating to **
Environment &rarr; Object Browser &rarr; All Objects** and expanding the Adapter and associated object types and object.

![CPU Idle Time](doc/test-adapter-cpu-idle-time.png)
*The CPU object's `idle-time` metric in a Management Pack named `QAAdapterName`.*

For complete documentation of the `mp-build` tool see the [MP Build Tool Documentation](doc/mp-build.md).

## Contributing

The vmware-aria-operations-integration-sdk project team welcomes contributions from the community. Before you start
working with this project please read and sign our Contributor License Agreement (https://cla.vmware.com/cla/1/preview).
If you wish to contribute code and you have not signed our Contributor Licence Agreement (CLA), our bot will prompt you
to do so when you open a Pull Request. For any questions about the CLA process, please refer to our
[FAQ](https://cla.vmware.com/faq).

## License

This project is licensed under the APACHE-2 License.
