<p align="center">
  <a href="https://squidfunk.github.io/mkdocs-material/">
    <img src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/logo.png" width="320" alt="Material for MkDocs">
  </a>
</p>

<p align="center">
  <strong>
    A 
    <a href="https://traefik.io/">Traefik Labs</a> 
    <a href="https://material.io/">Material Design</a> 
    theme for 
    <a href="https://www.mkdocs.org/">MkDocs</a>
  </strong>
</p>

## Quick start

Material for MkDocs can be installed with `pip`:

```sh
pip install mkdocs-traefiklabs
```

Add the following line to `mkdocs.yml`:

```yaml
theme:
  name: traefik-labs
```

## How to run the project in Dev mode

### Pre-requisites

- Check your node version, the .nvmrc file mentions the expected version.
  If you use nvm, you can run `nvm use` to set the correct node version to the environment.
- Check if you have `mkdocs` installed locally (it requires Python).
  You can find installation instructions here: https://www.mkdocs.org/user-guide/installation/

### Steps:

- Install the dependencies `npm install`
- `npm run build` - this will generate the '/material' folder with the compiled theme (you need to re-run this if you add assets)
- `npm run start` - leave this running in a terminal, it will watch for code changes and rebuild the content (but not the assets)
- `npm run serve` - will launch a dev server at 127.0.0.1:8000 with the current theme, it has hot reload (not very precise, sometimes you need to hard refresh the page)

> If you wish to set the context to see other products information, you need to set the `product` config in the `mkdocs.yml` file in the project's root directory. The dev server should automatically reload and you will see the changes in the browser.

### Reminders:

- The 'material' directory generated by the `npm run build` is the one used in the documentation, so please don't forget running the build once you finish all the changes.
  TODO: add git hooks and run build on pre-push.
