"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCertificateRegion = exports.isDnsValidatedCertificate = exports.apexDomain = void 0;
const core_1 = require("@aws-cdk/core");
const public_suffixes_1 = require("./public-suffixes");
/**
 * Returns the apex domain (domain.com) from a subdomain (www.sub.domain.com)
 */
function apexDomain(domainName) {
    const parts = domainName.split('.').reverse();
    let curr = public_suffixes_1.publicSuffixes;
    const accumulated = [];
    for (const part of parts) {
        accumulated.push(part);
        if (!(part in curr)) {
            break;
        }
        curr = curr[part];
    }
    return accumulated.reverse().join('.');
}
exports.apexDomain = apexDomain;
function isDnsValidatedCertificate(cert) {
    return cert.hasOwnProperty('domainName');
}
exports.isDnsValidatedCertificate = isDnsValidatedCertificate;
function getCertificateRegion(cert) {
    const { certificateArn, stack } = cert;
    if (isDnsValidatedCertificate(cert)) {
        const requestResource = cert.node.findChild('CertificateRequestorResource').node.defaultChild;
        // @ts-ignore
        const { _cfnProperties: properties } = requestResource;
        const { Region: region } = properties;
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    {
        const { region } = core_1.Arn.parse(certificateArn);
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    return core_1.Stack.of(stack).region;
}
exports.getCertificateRegion = getCertificateRegion;
//# sourceMappingURL=data:application/json;base64,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