import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::CertificateManager::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html
 * @external
 */
export interface CfnCertificateProps {
    /**
     * `AWS::CertificateManager::Certificate.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainname
     * @external
     */
    readonly domainName: string;
    /**
     * `AWS::CertificateManager::Certificate.CertificateAuthorityArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificateauthorityarn
     * @external
     */
    readonly certificateAuthorityArn?: string;
    /**
     * `AWS::CertificateManager::Certificate.CertificateTransparencyLoggingPreference`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificatetransparencyloggingpreference
     * @external
     */
    readonly certificateTransparencyLoggingPreference?: string;
    /**
     * `AWS::CertificateManager::Certificate.DomainValidationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainvalidationoptions
     * @external
     */
    readonly domainValidationOptions?: Array<CfnCertificate.DomainValidationOptionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CertificateManager::Certificate.SubjectAlternativeNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-subjectalternativenames
     * @external
     */
    readonly subjectAlternativeNames?: string[];
    /**
     * `AWS::CertificateManager::Certificate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CertificateManager::Certificate.ValidationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-validationmethod
     * @external
     */
    readonly validationMethod?: string;
}
/**
 * A CloudFormation `AWS::CertificateManager::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html
 * @external
 * @cloudformationResource AWS::CertificateManager::Certificate
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CertificateManager::Certificate";
    /**
     * `AWS::CertificateManager::Certificate.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainname
     * @external
     */
    domainName: string;
    /**
     * `AWS::CertificateManager::Certificate.CertificateAuthorityArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificateauthorityarn
     * @external
     */
    certificateAuthorityArn: string | undefined;
    /**
     * `AWS::CertificateManager::Certificate.CertificateTransparencyLoggingPreference`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificatetransparencyloggingpreference
     * @external
     */
    certificateTransparencyLoggingPreference: string | undefined;
    /**
     * `AWS::CertificateManager::Certificate.DomainValidationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainvalidationoptions
     * @external
     */
    domainValidationOptions: Array<CfnCertificate.DomainValidationOptionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CertificateManager::Certificate.SubjectAlternativeNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-subjectalternativenames
     * @external
     */
    subjectAlternativeNames: string[] | undefined;
    /**
     * `AWS::CertificateManager::Certificate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CertificateManager::Certificate.ValidationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-validationmethod
     * @external
     */
    validationMethod: string | undefined;
    /**
     * Create a new `AWS::CertificateManager::Certificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CertificateManager::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html
 * @external
 * @cloudformationResource AWS::CertificateManager::Certificate
 */
export declare namespace CfnCertificate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html
     * @external
     */
    interface DomainValidationOptionProperty {
        /**
         * `CfnCertificate.DomainValidationOptionProperty.DomainName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
         * @external
         */
        readonly domainName: string;
        /**
         * `CfnCertificate.DomainValidationOptionProperty.HostedZoneId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-hostedzoneid
         * @external
         */
        readonly hostedZoneId?: string;
        /**
         * `CfnCertificate.DomainValidationOptionProperty.ValidationDomain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
         * @external
         */
        readonly validationDomain?: string;
    }
}
