"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineAnchoreInlineScanAction = void 0;
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
class CodePipelineAnchoreInlineScanAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.TEST,
            provider: 'CodeBuild',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.input],
        });
        this.props = props;
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    bound(scope, _stage, options) {
        var _a, _b, _c;
        const { account, region } = core_1.Stack.of(scope);
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0;
        const version = (_a = this.props.version) !== null && _a !== void 0 ? _a : 'v0.8.2';
        const timeout = (_b = this.props.timeout) !== null && _b !== void 0 ? _b : 300;
        const policyBundlePath = (_c = this.props.policyBundlePath) !== null && _c !== void 0 ? _c : './policy_bundle.json';
        const url = `https://ci-tools.anchore.io/inline_scan-${version}`;
        const project = new aws_codebuild_1.PipelineProject(scope, 'VulnScanProject', {
            cache: aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER),
            role: this.props.projectRole,
            environment: {
                buildImage,
                computeType: this.props.computeType || buildImage.defaultComputeType,
                privileged: true,
            },
            environmentVariables: this.props.customAnchoreImage
                ? {
                    ANCHORE_CI_IMAGE: {
                        value: this.props.customAnchoreImage,
                    },
                }
                : undefined,
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    pre_build: {
                        commands: [
                            'echo Build started on `date`',
                            'docker build -t image2scan:ci .',
                            'echo Build completed on `date`',
                            this.props.ecrLogin &&
                                `aws ecr get-login-password | docker login --username AWS --password-stdin ${account}.dkr.ecr.${region}.amazonaws.com`,
                        ],
                    },
                    build: {
                        commands: [
                            'echo Scan started on `date`',
                            `curl -s ${url} | if [ -f "${policyBundlePath}" ]; then bash -s -- -f -t ${timeout} -b ${policyBundlePath} image2scan:ci; else bash -s -- -f -t ${timeout} image2scan:ci; fi`,
                            'echo Scan completed on `date`',
                        ],
                    },
                },
            }),
        });
        // grant the Pipeline role the required permissions to this Project
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            resources: [project.projectArn],
            actions: ['codebuild:BatchGetBuilds', 'codebuild:StartBuild', 'codebuild:StopBuild'],
        }));
        // allow the Project access to the Pipeline's artifact Bucket
        // but only if the project is not imported
        // (ie., has a role) - otherwise, the IAM library throws an error
        if (project.role) {
            options.bucket.grantRead(project);
        }
        return {
            configuration: {
                ProjectName: project.projectName,
            },
        };
    }
}
exports.CodePipelineAnchoreInlineScanAction = CodePipelineAnchoreInlineScanAction;
//# sourceMappingURL=data:application/json;base64,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