# Python Wrapper for [d3js](https://d3js.org/) 

[![PyPI](https://img.shields.io/pypi/v/py3js)](https://pypi.org/project/py3js/) ![PyPI - License](https://img.shields.io/pypi/l/py3js)

## Why

**D3JS** is awesome, but such a pain to use from Python! This package aims to simplify that.

## Install

```
pip install py3js
```

## Supports

### Force Directed Graphs

Features:

- Specify radius, colour, border per node.
- Node labels and tooltips.
- Node links can be arrows or arcs, and they automatically adopt to node sizes.
- Node links can have labels.
- X-axis optional grouping.
- Zoom and pan.

#### Labels and Borders

![](media/lblbb.png)

#### Arrows, Arcs and Labels

![](media/lbl1.png)

![](media/lbl2.png)

#### X-Grouping

![](media/xgroup.png)

## Examples

Interactive examples are available in [Jupyter NBViewer](https://nbviewer.jupyter.org/github/aloneguid/py3js/tree/main/examples/).

