# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rpgpack',
 'rpgpack.commands',
 'rpgpack.commands.abstract',
 'rpgpack.events',
 'rpgpack.stars',
 'rpgpack.tables',
 'rpgpack.types',
 'rpgpack.utils']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.5,<4.0',
 'dice>=2.4.2,<3.0.0',
 'royalnet[telegram,alchemy_easy]>=5.6,<6.0',
 'sortedcontainers>=2.1.0,<3.0.0']

setup_kwargs = {
    'name': 'rpgpack',
    'version': '5.5',
    'description': 'A Royalnet Pack to play role-playing-games',
    'long_description': "<!--This documentation was autogenerated with `python -m royalnet.generate -f markdown`.-->\n\n# `rpgpack`\n\n## Commands\n\n### `roll`\n\nRoll a dice, from N to M (defaults to 1-100).\n\n> Aliases: `r` `random` \n\n### `dice`\n\nRoll a dice, using 'dice'.\n\n> Aliases: `d` \n\n### `dndactive`\n\nSet a DnD character as active.\n\n> Aliases: `da` `dnda` `active` `dactive` \n\n### `dndinfo`\n\nDisplay the character sheet of the active DnD character.\n\n> Aliases: `di` `dndi` `info` `dinfo` \n\n### `dndnew`\n\nCreate a new DnD character.\n\n> Aliases: `dn` `dndn` `new` `dnew` \n\n### `dndedit`\n\nEdit the active DnD character.\n\n> Aliases: `de` `dnde` `edit` `dedit` \n\n### `dndroll`\n\nRoll dice as the active DnD character.\n\n> Aliases: `dr` `dndr` `roll` `droll` \n\n### `dnditem`\n\nOttieni informazioni su un oggetto di D&D5e.\n\n> Aliases: `item` \n\n### `dndspell`\n\nOttieni informazioni su una magia di D&D5e.\n\n> Aliases: `spell` \n\n## Page Stars\n\n## Exception Stars\n\n## Tables\n\n### `dndactivecharacters`\n\n### `dndcharacters`\n\n",
    'author': 'Stefano Pigozzi',
    'author_email': 'ste.pigozzi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Steffo99/royalnet',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
