# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.v2022_04_04.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.v2022_04_04.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.v2022_04_04.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.v2022_04_04.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs
    ):
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class CloudService(_serialization.Model):
    """Describes the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Cloud service properties.
    :vartype properties: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceProperties
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.compute.v2022_04_04.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "CloudServiceProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudServiceProperties"] = None,
        system_data: Optional["_models.SystemData"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Cloud service properties.
        :paramtype properties: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceProperties
        :keyword system_data: The system meta data relating to this resource.
        :paramtype system_data: ~azure.mgmt.compute.v2022_04_04.models.SystemData
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.properties = properties
        self.system_data = system_data


class CloudServiceExtensionProfile(_serialization.Model):
    """Describes a cloud service extension profile.

    :ivar extensions: List of extensions for the cloud service.
    :vartype extensions: list[~azure.mgmt.compute.v2022_04_04.models.Extension]
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[Extension]"},
    }

    def __init__(self, *, extensions: Optional[List["_models.Extension"]] = None, **kwargs):
        """
        :keyword extensions: List of extensions for the cloud service.
        :paramtype extensions: list[~azure.mgmt.compute.v2022_04_04.models.Extension]
        """
        super().__init__(**kwargs)
        self.extensions = extensions


class CloudServiceExtensionProperties(_serialization.Model):
    """Extension Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension.
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the extension. Specifies the version of
     the extension. If this element is not specified or an asterisk (*) is used as the value, the
     latest version of the extension is used. If the value is specified with a major version number
     and an asterisk as the minor version number (X.), the latest minor version of the specified
     major version is selected. If a major version number and a minor version number are specified
     (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
     is performed on the role instance.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Explicitly specify whether platform can automatically upgrade
     typeHandlerVersion to higher minor versions when they become available.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Public settings for the extension. For JSON extensions, this is the JSON
     settings for the extension. For XML Extension (like RDP), this is the XML setting for the
     extension.
    :vartype settings: JSON
    :ivar protected_settings: Protected settings for the extension which are encrypted before sent
     to the role instance.
    :vartype protected_settings: JSON
    :ivar protected_settings_from_key_vault: Protected settings for the extension, referenced using
     KeyVault which are encrypted before sent to the role instance.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.v2022_04_04.models.CloudServiceVaultAndSecretReference
    :ivar force_update_tag: Tag to force apply the provided public and protected settings.
     Changing the tag value allows for re-running the extension without changing any of the public
     or protected settings.
     If forceUpdateTag is not changed, updates to public or protected settings would still be
     applied by the handler.
     If neither forceUpdateTag nor any of public or protected settings change, extension would flow
     to the role instance with the same sequence-number, and
     it is up to handler implementation whether to re-run it or not.
    :vartype force_update_tag: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar roles_applied_to: Optional list of roles to apply this extension. If property is not
     specified or '*' is specified, extension is applied to all roles in the cloud service.
    :vartype roles_applied_to: list[str]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "settings", "type": "object"},
        "protected_settings": {"key": "protectedSettings", "type": "object"},
        "protected_settings_from_key_vault": {
            "key": "protectedSettingsFromKeyVault",
            "type": "CloudServiceVaultAndSecretReference",
        },
        "force_update_tag": {"key": "forceUpdateTag", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "roles_applied_to": {"key": "rolesAppliedTo", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        protected_settings_from_key_vault: Optional["_models.CloudServiceVaultAndSecretReference"] = None,
        force_update_tag: Optional[str] = None,
        roles_applied_to: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension.
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the extension. Specifies the version of
         the extension. If this element is not specified or an asterisk (*) is used as the value, the
         latest version of the extension is used. If the value is specified with a major version number
         and an asterisk as the minor version number (X.), the latest minor version of the specified
         major version is selected. If a major version number and a minor version number are specified
         (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
         is performed on the role instance.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Explicitly specify whether platform can automatically
         upgrade typeHandlerVersion to higher minor versions when they become available.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Public settings for the extension. For JSON extensions, this is the JSON
         settings for the extension. For XML Extension (like RDP), this is the XML setting for the
         extension.
        :paramtype settings: JSON
        :keyword protected_settings: Protected settings for the extension which are encrypted before
         sent to the role instance.
        :paramtype protected_settings: JSON
        :keyword protected_settings_from_key_vault: Protected settings for the extension, referenced
         using KeyVault which are encrypted before sent to the role instance.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.v2022_04_04.models.CloudServiceVaultAndSecretReference
        :keyword force_update_tag: Tag to force apply the provided public and protected settings.
         Changing the tag value allows for re-running the extension without changing any of the public
         or protected settings.
         If forceUpdateTag is not changed, updates to public or protected settings would still be
         applied by the handler.
         If neither forceUpdateTag nor any of public or protected settings change, extension would flow
         to the role instance with the same sequence-number, and
         it is up to handler implementation whether to re-run it or not.
        :paramtype force_update_tag: str
        :keyword roles_applied_to: Optional list of roles to apply this extension. If property is not
         specified or '*' is specified, extension is applied to all roles in the cloud service.
        :paramtype roles_applied_to: list[str]
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.protected_settings_from_key_vault = protected_settings_from_key_vault
        self.force_update_tag = force_update_tag
        self.provisioning_state = None
        self.roles_applied_to = roles_applied_to


class CloudServiceInstanceView(_serialization.Model):
    """InstanceView of CloudService as a whole.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar role_instance: Instance view statuses.
    :vartype role_instance: ~azure.mgmt.compute.v2022_04_04.models.InstanceViewStatusesSummary
    :ivar sdk_version: The version of the SDK that was used to generate the package for the cloud
     service.
    :vartype sdk_version: str
    :ivar private_ids: Specifies a list of unique identifiers generated internally for the cloud
     service. :code:`<br />`:code:`<br />` NOTE: If you are using Azure Diagnostics extension, this
     property can be used as 'DeploymentId' for querying details.
    :vartype private_ids: list[str]
    :ivar statuses:
    :vartype statuses: list[~azure.mgmt.compute.v2022_04_04.models.ResourceInstanceViewStatus]
    """

    _validation = {
        "sdk_version": {"readonly": True},
        "private_ids": {"readonly": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "role_instance": {"key": "roleInstance", "type": "InstanceViewStatusesSummary"},
        "sdk_version": {"key": "sdkVersion", "type": "str"},
        "private_ids": {"key": "privateIds", "type": "[str]"},
        "statuses": {"key": "statuses", "type": "[ResourceInstanceViewStatus]"},
    }

    def __init__(self, *, role_instance: Optional["_models.InstanceViewStatusesSummary"] = None, **kwargs):
        """
        :keyword role_instance: Instance view statuses.
        :paramtype role_instance: ~azure.mgmt.compute.v2022_04_04.models.InstanceViewStatusesSummary
        """
        super().__init__(**kwargs)
        self.role_instance = role_instance
        self.sdk_version = None
        self.private_ids = None
        self.statuses = None


class CloudServiceListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_04_04.models.CloudService]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CloudService"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_04_04.models.CloudService]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceNetworkProfile(_serialization.Model):
    """Network Profile for the cloud service.

    :ivar load_balancer_configurations: List of Load balancer configurations. Cloud service can
     have up to two load balancer configurations, corresponding to a Public Load Balancer and an
     Internal Load Balancer.
    :vartype load_balancer_configurations:
     list[~azure.mgmt.compute.v2022_04_04.models.LoadBalancerConfiguration]
    :ivar slot_type: Slot type for the cloud service.
     Possible values are :code:`<br />`:code:`<br />`\ **Production**\ :code:`<br />`:code:`<br
     />`\ **Staging**\ :code:`<br />`:code:`<br />`
     If not specified, the default value is Production. Known values are: "Production" and
     "Staging".
    :vartype slot_type: str or ~azure.mgmt.compute.v2022_04_04.models.CloudServiceSlotType
    :ivar swappable_cloud_service: The id reference of the cloud service containing the target IP
     with which the subject cloud service can perform a swap. This property cannot be updated once
     it is set. The swappable cloud service referred by this id must be present otherwise an error
     will be thrown.
    :vartype swappable_cloud_service: ~azure.mgmt.compute.v2022_04_04.models.SubResource
    """

    _attribute_map = {
        "load_balancer_configurations": {"key": "loadBalancerConfigurations", "type": "[LoadBalancerConfiguration]"},
        "slot_type": {"key": "slotType", "type": "str"},
        "swappable_cloud_service": {"key": "swappableCloudService", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        load_balancer_configurations: Optional[List["_models.LoadBalancerConfiguration"]] = None,
        slot_type: Optional[Union[str, "_models.CloudServiceSlotType"]] = None,
        swappable_cloud_service: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword load_balancer_configurations: List of Load balancer configurations. Cloud service can
         have up to two load balancer configurations, corresponding to a Public Load Balancer and an
         Internal Load Balancer.
        :paramtype load_balancer_configurations:
         list[~azure.mgmt.compute.v2022_04_04.models.LoadBalancerConfiguration]
        :keyword slot_type: Slot type for the cloud service.
         Possible values are :code:`<br />`:code:`<br />`\ **Production**\ :code:`<br />`:code:`<br
         />`\ **Staging**\ :code:`<br />`:code:`<br />`
         If not specified, the default value is Production. Known values are: "Production" and
         "Staging".
        :paramtype slot_type: str or ~azure.mgmt.compute.v2022_04_04.models.CloudServiceSlotType
        :keyword swappable_cloud_service: The id reference of the cloud service containing the target
         IP with which the subject cloud service can perform a swap. This property cannot be updated
         once it is set. The swappable cloud service referred by this id must be present otherwise an
         error will be thrown.
        :paramtype swappable_cloud_service: ~azure.mgmt.compute.v2022_04_04.models.SubResource
        """
        super().__init__(**kwargs)
        self.load_balancer_configurations = load_balancer_configurations
        self.slot_type = slot_type
        self.swappable_cloud_service = swappable_cloud_service


class CloudServiceOsProfile(_serialization.Model):
    """Describes the OS profile for the cloud service.

    :ivar secrets: Specifies set of certificates that should be installed onto the role instances.
    :vartype secrets: list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceVaultSecretGroup]
    """

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[CloudServiceVaultSecretGroup]"},
    }

    def __init__(self, *, secrets: Optional[List["_models.CloudServiceVaultSecretGroup"]] = None, **kwargs):
        """
        :keyword secrets: Specifies set of certificates that should be installed onto the role
         instances.
        :paramtype secrets: list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceVaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.secrets = secrets


class CloudServiceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Cloud service properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar package_url: Specifies a URL that refers to the location of the service package in the
     Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
     account.
     This is a write-only property and is not returned in GET calls.
    :vartype package_url: str
    :ivar configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
    :vartype configuration: str
    :ivar configuration_url: Specifies a URL that refers to the location of the service
     configuration in the Blob service. The service package URL  can be Shared Access Signature
     (SAS) URI from any storage account.
     This is a write-only property and is not returned in GET calls.
    :vartype configuration_url: str
    :ivar start_cloud_service: (Optional) Indicates whether to start the cloud service immediately
     after it is created. The default value is ``true``.
     If false, the service model is still deployed, but the code is not run immediately. Instead,
     the service is PoweredOff until you call Start, at which time the service will be started. A
     deployed service still incurs charges, even if it is poweredoff.
    :vartype start_cloud_service: bool
    :ivar allow_model_override: (Optional) Indicates whether the role sku properties
     (roleProfile.roles.sku) specified in the model/template should override the role instance count
     and vm size specified in the .cscfg and .csdef respectively.
     The default value is ``false``.
    :vartype allow_model_override: bool
    :ivar upgrade_mode: Update mode for the cloud service. Role instances are allocated to update
     domains when the service is deployed. Updates can be initiated manually in each update domain
     or initiated automatically in all update domains.
     Possible Values are :code:`<br />`:code:`<br />`\ **Auto**\ :code:`<br />`:code:`<br />`\
     **Manual** :code:`<br />`:code:`<br />`\ **Simultaneous**\ :code:`<br />`:code:`<br />`
     If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
     to apply the update. If set to Auto, the update is automatically applied to each update domain
     in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
    :vartype upgrade_mode: str or ~azure.mgmt.compute.v2022_04_04.models.CloudServiceUpgradeMode
    :ivar role_profile: Describes the role profile for the cloud service.
    :vartype role_profile: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleProfile
    :ivar os_profile: Describes the OS profile for the cloud service.
    :vartype os_profile: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceOsProfile
    :ivar network_profile: Network Profile for the cloud service.
    :vartype network_profile: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceNetworkProfile
    :ivar extension_profile: Describes a cloud service extension profile.
    :vartype extension_profile: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceExtensionProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar unique_id: The unique identifier for the cloud service.
    :vartype unique_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "package_url": {"key": "packageUrl", "type": "str"},
        "configuration": {"key": "configuration", "type": "str"},
        "configuration_url": {"key": "configurationUrl", "type": "str"},
        "start_cloud_service": {"key": "startCloudService", "type": "bool"},
        "allow_model_override": {"key": "allowModelOverride", "type": "bool"},
        "upgrade_mode": {"key": "upgradeMode", "type": "str"},
        "role_profile": {"key": "roleProfile", "type": "CloudServiceRoleProfile"},
        "os_profile": {"key": "osProfile", "type": "CloudServiceOsProfile"},
        "network_profile": {"key": "networkProfile", "type": "CloudServiceNetworkProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "CloudServiceExtensionProfile"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_url: Optional[str] = None,
        configuration: Optional[str] = None,
        configuration_url: Optional[str] = None,
        start_cloud_service: Optional[bool] = None,
        allow_model_override: Optional[bool] = None,
        upgrade_mode: Optional[Union[str, "_models.CloudServiceUpgradeMode"]] = None,
        role_profile: Optional["_models.CloudServiceRoleProfile"] = None,
        os_profile: Optional["_models.CloudServiceOsProfile"] = None,
        network_profile: Optional["_models.CloudServiceNetworkProfile"] = None,
        extension_profile: Optional["_models.CloudServiceExtensionProfile"] = None,
        **kwargs
    ):
        """
        :keyword package_url: Specifies a URL that refers to the location of the service package in the
         Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
         account.
         This is a write-only property and is not returned in GET calls.
        :paramtype package_url: str
        :keyword configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
        :paramtype configuration: str
        :keyword configuration_url: Specifies a URL that refers to the location of the service
         configuration in the Blob service. The service package URL  can be Shared Access Signature
         (SAS) URI from any storage account.
         This is a write-only property and is not returned in GET calls.
        :paramtype configuration_url: str
        :keyword start_cloud_service: (Optional) Indicates whether to start the cloud service
         immediately after it is created. The default value is ``true``.
         If false, the service model is still deployed, but the code is not run immediately. Instead,
         the service is PoweredOff until you call Start, at which time the service will be started. A
         deployed service still incurs charges, even if it is poweredoff.
        :paramtype start_cloud_service: bool
        :keyword allow_model_override: (Optional) Indicates whether the role sku properties
         (roleProfile.roles.sku) specified in the model/template should override the role instance count
         and vm size specified in the .cscfg and .csdef respectively.
         The default value is ``false``.
        :paramtype allow_model_override: bool
        :keyword upgrade_mode: Update mode for the cloud service. Role instances are allocated to
         update domains when the service is deployed. Updates can be initiated manually in each update
         domain or initiated automatically in all update domains.
         Possible Values are :code:`<br />`:code:`<br />`\ **Auto**\ :code:`<br />`:code:`<br />`\
         **Manual** :code:`<br />`:code:`<br />`\ **Simultaneous**\ :code:`<br />`:code:`<br />`
         If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
         to apply the update. If set to Auto, the update is automatically applied to each update domain
         in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
        :paramtype upgrade_mode: str or ~azure.mgmt.compute.v2022_04_04.models.CloudServiceUpgradeMode
        :keyword role_profile: Describes the role profile for the cloud service.
        :paramtype role_profile: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleProfile
        :keyword os_profile: Describes the OS profile for the cloud service.
        :paramtype os_profile: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceOsProfile
        :keyword network_profile: Network Profile for the cloud service.
        :paramtype network_profile: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceNetworkProfile
        :keyword extension_profile: Describes a cloud service extension profile.
        :paramtype extension_profile:
         ~azure.mgmt.compute.v2022_04_04.models.CloudServiceExtensionProfile
        """
        super().__init__(**kwargs)
        self.package_url = package_url
        self.configuration = configuration
        self.configuration_url = configuration_url
        self.start_cloud_service = start_cloud_service
        self.allow_model_override = allow_model_override
        self.upgrade_mode = upgrade_mode
        self.role_profile = role_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.extension_profile = extension_profile
        self.provisioning_state = None
        self.unique_id = None


class CloudServiceRole(_serialization.Model):
    """Describes a role of the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleSku
    :ivar properties: The cloud service role properties.
    :vartype properties: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
        "properties": {"key": "properties", "type": "CloudServiceRoleProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.CloudServiceRoleSku"] = None,
        properties: Optional["_models.CloudServiceRoleProperties"] = None,
        **kwargs
    ):
        """
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleSku
        :keyword properties: The cloud service role properties.
        :paramtype properties: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.sku = sku
        self.properties = properties


class CloudServiceRoleListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceRole]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudServiceRole]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CloudServiceRole"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceRole]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceRoleProfile(_serialization.Model):
    """Describes the role profile for the cloud service.

    :ivar roles: List of roles for the cloud service.
    :vartype roles: list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleProfileProperties]
    """

    _attribute_map = {
        "roles": {"key": "roles", "type": "[CloudServiceRoleProfileProperties]"},
    }

    def __init__(self, *, roles: Optional[List["_models.CloudServiceRoleProfileProperties"]] = None, **kwargs):
        """
        :keyword roles: List of roles for the cloud service.
        :paramtype roles:
         list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleProfileProperties]
        """
        super().__init__(**kwargs)
        self.roles = roles


class CloudServiceRoleProfileProperties(_serialization.Model):
    """Describes the role properties.

    :ivar name: Resource name.
    :vartype name: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleSku
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
    }

    def __init__(self, *, name: Optional[str] = None, sku: Optional["_models.CloudServiceRoleSku"] = None, **kwargs):
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceRoleSku
        """
        super().__init__(**kwargs)
        self.name = name
        self.sku = sku


class CloudServiceRoleProperties(_serialization.Model):
    """The cloud service role properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_id: Specifies the ID which uniquely identifies a cloud service role.
    :vartype unique_id: str
    """

    _validation = {
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.unique_id = None


class CloudServiceRoleSku(_serialization.Model):
    """Describes the cloud service role sku.

    :ivar name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
     service is currently on, you need to delete and recreate the cloud service or move back to the
     old sku.
    :vartype name: str
    :ivar tier: Specifies the tier of the cloud service. Possible Values are :code:`<br
     />`:code:`<br />` **Standard** :code:`<br />`:code:`<br />` **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of role instances in the cloud service.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs
    ):
        """
        :keyword name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
         service is currently on, you need to delete and recreate the cloud service or move back to the
         old sku.
        :paramtype name: str
        :keyword tier: Specifies the tier of the cloud service. Possible Values are :code:`<br
         />`:code:`<br />` **Standard** :code:`<br />`:code:`<br />` **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of role instances in the cloud service.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class CloudServiceUpdate(_serialization.Model):
    """CloudServiceUpdate.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class CloudServiceVaultAndSecretReference(_serialization.Model):
    """Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.

    :ivar source_vault: The ARM Resource ID of the Key Vault.
    :vartype source_vault: ~azure.mgmt.compute.v2022_04_04.models.SubResource
    :ivar secret_url: Secret URL which contains the protected settings of the extension.
    :vartype secret_url: str
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "secret_url": {"key": "secretUrl", "type": "str"},
    }

    def __init__(
        self, *, source_vault: Optional["_models.SubResource"] = None, secret_url: Optional[str] = None, **kwargs
    ):
        """
        :keyword source_vault: The ARM Resource ID of the Key Vault.
        :paramtype source_vault: ~azure.mgmt.compute.v2022_04_04.models.SubResource
        :keyword secret_url: Secret URL which contains the protected settings of the extension.
        :paramtype secret_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class CloudServiceVaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the role instance.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret.
    :vartype certificate_url: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
    }

    def __init__(self, *, certificate_url: Optional[str] = None, **kwargs):
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url


class CloudServiceVaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.v2022_04_04.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates:
     list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceVaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[CloudServiceVaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.CloudServiceVaultCertificate"]] = None,
        **kwargs
    ):
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.v2022_04_04.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates:
         list[~azure.mgmt.compute.v2022_04_04.models.CloudServiceVaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.compute.v2022_04_04.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.compute.v2022_04_04.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Extension(_serialization.Model):
    """Describes a cloud service Extension.

    :ivar name: The name of the extension.
    :vartype name: str
    :ivar properties: Extension Properties.
    :vartype properties: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceExtensionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "CloudServiceExtensionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.CloudServiceExtensionProperties"] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword properties: Extension Properties.
        :paramtype properties: ~azure.mgmt.compute.v2022_04_04.models.CloudServiceExtensionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs):
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceSku(_serialization.Model):
    """The role instance SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: The tier of the cloud service role instance.
    :vartype tier: str
    """

    _validation = {
        "name": {"readonly": True},
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.tier = None


class InstanceViewStatusesSummary(_serialization.Model):
    """Instance view statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The summary.
    :vartype statuses_summary: list[~azure.mgmt.compute.v2022_04_04.models.StatusCodeCount]
    """

    _validation = {
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "statuses_summary": {"key": "statusesSummary", "type": "[StatusCodeCount]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.statuses_summary = None


class LoadBalancerConfiguration(_serialization.Model):
    """Describes the load balancer configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the Load balancer. Required.
    :vartype name: str
    :ivar properties: Properties of the load balancer configuration. Required.
    :vartype properties: ~azure.mgmt.compute.v2022_04_04.models.LoadBalancerConfigurationProperties
    """

    _validation = {
        "name": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "LoadBalancerConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        name: str,
        properties: "_models.LoadBalancerConfigurationProperties",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the Load balancer. Required.
        :paramtype name: str
        :keyword properties: Properties of the load balancer configuration. Required.
        :paramtype properties:
         ~azure.mgmt.compute.v2022_04_04.models.LoadBalancerConfigurationProperties
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.properties = properties


class LoadBalancerConfigurationProperties(_serialization.Model):
    """Describes the properties of the load balancer configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar frontend_ip_configurations: Specifies the frontend IP to be used for the load balancer.
     Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly
     one frontend IP configuration. Required.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.compute.v2022_04_04.models.LoadBalancerFrontendIPConfiguration]
    """

    _validation = {
        "frontend_ip_configurations": {"required": True},
    }

    _attribute_map = {
        "frontend_ip_configurations": {
            "key": "frontendIPConfigurations",
            "type": "[LoadBalancerFrontendIPConfiguration]",
        },
    }

    def __init__(self, *, frontend_ip_configurations: List["_models.LoadBalancerFrontendIPConfiguration"], **kwargs):
        """
        :keyword frontend_ip_configurations: Specifies the frontend IP to be used for the load
         balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must
         have exactly one frontend IP configuration. Required.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.compute.v2022_04_04.models.LoadBalancerFrontendIPConfiguration]
        """
        super().__init__(**kwargs)
        self.frontend_ip_configurations = frontend_ip_configurations


class LoadBalancerFrontendIPConfiguration(_serialization.Model):
    """Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the resource that is unique within the set of frontend IP
     configurations used by the load balancer. This name can be used to access the resource.
     Required.
    :vartype name: str
    :ivar properties: Properties of load balancer frontend ip configuration. Required.
    :vartype properties:
     ~azure.mgmt.compute.v2022_04_04.models.LoadBalancerFrontendIPConfigurationProperties
    """

    _validation = {
        "name": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "LoadBalancerFrontendIPConfigurationProperties"},
    }

    def __init__(self, *, name: str, properties: "_models.LoadBalancerFrontendIPConfigurationProperties", **kwargs):
        """
        :keyword name: The name of the resource that is unique within the set of frontend IP
         configurations used by the load balancer. This name can be used to access the resource.
         Required.
        :paramtype name: str
        :keyword properties: Properties of load balancer frontend ip configuration. Required.
        :paramtype properties:
         ~azure.mgmt.compute.v2022_04_04.models.LoadBalancerFrontendIPConfigurationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class LoadBalancerFrontendIPConfigurationProperties(_serialization.Model):
    """Describes a cloud service IP Configuration.

    :ivar public_ip_address: The reference to the public ip address resource.
    :vartype public_ip_address: ~azure.mgmt.compute.v2022_04_04.models.SubResource
    :ivar subnet: The reference to the virtual network subnet resource.
    :vartype subnet: ~azure.mgmt.compute.v2022_04_04.models.SubResource
    :ivar private_ip_address: The virtual network private IP address of the IP configuration.
    :vartype private_ip_address: str
    """

    _attribute_map = {
        "public_ip_address": {"key": "publicIPAddress", "type": "SubResource"},
        "subnet": {"key": "subnet", "type": "SubResource"},
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_ip_address: Optional["_models.SubResource"] = None,
        subnet: Optional["_models.SubResource"] = None,
        private_ip_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword public_ip_address: The reference to the public ip address resource.
        :paramtype public_ip_address: ~azure.mgmt.compute.v2022_04_04.models.SubResource
        :keyword subnet: The reference to the virtual network subnet resource.
        :paramtype subnet: ~azure.mgmt.compute.v2022_04_04.models.SubResource
        :keyword private_ip_address: The virtual network private IP address of the IP configuration.
        :paramtype private_ip_address: str
        """
        super().__init__(**kwargs)
        self.public_ip_address = public_ip_address
        self.subnet = subnet
        self.private_ip_address = private_ip_address


class OSFamily(_serialization.Model):
    """Describes a cloud service OS family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar properties: OS family properties.
    :vartype properties: ~azure.mgmt.compute.v2022_04_04.models.OSFamilyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "OSFamilyProperties"},
    }

    def __init__(self, *, properties: Optional["_models.OSFamilyProperties"] = None, **kwargs):
        """
        :keyword properties: OS family properties.
        :paramtype properties: ~azure.mgmt.compute.v2022_04_04.models.OSFamilyProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class OSFamilyListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_04_04.models.OSFamily]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OSFamily]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.OSFamily"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_04_04.models.OSFamily]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSFamilyProperties(_serialization.Model):
    """OS family properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The OS family name.
    :vartype name: str
    :ivar label: The OS family label.
    :vartype label: str
    :ivar versions: List of OS versions belonging to this family.
    :vartype versions: list[~azure.mgmt.compute.v2022_04_04.models.OSVersionPropertiesBase]
    """

    _validation = {
        "name": {"readonly": True},
        "label": {"readonly": True},
        "versions": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "versions": {"key": "versions", "type": "[OSVersionPropertiesBase]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.label = None
        self.versions = None


class OSVersion(_serialization.Model):
    """Describes a cloud service OS version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar properties: OS version properties.
    :vartype properties: ~azure.mgmt.compute.v2022_04_04.models.OSVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "OSVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.OSVersionProperties"] = None, **kwargs):
        """
        :keyword properties: OS version properties.
        :paramtype properties: ~azure.mgmt.compute.v2022_04_04.models.OSVersionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class OSVersionListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_04_04.models.OSVersion]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OSVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.OSVersion"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_04_04.models.OSVersion]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSVersionProperties(_serialization.Model):
    """OS version properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar family: The family of this OS version.
    :vartype family: str
    :ivar family_label: The family label of this OS version.
    :vartype family_label: str
    :ivar version: The OS version.
    :vartype version: str
    :ivar label: The OS version label.
    :vartype label: str
    :ivar is_default: Specifies whether this is the default OS version for its family.
    :vartype is_default: bool
    :ivar is_active: Specifies whether this OS version is active.
    :vartype is_active: bool
    """

    _validation = {
        "family": {"readonly": True},
        "family_label": {"readonly": True},
        "version": {"readonly": True},
        "label": {"readonly": True},
        "is_default": {"readonly": True},
        "is_active": {"readonly": True},
    }

    _attribute_map = {
        "family": {"key": "family", "type": "str"},
        "family_label": {"key": "familyLabel", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "is_active": {"key": "isActive", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.family = None
        self.family_label = None
        self.version = None
        self.label = None
        self.is_default = None
        self.is_active = None


class OSVersionPropertiesBase(_serialization.Model):
    """Configuration view of an OS version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The OS version.
    :vartype version: str
    :ivar label: The OS version label.
    :vartype label: str
    :ivar is_default: Specifies whether this is the default OS version for its family.
    :vartype is_default: bool
    :ivar is_active: Specifies whether this OS version is active.
    :vartype is_active: bool
    """

    _validation = {
        "version": {"readonly": True},
        "label": {"readonly": True},
        "is_default": {"readonly": True},
        "is_active": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "is_active": {"key": "isActive", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.label = None
        self.is_default = None
        self.is_active = None


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ResourceInstanceViewStatus(_serialization.Model):
    """Instance view status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status code.
    :vartype code: str
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.v2022_04_04.models.StatusLevelTypes
    """

    _validation = {
        "code": {"readonly": True},
        "display_status": {"readonly": True},
        "message": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
        "level": {"key": "level", "type": "str"},
    }

    def __init__(self, *, level: Optional[Union[str, "_models.StatusLevelTypes"]] = None, **kwargs):
        """
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.v2022_04_04.models.StatusLevelTypes
        """
        super().__init__(**kwargs)
        self.code = None
        self.display_status = None
        self.message = None
        self.time = None
        self.level = level


class ResourceWithOptionalLocation(_serialization.Model):
    """The Resource model definition with location property as optional.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class RoleInstance(_serialization.Model):
    """Describes the cloud service role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The role instance SKU.
    :vartype sku: ~azure.mgmt.compute.v2022_04_04.models.InstanceSku
    :ivar properties: Role instance properties.
    :vartype properties: ~azure.mgmt.compute.v2022_04_04.models.RoleInstanceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "InstanceSku"},
        "properties": {"key": "properties", "type": "RoleInstanceProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.InstanceSku"] = None,
        properties: Optional["_models.RoleInstanceProperties"] = None,
        **kwargs
    ):
        """
        :keyword sku: The role instance SKU.
        :paramtype sku: ~azure.mgmt.compute.v2022_04_04.models.InstanceSku
        :keyword properties: Role instance properties.
        :paramtype properties: ~azure.mgmt.compute.v2022_04_04.models.RoleInstanceProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None
        self.sku = sku
        self.properties = properties


class RoleInstanceListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_04_04.models.RoleInstance]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RoleInstance"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_04_04.models.RoleInstance]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleInstanceNetworkProfile(_serialization.Model):
    """Describes the network profile for the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the role instance.
    :vartype network_interfaces: list[~azure.mgmt.compute.v2022_04_04.models.SubResource]
    """

    _validation = {
        "network_interfaces": {"readonly": True},
    }

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[SubResource]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.network_interfaces = None


class RoleInstanceProperties(_serialization.Model):
    """Role instance properties.

    :ivar network_profile: Describes the network profile for the role instance.
    :vartype network_profile: ~azure.mgmt.compute.v2022_04_04.models.RoleInstanceNetworkProfile
    :ivar instance_view: The instance view of the role instance.
    :vartype instance_view: ~azure.mgmt.compute.v2022_04_04.models.RoleInstanceView
    """

    _attribute_map = {
        "network_profile": {"key": "networkProfile", "type": "RoleInstanceNetworkProfile"},
        "instance_view": {"key": "instanceView", "type": "RoleInstanceView"},
    }

    def __init__(
        self,
        *,
        network_profile: Optional["_models.RoleInstanceNetworkProfile"] = None,
        instance_view: Optional["_models.RoleInstanceView"] = None,
        **kwargs
    ):
        """
        :keyword network_profile: Describes the network profile for the role instance.
        :paramtype network_profile: ~azure.mgmt.compute.v2022_04_04.models.RoleInstanceNetworkProfile
        :keyword instance_view: The instance view of the role instance.
        :paramtype instance_view: ~azure.mgmt.compute.v2022_04_04.models.RoleInstanceView
        """
        super().__init__(**kwargs)
        self.network_profile = network_profile
        self.instance_view = instance_view


class RoleInstances(_serialization.Model):
    """Specifies a list of role instances from the cloud service.

    All required parameters must be populated in order to send to Azure.

    :ivar role_instances: List of cloud service role instance names. Value of '*' will signify all
     role instances of the cloud service. Required.
    :vartype role_instances: list[str]
    """

    _validation = {
        "role_instances": {"required": True},
    }

    _attribute_map = {
        "role_instances": {"key": "roleInstances", "type": "[str]"},
    }

    def __init__(self, *, role_instances: List[str], **kwargs):
        """
        :keyword role_instances: List of cloud service role instance names. Value of '*' will signify
         all role instances of the cloud service. Required.
        :paramtype role_instances: list[str]
        """
        super().__init__(**kwargs)
        self.role_instances = role_instances


class RoleInstanceView(_serialization.Model):
    """The instance view of the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: The Update Domain.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain.
    :vartype platform_fault_domain: int
    :ivar private_id: Specifies a unique identifier generated internally for the cloud service
     associated with this role instance. :code:`<br />`:code:`<br />` NOTE: If you are using Azure
     Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
    :vartype private_id: str
    :ivar statuses:
    :vartype statuses: list[~azure.mgmt.compute.v2022_04_04.models.ResourceInstanceViewStatus]
    """

    _validation = {
        "platform_update_domain": {"readonly": True},
        "platform_fault_domain": {"readonly": True},
        "private_id": {"readonly": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "private_id": {"key": "privateId", "type": "str"},
        "statuses": {"key": "statuses", "type": "[ResourceInstanceViewStatus]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.platform_update_domain = None
        self.platform_fault_domain = None
        self.private_id = None
        self.statuses = None


class StatusCodeCount(_serialization.Model):
    """The status code and count of the cloud service instance view statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: Number of instances having this status code.
    :vartype count: int
    """

    _validation = {
        "code": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.count = None


class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SubResourceReadOnly(_serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class SystemData(_serialization.Model):
    """The system meta data relating to this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_at: Specifies the time in UTC at which the Cloud Service (extended support)
     resource was created. :code:`<br />`Minimum api-version: 2022-04-04.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Specifies the time in UTC at which the Cloud Service (extended support)
     resource was last modified. :code:`<br />`Minimum api-version: 2022-04-04.
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        "created_at": {"readonly": True},
        "last_modified_at": {"readonly": True},
    }

    _attribute_map = {
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.created_at = None
        self.last_modified_at = None


class UpdateDomain(_serialization.Model):
    """Defines an update domain for the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None


class UpdateDomainListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.v2022_04_04.models.UpdateDomain]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpdateDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.UpdateDomain"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.v2022_04_04.models.UpdateDomain]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
