#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `SETUP_TEMPLATE.py.jinja2` IN the `dev/provider_packages` DIRECTORY

"""Setup.py for the apache-airflow-providers-google package."""

import logging
import os

from os.path import dirname
from setuptools import find_namespace_packages, setup

logger = logging.getLogger(__name__)

version = '6.1.0'

my_dir = dirname(__file__)

try:
    with open(os.path.join(my_dir, 'README.rst'), encoding='utf-8') as f:
        long_description = f.read()
except FileNotFoundError:
    long_description = ''


def do_setup():
    """Perform the package apache-airflow-providers-google setup."""
    setup(
        name='apache-airflow-providers-google',
        description='Provider package ' 'apache-airflow-providers-google for Apache Airflow',
        long_description=long_description,
        long_description_content_type='text/x-rst',
        license='Apache License 2.0',
        version=version,
        packages=find_namespace_packages(include=['airflow.providers.google', 'airflow.providers.google.*']),
        zip_safe=False,
        include_package_data=True,
        install_requires=[
            'apache-airflow>=2.1.0',
            'PyOpenSSL',
            'google-ads>=12.0.0,<14.0.1',
            'google-api-core>=1.25.1,<3.0.0',
            'google-api-python-client>=1.6.0,<2.0.0',
            'google-auth-httplib2>=0.0.1',
            'google-auth>=1.0.0,<3.0.0',
            'google-cloud-automl>=2.1.0,<3.0.0',
            'google-cloud-bigquery-datatransfer>=3.0.0,<4.0.0',
            'google-cloud-bigtable>=1.0.0,<2.0.0',
            'google-cloud-build>=3.0.0,<4.0.0',
            'google-cloud-container>=0.1.1,<2.0.0',
            'google-cloud-datacatalog>=3.0.0,<4.0.0',
            'google-cloud-dataproc>=2.2.0,<4.0.0',
            'google-cloud-dlp>=0.11.0,<2.0.0',
            'google-cloud-kms>=2.0.0,<3.0.0',
            'google-cloud-language>=1.1.1,<2.0.0',
            'google-cloud-logging>=2.1.1,<3.0.0',
            'google-cloud-memcache>=0.2.0,<1.1.0',
            'google-cloud-monitoring>=2.0.0,<3.0.0',
            'google-cloud-os-login>=2.0.0,<3.0.0',
            'google-cloud-pubsub>=2.0.0,<3.0.0',
            'google-cloud-redis>=2.0.0,<3.0.0',
            'google-cloud-secret-manager>=0.2.0,<2.0.0',
            'google-cloud-spanner>=1.10.0,<2.0.0',
            'google-cloud-speech>=0.36.3,<2.0.0',
            'google-cloud-storage>=1.30,<2.0.0',
            'google-cloud-tasks>=2.0.0,<3.0.0',
            'google-cloud-texttospeech>=0.4.0,<2.0.0',
            'google-cloud-translate>=1.5.0,<2.0.0',
            'google-cloud-videointelligence>=1.7.0,<2.0.0',
            'google-cloud-vision>=0.35.2,<2.0.0',
            'google-cloud-workflows>=0.1.0,<2.0.0',
            'grpcio-gcp>=0.2.2',
            'httpx',
            'json-merge-patch~=0.2',
            'pandas-gbq<0.15.0',
            'pandas>=0.17.1, <2.0',
        ],
        setup_requires=['setuptools', 'wheel'],
        extras_require={
            'amazon': ['apache-airflow-providers-amazon'],
            'apache.beam': ['apache-airflow-providers-apache-beam', 'apache-beam[gcp]'],
            'apache.cassandra': ['apache-airflow-providers-apache-cassandra'],
            'cncf.kubernetes': ['apache-airflow-providers-cncf-kubernetes'],
            'facebook': ['apache-airflow-providers-facebook'],
            'microsoft.azure': ['apache-airflow-providers-microsoft-azure'],
            'microsoft.mssql': ['apache-airflow-providers-microsoft-mssql'],
            'mysql': ['apache-airflow-providers-mysql'],
            'oracle': ['apache-airflow-providers-oracle'],
            'postgres': ['apache-airflow-providers-postgres'],
            'presto': ['apache-airflow-providers-presto'],
            'salesforce': ['apache-airflow-providers-salesforce'],
            'sftp': ['apache-airflow-providers-sftp'],
            'ssh': ['apache-airflow-providers-ssh'],
            'trino': ['apache-airflow-providers-trino'],
            'leveldb': 'plyvel',
        },
        classifiers=[
            'Development Status :: 5 - Production/Stable',
            'Environment :: Console',
            'Environment :: Web Environment',
            'Intended Audience :: Developers',
            'Intended Audience :: System Administrators',
            'License :: OSI Approved :: Apache Software License',
            'Programming Language :: Python :: 3.6',
            'Programming Language :: Python :: 3.7',
            'Programming Language :: Python :: 3.8',
            'Programming Language :: Python :: 3.9',
            'Topic :: System :: Monitoring',
        ],
        author='Apache Software Foundation',
        author_email='dev@airflow.apache.org',
        url='https://airflow.apache.org/',
        download_url='https://archive.apache.org/dist/airflow/providers',
        python_requires='~=3.6',
        project_urls={
            'Documentation': 'https://airflow.apache.org/docs/apache-airflow-providers-google/6.1.0/',
            'Bug Tracker': 'https://github.com/apache/airflow/issues',
            'Source Code': 'https://github.com/apache/airflow',
            'Slack Chat': 'https://s.apache.org/airflow-slack',
            'Twitter': 'https://twitter.com/ApacheAirflow',
            'YouTube': 'https://www.youtube.com/channel/UCSXwxpWZQ7XZ1WL3wqevChA/',
        },
    )


if __name__ == "__main__":
    do_setup()
